/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrBodySkeletonJointHTC;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodySkeletonHTC
extends Struct<XrBodySkeletonHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int JOINTCOUNT;
    public static final int JOINTS;

    protected XrBodySkeletonHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrBodySkeletonHTC create(long address, @Nullable ByteBuffer container) {
        return new XrBodySkeletonHTC(address, container);
    }

    public XrBodySkeletonHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBodySkeletonHTC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBodySkeletonHTC.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrBodySkeletonHTC.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int jointCount() {
        return XrBodySkeletonHTC.njointCount(this.address());
    }

    @NativeType(value="XrBodySkeletonJointHTC *")
    public XrBodySkeletonJointHTC.Buffer joints() {
        return XrBodySkeletonHTC.njoints(this.address());
    }

    public XrBodySkeletonHTC type(@NativeType(value="XrStructureType") int value) {
        XrBodySkeletonHTC.ntype(this.address(), value);
        return this;
    }

    public XrBodySkeletonHTC type$Default() {
        return this.type(1000320004);
    }

    public XrBodySkeletonHTC next(@NativeType(value="void *") long value) {
        XrBodySkeletonHTC.nnext(this.address(), value);
        return this;
    }

    public XrBodySkeletonHTC joints(@NativeType(value="XrBodySkeletonJointHTC *") XrBodySkeletonJointHTC.Buffer value) {
        XrBodySkeletonHTC.njoints(this.address(), value);
        return this;
    }

    public XrBodySkeletonHTC set(int type, long next, XrBodySkeletonJointHTC.Buffer joints) {
        this.type(type);
        this.next(next);
        this.joints(joints);
        return this;
    }

    public XrBodySkeletonHTC set(XrBodySkeletonHTC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBodySkeletonHTC malloc() {
        return new XrBodySkeletonHTC(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrBodySkeletonHTC calloc() {
        return new XrBodySkeletonHTC(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrBodySkeletonHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrBodySkeletonHTC(MemoryUtil.memAddress(container), container);
    }

    public static XrBodySkeletonHTC create(long address) {
        return new XrBodySkeletonHTC(address, null);
    }

    public static @Nullable XrBodySkeletonHTC createSafe(long address) {
        return address == 0L ? null : new XrBodySkeletonHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrBodySkeletonHTC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodySkeletonHTC.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBodySkeletonHTC malloc(MemoryStack stack) {
        return new XrBodySkeletonHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBodySkeletonHTC calloc(MemoryStack stack) {
        return new XrBodySkeletonHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int njointCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)JOINTCOUNT);
    }

    public static XrBodySkeletonJointHTC.Buffer njoints(long struct) {
        return XrBodySkeletonJointHTC.create(MemoryUtil.memGetAddress(struct + (long)JOINTS), XrBodySkeletonHTC.njointCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void njointCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)JOINTCOUNT, value);
    }

    public static void njoints(long struct, XrBodySkeletonJointHTC.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)JOINTS, value.address());
        XrBodySkeletonHTC.njointCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)JOINTS));
    }

    static {
        Struct.Layout layout = XrBodySkeletonHTC.__struct(XrBodySkeletonHTC.__member(4), XrBodySkeletonHTC.__member(POINTER_SIZE), XrBodySkeletonHTC.__member(4), XrBodySkeletonHTC.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        JOINTCOUNT = layout.offsetof(2);
        JOINTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrBodySkeletonHTC, Buffer>
    implements NativeResource {
        private static final XrBodySkeletonHTC ELEMENT_FACTORY = XrBodySkeletonHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrBodySkeletonHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBodySkeletonHTC.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrBodySkeletonHTC.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int jointCount() {
            return XrBodySkeletonHTC.njointCount(this.address());
        }

        @NativeType(value="XrBodySkeletonJointHTC *")
        public XrBodySkeletonJointHTC.Buffer joints() {
            return XrBodySkeletonHTC.njoints(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBodySkeletonHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000320004);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrBodySkeletonHTC.nnext(this.address(), value);
            return this;
        }

        public Buffer joints(@NativeType(value="XrBodySkeletonJointHTC *") XrBodySkeletonJointHTC.Buffer value) {
            XrBodySkeletonHTC.njoints(this.address(), value);
            return this;
        }
    }
}

