/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodySkeletonJointFB
extends Struct<XrBodySkeletonJointFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int JOINT;
    public static final int PARENTJOINT;
    public static final int POSE;

    protected XrBodySkeletonJointFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrBodySkeletonJointFB create(long address, @Nullable ByteBuffer container) {
        return new XrBodySkeletonJointFB(address, container);
    }

    public XrBodySkeletonJointFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBodySkeletonJointFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int joint() {
        return XrBodySkeletonJointFB.njoint(this.address());
    }

    @NativeType(value="int32_t")
    public int parentJoint() {
        return XrBodySkeletonJointFB.nparentJoint(this.address());
    }

    public XrPosef pose() {
        return XrBodySkeletonJointFB.npose(this.address());
    }

    public XrBodySkeletonJointFB joint(@NativeType(value="int32_t") int value) {
        XrBodySkeletonJointFB.njoint(this.address(), value);
        return this;
    }

    public XrBodySkeletonJointFB parentJoint(@NativeType(value="int32_t") int value) {
        XrBodySkeletonJointFB.nparentJoint(this.address(), value);
        return this;
    }

    public XrBodySkeletonJointFB pose(XrPosef value) {
        XrBodySkeletonJointFB.npose(this.address(), value);
        return this;
    }

    public XrBodySkeletonJointFB pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrBodySkeletonJointFB set(int joint, int parentJoint, XrPosef pose) {
        this.joint(joint);
        this.parentJoint(parentJoint);
        this.pose(pose);
        return this;
    }

    public XrBodySkeletonJointFB set(XrBodySkeletonJointFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBodySkeletonJointFB malloc() {
        return new XrBodySkeletonJointFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrBodySkeletonJointFB calloc() {
        return new XrBodySkeletonJointFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrBodySkeletonJointFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrBodySkeletonJointFB(MemoryUtil.memAddress(container), container);
    }

    public static XrBodySkeletonJointFB create(long address) {
        return new XrBodySkeletonJointFB(address, null);
    }

    public static @Nullable XrBodySkeletonJointFB createSafe(long address) {
        return address == 0L ? null : new XrBodySkeletonJointFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrBodySkeletonJointFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodySkeletonJointFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBodySkeletonJointFB malloc(MemoryStack stack) {
        return new XrBodySkeletonJointFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBodySkeletonJointFB calloc(MemoryStack stack) {
        return new XrBodySkeletonJointFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int njoint(long struct) {
        return MemoryUtil.memGetInt(struct + (long)JOINT);
    }

    public static int nparentJoint(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PARENTJOINT);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static void njoint(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)JOINT, value);
    }

    public static void nparentJoint(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PARENTJOINT, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrBodySkeletonJointFB.__struct(XrBodySkeletonJointFB.__member(4), XrBodySkeletonJointFB.__member(4), XrBodySkeletonJointFB.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        JOINT = layout.offsetof(0);
        PARENTJOINT = layout.offsetof(1);
        POSE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrBodySkeletonJointFB, Buffer>
    implements NativeResource {
        private static final XrBodySkeletonJointFB ELEMENT_FACTORY = XrBodySkeletonJointFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrBodySkeletonJointFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int joint() {
            return XrBodySkeletonJointFB.njoint(this.address());
        }

        @NativeType(value="int32_t")
        public int parentJoint() {
            return XrBodySkeletonJointFB.nparentJoint(this.address());
        }

        public XrPosef pose() {
            return XrBodySkeletonJointFB.npose(this.address());
        }

        public Buffer joint(@NativeType(value="int32_t") int value) {
            XrBodySkeletonJointFB.njoint(this.address(), value);
            return this;
        }

        public Buffer parentJoint(@NativeType(value="int32_t") int value) {
            XrBodySkeletonJointFB.nparentJoint(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrBodySkeletonJointFB.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }
    }
}

