/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodyTrackerCreateInfoFB
extends Struct<XrBodyTrackerCreateInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BODYJOINTSET;

    protected XrBodyTrackerCreateInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrBodyTrackerCreateInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrBodyTrackerCreateInfoFB(address, container);
    }

    public XrBodyTrackerCreateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBodyTrackerCreateInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBodyTrackerCreateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBodyTrackerCreateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrBodyJointSetFB")
    public int bodyJointSet() {
        return XrBodyTrackerCreateInfoFB.nbodyJointSet(this.address());
    }

    public XrBodyTrackerCreateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrBodyTrackerCreateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrBodyTrackerCreateInfoFB type$Default() {
        return this.type(1000076001);
    }

    public XrBodyTrackerCreateInfoFB next(@NativeType(value="void const *") long value) {
        XrBodyTrackerCreateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrBodyTrackerCreateInfoFB bodyJointSet(@NativeType(value="XrBodyJointSetFB") int value) {
        XrBodyTrackerCreateInfoFB.nbodyJointSet(this.address(), value);
        return this;
    }

    public XrBodyTrackerCreateInfoFB set(int type, long next, int bodyJointSet) {
        this.type(type);
        this.next(next);
        this.bodyJointSet(bodyJointSet);
        return this;
    }

    public XrBodyTrackerCreateInfoFB set(XrBodyTrackerCreateInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBodyTrackerCreateInfoFB malloc() {
        return new XrBodyTrackerCreateInfoFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrBodyTrackerCreateInfoFB calloc() {
        return new XrBodyTrackerCreateInfoFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrBodyTrackerCreateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrBodyTrackerCreateInfoFB(MemoryUtil.memAddress(container), container);
    }

    public static XrBodyTrackerCreateInfoFB create(long address) {
        return new XrBodyTrackerCreateInfoFB(address, null);
    }

    public static @Nullable XrBodyTrackerCreateInfoFB createSafe(long address) {
        return address == 0L ? null : new XrBodyTrackerCreateInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrBodyTrackerCreateInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodyTrackerCreateInfoFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBodyTrackerCreateInfoFB malloc(MemoryStack stack) {
        return new XrBodyTrackerCreateInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBodyTrackerCreateInfoFB calloc(MemoryStack stack) {
        return new XrBodyTrackerCreateInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nbodyJointSet(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BODYJOINTSET);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbodyJointSet(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BODYJOINTSET, value);
    }

    static {
        Struct.Layout layout = XrBodyTrackerCreateInfoFB.__struct(XrBodyTrackerCreateInfoFB.__member(4), XrBodyTrackerCreateInfoFB.__member(POINTER_SIZE), XrBodyTrackerCreateInfoFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BODYJOINTSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrBodyTrackerCreateInfoFB, Buffer>
    implements NativeResource {
        private static final XrBodyTrackerCreateInfoFB ELEMENT_FACTORY = XrBodyTrackerCreateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrBodyTrackerCreateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBodyTrackerCreateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBodyTrackerCreateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrBodyJointSetFB")
        public int bodyJointSet() {
            return XrBodyTrackerCreateInfoFB.nbodyJointSet(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBodyTrackerCreateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000076001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBodyTrackerCreateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer bodyJointSet(@NativeType(value="XrBodyJointSetFB") int value) {
            XrBodyTrackerCreateInfoFB.nbodyJointSet(this.address(), value);
            return this;
        }
    }
}

