/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodyTrackerCreateInfoHTC
extends Struct<XrBodyTrackerCreateInfoHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BODYJOINTSET;

    protected XrBodyTrackerCreateInfoHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrBodyTrackerCreateInfoHTC create(long address, @Nullable ByteBuffer container) {
        return new XrBodyTrackerCreateInfoHTC(address, container);
    }

    public XrBodyTrackerCreateInfoHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBodyTrackerCreateInfoHTC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBodyTrackerCreateInfoHTC.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBodyTrackerCreateInfoHTC.nnext(this.address());
    }

    @NativeType(value="XrBodyJointSetHTC")
    public int bodyJointSet() {
        return XrBodyTrackerCreateInfoHTC.nbodyJointSet(this.address());
    }

    public XrBodyTrackerCreateInfoHTC type(@NativeType(value="XrStructureType") int value) {
        XrBodyTrackerCreateInfoHTC.ntype(this.address(), value);
        return this;
    }

    public XrBodyTrackerCreateInfoHTC type$Default() {
        return this.type(1000320001);
    }

    public XrBodyTrackerCreateInfoHTC next(@NativeType(value="void const *") long value) {
        XrBodyTrackerCreateInfoHTC.nnext(this.address(), value);
        return this;
    }

    public XrBodyTrackerCreateInfoHTC bodyJointSet(@NativeType(value="XrBodyJointSetHTC") int value) {
        XrBodyTrackerCreateInfoHTC.nbodyJointSet(this.address(), value);
        return this;
    }

    public XrBodyTrackerCreateInfoHTC set(int type, long next, int bodyJointSet) {
        this.type(type);
        this.next(next);
        this.bodyJointSet(bodyJointSet);
        return this;
    }

    public XrBodyTrackerCreateInfoHTC set(XrBodyTrackerCreateInfoHTC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBodyTrackerCreateInfoHTC malloc() {
        return new XrBodyTrackerCreateInfoHTC(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrBodyTrackerCreateInfoHTC calloc() {
        return new XrBodyTrackerCreateInfoHTC(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrBodyTrackerCreateInfoHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrBodyTrackerCreateInfoHTC(MemoryUtil.memAddress(container), container);
    }

    public static XrBodyTrackerCreateInfoHTC create(long address) {
        return new XrBodyTrackerCreateInfoHTC(address, null);
    }

    public static @Nullable XrBodyTrackerCreateInfoHTC createSafe(long address) {
        return address == 0L ? null : new XrBodyTrackerCreateInfoHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrBodyTrackerCreateInfoHTC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodyTrackerCreateInfoHTC.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBodyTrackerCreateInfoHTC malloc(MemoryStack stack) {
        return new XrBodyTrackerCreateInfoHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBodyTrackerCreateInfoHTC calloc(MemoryStack stack) {
        return new XrBodyTrackerCreateInfoHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nbodyJointSet(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BODYJOINTSET);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbodyJointSet(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BODYJOINTSET, value);
    }

    static {
        Struct.Layout layout = XrBodyTrackerCreateInfoHTC.__struct(XrBodyTrackerCreateInfoHTC.__member(4), XrBodyTrackerCreateInfoHTC.__member(POINTER_SIZE), XrBodyTrackerCreateInfoHTC.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BODYJOINTSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrBodyTrackerCreateInfoHTC, Buffer>
    implements NativeResource {
        private static final XrBodyTrackerCreateInfoHTC ELEMENT_FACTORY = XrBodyTrackerCreateInfoHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrBodyTrackerCreateInfoHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBodyTrackerCreateInfoHTC.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBodyTrackerCreateInfoHTC.nnext(this.address());
        }

        @NativeType(value="XrBodyJointSetHTC")
        public int bodyJointSet() {
            return XrBodyTrackerCreateInfoHTC.nbodyJointSet(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBodyTrackerCreateInfoHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000320001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBodyTrackerCreateInfoHTC.nnext(this.address(), value);
            return this;
        }

        public Buffer bodyJointSet(@NativeType(value="XrBodyJointSetHTC") int value) {
            XrBodyTrackerCreateInfoHTC.nbodyJointSet(this.address(), value);
            return this;
        }
    }
}

