/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBoundSourcesForActionEnumerateInfo
extends Struct<XrBoundSourcesForActionEnumerateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTION;

    protected XrBoundSourcesForActionEnumerateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrBoundSourcesForActionEnumerateInfo create(long address, @Nullable ByteBuffer container) {
        return new XrBoundSourcesForActionEnumerateInfo(address, container);
    }

    public XrBoundSourcesForActionEnumerateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBoundSourcesForActionEnumerateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBoundSourcesForActionEnumerateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBoundSourcesForActionEnumerateInfo.nnext(this.address());
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrBoundSourcesForActionEnumerateInfo.naction(this.address());
    }

    public XrBoundSourcesForActionEnumerateInfo type(@NativeType(value="XrStructureType") int value) {
        XrBoundSourcesForActionEnumerateInfo.ntype(this.address(), value);
        return this;
    }

    public XrBoundSourcesForActionEnumerateInfo type$Default() {
        return this.type(62);
    }

    public XrBoundSourcesForActionEnumerateInfo next(@NativeType(value="void const *") long value) {
        XrBoundSourcesForActionEnumerateInfo.nnext(this.address(), value);
        return this;
    }

    public XrBoundSourcesForActionEnumerateInfo action(XrAction value) {
        XrBoundSourcesForActionEnumerateInfo.naction(this.address(), value);
        return this;
    }

    public XrBoundSourcesForActionEnumerateInfo set(int type, long next, XrAction action) {
        this.type(type);
        this.next(next);
        this.action(action);
        return this;
    }

    public XrBoundSourcesForActionEnumerateInfo set(XrBoundSourcesForActionEnumerateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBoundSourcesForActionEnumerateInfo malloc() {
        return new XrBoundSourcesForActionEnumerateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrBoundSourcesForActionEnumerateInfo calloc() {
        return new XrBoundSourcesForActionEnumerateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrBoundSourcesForActionEnumerateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrBoundSourcesForActionEnumerateInfo(MemoryUtil.memAddress(container), container);
    }

    public static XrBoundSourcesForActionEnumerateInfo create(long address) {
        return new XrBoundSourcesForActionEnumerateInfo(address, null);
    }

    public static @Nullable XrBoundSourcesForActionEnumerateInfo createSafe(long address) {
        return address == 0L ? null : new XrBoundSourcesForActionEnumerateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrBoundSourcesForActionEnumerateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBoundSourcesForActionEnumerateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBoundSourcesForActionEnumerateInfo malloc(MemoryStack stack) {
        return new XrBoundSourcesForActionEnumerateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBoundSourcesForActionEnumerateInfo calloc(MemoryStack stack) {
        return new XrBoundSourcesForActionEnumerateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ACTION);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress(struct + (long)ACTION, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ACTION));
    }

    static {
        Struct.Layout layout = XrBoundSourcesForActionEnumerateInfo.__struct(XrBoundSourcesForActionEnumerateInfo.__member(4), XrBoundSourcesForActionEnumerateInfo.__member(POINTER_SIZE), XrBoundSourcesForActionEnumerateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrBoundSourcesForActionEnumerateInfo, Buffer>
    implements NativeResource {
        private static final XrBoundSourcesForActionEnumerateInfo ELEMENT_FACTORY = XrBoundSourcesForActionEnumerateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrBoundSourcesForActionEnumerateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBoundSourcesForActionEnumerateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBoundSourcesForActionEnumerateInfo.nnext(this.address());
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrBoundSourcesForActionEnumerateInfo.naction(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBoundSourcesForActionEnumerateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(62);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBoundSourcesForActionEnumerateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer action(XrAction value) {
            XrBoundSourcesForActionEnumerateInfo.naction(this.address(), value);
            return this;
        }
    }
}

