/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBoundary2DFB
extends Struct<XrBoundary2DFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VERTEXCAPACITYINPUT;
    public static final int VERTEXCOUNTOUTPUT;
    public static final int VERTICES;

    protected XrBoundary2DFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrBoundary2DFB create(long address, @Nullable ByteBuffer container) {
        return new XrBoundary2DFB(address, container);
    }

    public XrBoundary2DFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBoundary2DFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBoundary2DFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBoundary2DFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCapacityInput() {
        return XrBoundary2DFB.nvertexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCountOutput() {
        return XrBoundary2DFB.nvertexCountOutput(this.address());
    }

    @NativeType(value="XrVector2f *")
    public @Nullable XrVector2f.Buffer vertices() {
        return XrBoundary2DFB.nvertices(this.address());
    }

    public XrBoundary2DFB type(@NativeType(value="XrStructureType") int value) {
        XrBoundary2DFB.ntype(this.address(), value);
        return this;
    }

    public XrBoundary2DFB type$Default() {
        return this.type(1000175002);
    }

    public XrBoundary2DFB next(@NativeType(value="void const *") long value) {
        XrBoundary2DFB.nnext(this.address(), value);
        return this;
    }

    public XrBoundary2DFB vertexCapacityInput(@NativeType(value="uint32_t") int value) {
        XrBoundary2DFB.nvertexCapacityInput(this.address(), value);
        return this;
    }

    public XrBoundary2DFB vertexCountOutput(@NativeType(value="uint32_t") int value) {
        XrBoundary2DFB.nvertexCountOutput(this.address(), value);
        return this;
    }

    public XrBoundary2DFB vertices(@NativeType(value="XrVector2f *") @Nullable XrVector2f.Buffer value) {
        XrBoundary2DFB.nvertices(this.address(), value);
        return this;
    }

    public XrBoundary2DFB set(int type, long next, int vertexCapacityInput, int vertexCountOutput, @Nullable XrVector2f.Buffer vertices) {
        this.type(type);
        this.next(next);
        this.vertexCapacityInput(vertexCapacityInput);
        this.vertexCountOutput(vertexCountOutput);
        this.vertices(vertices);
        return this;
    }

    public XrBoundary2DFB set(XrBoundary2DFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBoundary2DFB malloc() {
        return new XrBoundary2DFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrBoundary2DFB calloc() {
        return new XrBoundary2DFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrBoundary2DFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrBoundary2DFB(MemoryUtil.memAddress(container), container);
    }

    public static XrBoundary2DFB create(long address) {
        return new XrBoundary2DFB(address, null);
    }

    public static @Nullable XrBoundary2DFB createSafe(long address) {
        return address == 0L ? null : new XrBoundary2DFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrBoundary2DFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBoundary2DFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBoundary2DFB malloc(MemoryStack stack) {
        return new XrBoundary2DFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBoundary2DFB calloc(MemoryStack stack) {
        return new XrBoundary2DFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nvertexCapacityInput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXCAPACITYINPUT);
    }

    public static int nvertexCountOutput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXCOUNTOUTPUT);
    }

    public static @Nullable XrVector2f.Buffer nvertices(long struct) {
        return XrVector2f.createSafe(MemoryUtil.memGetAddress(struct + (long)VERTICES), XrBoundary2DFB.nvertexCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nvertexCapacityInput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXCAPACITYINPUT, value);
    }

    public static void nvertexCountOutput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXCOUNTOUTPUT, value);
    }

    public static void nvertices(long struct, @Nullable XrVector2f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTICES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrBoundary2DFB.nvertexCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrBoundary2DFB.__struct(XrBoundary2DFB.__member(4), XrBoundary2DFB.__member(POINTER_SIZE), XrBoundary2DFB.__member(4), XrBoundary2DFB.__member(4), XrBoundary2DFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VERTEXCAPACITYINPUT = layout.offsetof(2);
        VERTEXCOUNTOUTPUT = layout.offsetof(3);
        VERTICES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrBoundary2DFB, Buffer>
    implements NativeResource {
        private static final XrBoundary2DFB ELEMENT_FACTORY = XrBoundary2DFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrBoundary2DFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBoundary2DFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBoundary2DFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCapacityInput() {
            return XrBoundary2DFB.nvertexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCountOutput() {
            return XrBoundary2DFB.nvertexCountOutput(this.address());
        }

        @NativeType(value="XrVector2f *")
        public @Nullable XrVector2f.Buffer vertices() {
            return XrBoundary2DFB.nvertices(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBoundary2DFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000175002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBoundary2DFB.nnext(this.address(), value);
            return this;
        }

        public Buffer vertexCapacityInput(@NativeType(value="uint32_t") int value) {
            XrBoundary2DFB.nvertexCapacityInput(this.address(), value);
            return this;
        }

        public Buffer vertexCountOutput(@NativeType(value="uint32_t") int value) {
            XrBoundary2DFB.nvertexCountOutput(this.address(), value);
            return this;
        }

        public Buffer vertices(@NativeType(value="XrVector2f *") @Nullable XrVector2f.Buffer value) {
            XrBoundary2DFB.nvertices(this.address(), value);
            return this;
        }
    }
}

