/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerAlphaBlendFB;
import org.lwjgl.openxr.XrCompositionLayerColorScaleBiasKHR;
import org.lwjgl.openxr.XrCompositionLayerCubeKHR;
import org.lwjgl.openxr.XrCompositionLayerCylinderKHR;
import org.lwjgl.openxr.XrCompositionLayerDepthTestFB;
import org.lwjgl.openxr.XrCompositionLayerEquirect2KHR;
import org.lwjgl.openxr.XrCompositionLayerEquirectKHR;
import org.lwjgl.openxr.XrCompositionLayerImageLayoutFB;
import org.lwjgl.openxr.XrCompositionLayerPassthroughFB;
import org.lwjgl.openxr.XrCompositionLayerPassthroughHTC;
import org.lwjgl.openxr.XrCompositionLayerProjection;
import org.lwjgl.openxr.XrCompositionLayerQuad;
import org.lwjgl.openxr.XrCompositionLayerSecureContentFB;
import org.lwjgl.openxr.XrCompositionLayerSettingsFB;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerBaseHeader
extends Struct<XrCompositionLayerBaseHeader>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERFLAGS;
    public static final int SPACE;

    protected XrCompositionLayerBaseHeader(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrCompositionLayerBaseHeader create(long address, @Nullable ByteBuffer container) {
        return new XrCompositionLayerBaseHeader(address, container);
    }

    public XrCompositionLayerBaseHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrCompositionLayerBaseHeader.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerBaseHeader.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerBaseHeader.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long layerFlags() {
        return XrCompositionLayerBaseHeader.nlayerFlags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerBaseHeader.nspace(this.address());
    }

    public XrCompositionLayerBaseHeader type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerBaseHeader.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerBaseHeader next(@NativeType(value="void const *") long value) {
        XrCompositionLayerBaseHeader.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerBaseHeader next(XrCompositionLayerAlphaBlendFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerBaseHeader next(XrCompositionLayerColorScaleBiasKHR value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerBaseHeader next(XrCompositionLayerDepthTestFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerBaseHeader next(XrCompositionLayerImageLayoutFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerBaseHeader next(XrCompositionLayerSecureContentFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerBaseHeader next(XrCompositionLayerSettingsFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerBaseHeader layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerBaseHeader.nlayerFlags(this.address(), value);
        return this;
    }

    public XrCompositionLayerBaseHeader space(XrSpace value) {
        XrCompositionLayerBaseHeader.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerBaseHeader set(int type, long next, long layerFlags, XrSpace space) {
        this.type(type);
        this.next(next);
        this.layerFlags(layerFlags);
        this.space(space);
        return this;
    }

    public XrCompositionLayerBaseHeader set(XrCompositionLayerBaseHeader src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrCompositionLayerBaseHeader malloc() {
        return new XrCompositionLayerBaseHeader(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrCompositionLayerBaseHeader calloc() {
        return new XrCompositionLayerBaseHeader(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrCompositionLayerBaseHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrCompositionLayerBaseHeader(MemoryUtil.memAddress(container), container);
    }

    public static XrCompositionLayerBaseHeader create(long address) {
        return new XrCompositionLayerBaseHeader(address, null);
    }

    public static @Nullable XrCompositionLayerBaseHeader createSafe(long address) {
        return address == 0L ? null : new XrCompositionLayerBaseHeader(address, null);
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerProjection value) {
        return new XrCompositionLayerBaseHeader(value.address(), XrCompositionLayerBaseHeader.__getContainer(value));
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerQuad value) {
        return new XrCompositionLayerBaseHeader(value.address(), XrCompositionLayerBaseHeader.__getContainer(value));
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerCubeKHR value) {
        return new XrCompositionLayerBaseHeader(value.address(), XrCompositionLayerBaseHeader.__getContainer(value));
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerCylinderKHR value) {
        return new XrCompositionLayerBaseHeader(value.address(), XrCompositionLayerBaseHeader.__getContainer(value));
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerEquirectKHR value) {
        return new XrCompositionLayerBaseHeader(value.address(), XrCompositionLayerBaseHeader.__getContainer(value));
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerEquirect2KHR value) {
        return new XrCompositionLayerBaseHeader(value.address(), XrCompositionLayerBaseHeader.__getContainer(value));
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerPassthroughFB value) {
        return new XrCompositionLayerBaseHeader(value.address(), XrCompositionLayerBaseHeader.__getContainer(value));
    }

    public static XrCompositionLayerBaseHeader create(XrCompositionLayerPassthroughHTC value) {
        return new XrCompositionLayerBaseHeader(value.address(), XrCompositionLayerBaseHeader.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrCompositionLayerBaseHeader.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerBaseHeader.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrCompositionLayerProjection.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerBaseHeader.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static Buffer create(XrCompositionLayerQuad.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerBaseHeader.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static Buffer create(XrCompositionLayerCubeKHR.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerBaseHeader.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static Buffer create(XrCompositionLayerCylinderKHR.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerBaseHeader.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static Buffer create(XrCompositionLayerEquirectKHR.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerBaseHeader.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static Buffer create(XrCompositionLayerEquirect2KHR.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerBaseHeader.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static Buffer create(XrCompositionLayerPassthroughFB.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerBaseHeader.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static Buffer create(XrCompositionLayerPassthroughHTC.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerBaseHeader.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrCompositionLayerBaseHeader malloc(MemoryStack stack) {
        return new XrCompositionLayerBaseHeader(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrCompositionLayerBaseHeader calloc(MemoryStack stack) {
        return new XrCompositionLayerBaseHeader(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nlayerFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LAYERFLAGS);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlayerFlags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)LAYERFLAGS, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
    }

    static {
        Struct.Layout layout = XrCompositionLayerBaseHeader.__struct(XrCompositionLayerBaseHeader.__member(4), XrCompositionLayerBaseHeader.__member(POINTER_SIZE), XrCompositionLayerBaseHeader.__member(8), XrCompositionLayerBaseHeader.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERFLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerBaseHeader, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerBaseHeader ELEMENT_FACTORY = XrCompositionLayerBaseHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrCompositionLayerBaseHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerBaseHeader.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerBaseHeader.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long layerFlags() {
            return XrCompositionLayerBaseHeader.nlayerFlags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerBaseHeader.nspace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerBaseHeader.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerBaseHeader.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrCompositionLayerAlphaBlendFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerColorScaleBiasKHR value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerDepthTestFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerImageLayoutFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerSecureContentFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerSettingsFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerBaseHeader.nlayerFlags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerBaseHeader.nspace(this.address(), value);
            return this;
        }
    }
}

