/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerBaseHeader;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSwapchainSubImage;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerEquirect2KHR
extends Struct<XrCompositionLayerEquirect2KHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERFLAGS;
    public static final int SPACE;
    public static final int EYEVISIBILITY;
    public static final int SUBIMAGE;
    public static final int POSE;
    public static final int RADIUS;
    public static final int CENTRALHORIZONTALANGLE;
    public static final int UPPERVERTICALANGLE;
    public static final int LOWERVERTICALANGLE;

    protected XrCompositionLayerEquirect2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrCompositionLayerEquirect2KHR create(long address, @Nullable ByteBuffer container) {
        return new XrCompositionLayerEquirect2KHR(address, container);
    }

    public XrCompositionLayerEquirect2KHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrCompositionLayerEquirect2KHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerEquirect2KHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerEquirect2KHR.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long layerFlags() {
        return XrCompositionLayerEquirect2KHR.nlayerFlags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerEquirect2KHR.nspace(this.address());
    }

    @NativeType(value="XrEyeVisibility")
    public int eyeVisibility() {
        return XrCompositionLayerEquirect2KHR.neyeVisibility(this.address());
    }

    public XrSwapchainSubImage subImage() {
        return XrCompositionLayerEquirect2KHR.nsubImage(this.address());
    }

    public XrPosef pose() {
        return XrCompositionLayerEquirect2KHR.npose(this.address());
    }

    public float radius() {
        return XrCompositionLayerEquirect2KHR.nradius(this.address());
    }

    public float centralHorizontalAngle() {
        return XrCompositionLayerEquirect2KHR.ncentralHorizontalAngle(this.address());
    }

    public float upperVerticalAngle() {
        return XrCompositionLayerEquirect2KHR.nupperVerticalAngle(this.address());
    }

    public float lowerVerticalAngle() {
        return XrCompositionLayerEquirect2KHR.nlowerVerticalAngle(this.address());
    }

    public XrCompositionLayerEquirect2KHR type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerEquirect2KHR.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirect2KHR type$Default() {
        return this.type(1000091000);
    }

    public XrCompositionLayerEquirect2KHR next(@NativeType(value="void const *") long value) {
        XrCompositionLayerEquirect2KHR.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirect2KHR layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerEquirect2KHR.nlayerFlags(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirect2KHR space(XrSpace value) {
        XrCompositionLayerEquirect2KHR.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirect2KHR eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
        XrCompositionLayerEquirect2KHR.neyeVisibility(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirect2KHR subImage(XrSwapchainSubImage value) {
        XrCompositionLayerEquirect2KHR.nsubImage(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirect2KHR subImage(Consumer<XrSwapchainSubImage> consumer) {
        consumer.accept(this.subImage());
        return this;
    }

    public XrCompositionLayerEquirect2KHR pose(XrPosef value) {
        XrCompositionLayerEquirect2KHR.npose(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirect2KHR pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrCompositionLayerEquirect2KHR radius(float value) {
        XrCompositionLayerEquirect2KHR.nradius(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirect2KHR centralHorizontalAngle(float value) {
        XrCompositionLayerEquirect2KHR.ncentralHorizontalAngle(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirect2KHR upperVerticalAngle(float value) {
        XrCompositionLayerEquirect2KHR.nupperVerticalAngle(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirect2KHR lowerVerticalAngle(float value) {
        XrCompositionLayerEquirect2KHR.nlowerVerticalAngle(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirect2KHR set(int type, long next, long layerFlags, XrSpace space, int eyeVisibility, XrSwapchainSubImage subImage, XrPosef pose, float radius, float centralHorizontalAngle, float upperVerticalAngle, float lowerVerticalAngle) {
        this.type(type);
        this.next(next);
        this.layerFlags(layerFlags);
        this.space(space);
        this.eyeVisibility(eyeVisibility);
        this.subImage(subImage);
        this.pose(pose);
        this.radius(radius);
        this.centralHorizontalAngle(centralHorizontalAngle);
        this.upperVerticalAngle(upperVerticalAngle);
        this.lowerVerticalAngle(lowerVerticalAngle);
        return this;
    }

    public XrCompositionLayerEquirect2KHR set(XrCompositionLayerEquirect2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrCompositionLayerEquirect2KHR malloc() {
        return new XrCompositionLayerEquirect2KHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrCompositionLayerEquirect2KHR calloc() {
        return new XrCompositionLayerEquirect2KHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrCompositionLayerEquirect2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrCompositionLayerEquirect2KHR(MemoryUtil.memAddress(container), container);
    }

    public static XrCompositionLayerEquirect2KHR create(long address) {
        return new XrCompositionLayerEquirect2KHR(address, null);
    }

    public static @Nullable XrCompositionLayerEquirect2KHR createSafe(long address) {
        return address == 0L ? null : new XrCompositionLayerEquirect2KHR(address, null);
    }

    public static XrCompositionLayerEquirect2KHR create(XrCompositionLayerBaseHeader value) {
        return new XrCompositionLayerEquirect2KHR(value.address(), XrCompositionLayerEquirect2KHR.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrCompositionLayerEquirect2KHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerEquirect2KHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrCompositionLayerBaseHeader.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerEquirect2KHR.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrCompositionLayerEquirect2KHR malloc(MemoryStack stack) {
        return new XrCompositionLayerEquirect2KHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrCompositionLayerEquirect2KHR calloc(MemoryStack stack) {
        return new XrCompositionLayerEquirect2KHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nlayerFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LAYERFLAGS);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static int neyeVisibility(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EYEVISIBILITY);
    }

    public static XrSwapchainSubImage nsubImage(long struct) {
        return XrSwapchainSubImage.create(struct + (long)SUBIMAGE);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static float nradius(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)RADIUS);
    }

    public static float ncentralHorizontalAngle(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CENTRALHORIZONTALANGLE);
    }

    public static float nupperVerticalAngle(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)UPPERVERTICALANGLE);
    }

    public static float nlowerVerticalAngle(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)LOWERVERTICALANGLE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlayerFlags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)LAYERFLAGS, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void neyeVisibility(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)EYEVISIBILITY, value);
    }

    public static void nsubImage(long struct, XrSwapchainSubImage value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SUBIMAGE, XrSwapchainSubImage.SIZEOF);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    public static void nradius(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)RADIUS, value);
    }

    public static void ncentralHorizontalAngle(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)CENTRALHORIZONTALANGLE, value);
    }

    public static void nupperVerticalAngle(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)UPPERVERTICALANGLE, value);
    }

    public static void nlowerVerticalAngle(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)LOWERVERTICALANGLE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
        XrSwapchainSubImage.validate(struct + (long)SUBIMAGE);
    }

    static {
        Struct.Layout layout = XrCompositionLayerEquirect2KHR.__struct(XrCompositionLayerEquirect2KHR.__member(4), XrCompositionLayerEquirect2KHR.__member(POINTER_SIZE), XrCompositionLayerEquirect2KHR.__member(8), XrCompositionLayerEquirect2KHR.__member(POINTER_SIZE), XrCompositionLayerEquirect2KHR.__member(4), XrCompositionLayerEquirect2KHR.__member(XrSwapchainSubImage.SIZEOF, XrSwapchainSubImage.ALIGNOF), XrCompositionLayerEquirect2KHR.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrCompositionLayerEquirect2KHR.__member(4), XrCompositionLayerEquirect2KHR.__member(4), XrCompositionLayerEquirect2KHR.__member(4), XrCompositionLayerEquirect2KHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERFLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        EYEVISIBILITY = layout.offsetof(4);
        SUBIMAGE = layout.offsetof(5);
        POSE = layout.offsetof(6);
        RADIUS = layout.offsetof(7);
        CENTRALHORIZONTALANGLE = layout.offsetof(8);
        UPPERVERTICALANGLE = layout.offsetof(9);
        LOWERVERTICALANGLE = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerEquirect2KHR, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerEquirect2KHR ELEMENT_FACTORY = XrCompositionLayerEquirect2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrCompositionLayerEquirect2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerEquirect2KHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerEquirect2KHR.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long layerFlags() {
            return XrCompositionLayerEquirect2KHR.nlayerFlags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerEquirect2KHR.nspace(this.address());
        }

        @NativeType(value="XrEyeVisibility")
        public int eyeVisibility() {
            return XrCompositionLayerEquirect2KHR.neyeVisibility(this.address());
        }

        public XrSwapchainSubImage subImage() {
            return XrCompositionLayerEquirect2KHR.nsubImage(this.address());
        }

        public XrPosef pose() {
            return XrCompositionLayerEquirect2KHR.npose(this.address());
        }

        public float radius() {
            return XrCompositionLayerEquirect2KHR.nradius(this.address());
        }

        public float centralHorizontalAngle() {
            return XrCompositionLayerEquirect2KHR.ncentralHorizontalAngle(this.address());
        }

        public float upperVerticalAngle() {
            return XrCompositionLayerEquirect2KHR.nupperVerticalAngle(this.address());
        }

        public float lowerVerticalAngle() {
            return XrCompositionLayerEquirect2KHR.nlowerVerticalAngle(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerEquirect2KHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000091000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerEquirect2KHR.nnext(this.address(), value);
            return this;
        }

        public Buffer layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerEquirect2KHR.nlayerFlags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerEquirect2KHR.nspace(this.address(), value);
            return this;
        }

        public Buffer eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
            XrCompositionLayerEquirect2KHR.neyeVisibility(this.address(), value);
            return this;
        }

        public Buffer subImage(XrSwapchainSubImage value) {
            XrCompositionLayerEquirect2KHR.nsubImage(this.address(), value);
            return this;
        }

        public Buffer subImage(Consumer<XrSwapchainSubImage> consumer) {
            consumer.accept(this.subImage());
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrCompositionLayerEquirect2KHR.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer radius(float value) {
            XrCompositionLayerEquirect2KHR.nradius(this.address(), value);
            return this;
        }

        public Buffer centralHorizontalAngle(float value) {
            XrCompositionLayerEquirect2KHR.ncentralHorizontalAngle(this.address(), value);
            return this;
        }

        public Buffer upperVerticalAngle(float value) {
            XrCompositionLayerEquirect2KHR.nupperVerticalAngle(this.address(), value);
            return this;
        }

        public Buffer lowerVerticalAngle(float value) {
            XrCompositionLayerEquirect2KHR.nlowerVerticalAngle(this.address(), value);
            return this;
        }
    }
}

