/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerBaseHeader;
import org.lwjgl.openxr.XrExtent2Df;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSwapchainSubImage;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerQuad
extends Struct<XrCompositionLayerQuad>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERFLAGS;
    public static final int SPACE;
    public static final int EYEVISIBILITY;
    public static final int SUBIMAGE;
    public static final int POSE;
    public static final int SIZE;

    protected XrCompositionLayerQuad(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrCompositionLayerQuad create(long address, @Nullable ByteBuffer container) {
        return new XrCompositionLayerQuad(address, container);
    }

    public XrCompositionLayerQuad(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrCompositionLayerQuad.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerQuad.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerQuad.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long layerFlags() {
        return XrCompositionLayerQuad.nlayerFlags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerQuad.nspace(this.address());
    }

    @NativeType(value="XrEyeVisibility")
    public int eyeVisibility() {
        return XrCompositionLayerQuad.neyeVisibility(this.address());
    }

    public XrSwapchainSubImage subImage() {
        return XrCompositionLayerQuad.nsubImage(this.address());
    }

    public XrPosef pose() {
        return XrCompositionLayerQuad.npose(this.address());
    }

    public XrExtent2Df size() {
        return XrCompositionLayerQuad.nsize(this.address());
    }

    public XrCompositionLayerQuad type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerQuad.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerQuad type$Default() {
        return this.type(36);
    }

    public XrCompositionLayerQuad next(@NativeType(value="void const *") long value) {
        XrCompositionLayerQuad.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerQuad layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerQuad.nlayerFlags(this.address(), value);
        return this;
    }

    public XrCompositionLayerQuad space(XrSpace value) {
        XrCompositionLayerQuad.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerQuad eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
        XrCompositionLayerQuad.neyeVisibility(this.address(), value);
        return this;
    }

    public XrCompositionLayerQuad subImage(XrSwapchainSubImage value) {
        XrCompositionLayerQuad.nsubImage(this.address(), value);
        return this;
    }

    public XrCompositionLayerQuad subImage(Consumer<XrSwapchainSubImage> consumer) {
        consumer.accept(this.subImage());
        return this;
    }

    public XrCompositionLayerQuad pose(XrPosef value) {
        XrCompositionLayerQuad.npose(this.address(), value);
        return this;
    }

    public XrCompositionLayerQuad pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrCompositionLayerQuad size(XrExtent2Df value) {
        XrCompositionLayerQuad.nsize(this.address(), value);
        return this;
    }

    public XrCompositionLayerQuad size(Consumer<XrExtent2Df> consumer) {
        consumer.accept(this.size());
        return this;
    }

    public XrCompositionLayerQuad set(int type, long next, long layerFlags, XrSpace space, int eyeVisibility, XrSwapchainSubImage subImage, XrPosef pose, XrExtent2Df size) {
        this.type(type);
        this.next(next);
        this.layerFlags(layerFlags);
        this.space(space);
        this.eyeVisibility(eyeVisibility);
        this.subImage(subImage);
        this.pose(pose);
        this.size(size);
        return this;
    }

    public XrCompositionLayerQuad set(XrCompositionLayerQuad src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrCompositionLayerQuad malloc() {
        return new XrCompositionLayerQuad(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrCompositionLayerQuad calloc() {
        return new XrCompositionLayerQuad(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrCompositionLayerQuad create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrCompositionLayerQuad(MemoryUtil.memAddress(container), container);
    }

    public static XrCompositionLayerQuad create(long address) {
        return new XrCompositionLayerQuad(address, null);
    }

    public static @Nullable XrCompositionLayerQuad createSafe(long address) {
        return address == 0L ? null : new XrCompositionLayerQuad(address, null);
    }

    public static XrCompositionLayerQuad create(XrCompositionLayerBaseHeader value) {
        return new XrCompositionLayerQuad(value.address(), XrCompositionLayerQuad.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrCompositionLayerQuad.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerQuad.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrCompositionLayerBaseHeader.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerQuad.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrCompositionLayerQuad malloc(MemoryStack stack) {
        return new XrCompositionLayerQuad(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrCompositionLayerQuad calloc(MemoryStack stack) {
        return new XrCompositionLayerQuad(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nlayerFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LAYERFLAGS);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static int neyeVisibility(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EYEVISIBILITY);
    }

    public static XrSwapchainSubImage nsubImage(long struct) {
        return XrSwapchainSubImage.create(struct + (long)SUBIMAGE);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrExtent2Df nsize(long struct) {
        return XrExtent2Df.create(struct + (long)SIZE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlayerFlags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)LAYERFLAGS, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void neyeVisibility(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)EYEVISIBILITY, value);
    }

    public static void nsubImage(long struct, XrSwapchainSubImage value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SUBIMAGE, XrSwapchainSubImage.SIZEOF);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    public static void nsize(long struct, XrExtent2Df value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SIZE, XrExtent2Df.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
        XrSwapchainSubImage.validate(struct + (long)SUBIMAGE);
    }

    static {
        Struct.Layout layout = XrCompositionLayerQuad.__struct(XrCompositionLayerQuad.__member(4), XrCompositionLayerQuad.__member(POINTER_SIZE), XrCompositionLayerQuad.__member(8), XrCompositionLayerQuad.__member(POINTER_SIZE), XrCompositionLayerQuad.__member(4), XrCompositionLayerQuad.__member(XrSwapchainSubImage.SIZEOF, XrSwapchainSubImage.ALIGNOF), XrCompositionLayerQuad.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrCompositionLayerQuad.__member(XrExtent2Df.SIZEOF, XrExtent2Df.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERFLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        EYEVISIBILITY = layout.offsetof(4);
        SUBIMAGE = layout.offsetof(5);
        POSE = layout.offsetof(6);
        SIZE = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerQuad, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerQuad ELEMENT_FACTORY = XrCompositionLayerQuad.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrCompositionLayerQuad getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerQuad.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerQuad.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long layerFlags() {
            return XrCompositionLayerQuad.nlayerFlags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerQuad.nspace(this.address());
        }

        @NativeType(value="XrEyeVisibility")
        public int eyeVisibility() {
            return XrCompositionLayerQuad.neyeVisibility(this.address());
        }

        public XrSwapchainSubImage subImage() {
            return XrCompositionLayerQuad.nsubImage(this.address());
        }

        public XrPosef pose() {
            return XrCompositionLayerQuad.npose(this.address());
        }

        public XrExtent2Df size() {
            return XrCompositionLayerQuad.nsize(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerQuad.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(36);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerQuad.nnext(this.address(), value);
            return this;
        }

        public Buffer layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerQuad.nlayerFlags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerQuad.nspace(this.address(), value);
            return this;
        }

        public Buffer eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
            XrCompositionLayerQuad.neyeVisibility(this.address(), value);
            return this;
        }

        public Buffer subImage(XrSwapchainSubImage value) {
            XrCompositionLayerQuad.nsubImage(this.address(), value);
            return this;
        }

        public Buffer subImage(Consumer<XrSwapchainSubImage> consumer) {
            consumer.accept(this.subImage());
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrCompositionLayerQuad.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer size(XrExtent2Df value) {
            XrCompositionLayerQuad.nsize(this.address(), value);
            return this;
        }

        public Buffer size(Consumer<XrExtent2Df> consumer) {
            consumer.accept(this.size());
            return this;
        }
    }
}

