/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrControllerModelNodePropertiesMSFT
extends Struct<XrControllerModelNodePropertiesMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PARENTNODENAME;
    public static final int NODENAME;

    protected XrControllerModelNodePropertiesMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrControllerModelNodePropertiesMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrControllerModelNodePropertiesMSFT(address, container);
    }

    public XrControllerModelNodePropertiesMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrControllerModelNodePropertiesMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrControllerModelNodePropertiesMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrControllerModelNodePropertiesMSFT.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT]")
    public ByteBuffer parentNodeName() {
        return XrControllerModelNodePropertiesMSFT.nparentNodeName(this.address());
    }

    @NativeType(value="char[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT]")
    public String parentNodeNameString() {
        return XrControllerModelNodePropertiesMSFT.nparentNodeNameString(this.address());
    }

    @NativeType(value="char[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT]")
    public ByteBuffer nodeName() {
        return XrControllerModelNodePropertiesMSFT.nnodeName(this.address());
    }

    @NativeType(value="char[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT]")
    public String nodeNameString() {
        return XrControllerModelNodePropertiesMSFT.nnodeNameString(this.address());
    }

    public XrControllerModelNodePropertiesMSFT type(@NativeType(value="XrStructureType") int value) {
        XrControllerModelNodePropertiesMSFT.ntype(this.address(), value);
        return this;
    }

    public XrControllerModelNodePropertiesMSFT type$Default() {
        return this.type(1000055001);
    }

    public XrControllerModelNodePropertiesMSFT next(@NativeType(value="void *") long value) {
        XrControllerModelNodePropertiesMSFT.nnext(this.address(), value);
        return this;
    }

    public XrControllerModelNodePropertiesMSFT parentNodeName(@NativeType(value="char[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT]") ByteBuffer value) {
        XrControllerModelNodePropertiesMSFT.nparentNodeName(this.address(), value);
        return this;
    }

    public XrControllerModelNodePropertiesMSFT nodeName(@NativeType(value="char[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT]") ByteBuffer value) {
        XrControllerModelNodePropertiesMSFT.nnodeName(this.address(), value);
        return this;
    }

    public XrControllerModelNodePropertiesMSFT set(int type, long next, ByteBuffer parentNodeName, ByteBuffer nodeName) {
        this.type(type);
        this.next(next);
        this.parentNodeName(parentNodeName);
        this.nodeName(nodeName);
        return this;
    }

    public XrControllerModelNodePropertiesMSFT set(XrControllerModelNodePropertiesMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrControllerModelNodePropertiesMSFT malloc() {
        return new XrControllerModelNodePropertiesMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrControllerModelNodePropertiesMSFT calloc() {
        return new XrControllerModelNodePropertiesMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrControllerModelNodePropertiesMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrControllerModelNodePropertiesMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrControllerModelNodePropertiesMSFT create(long address) {
        return new XrControllerModelNodePropertiesMSFT(address, null);
    }

    public static @Nullable XrControllerModelNodePropertiesMSFT createSafe(long address) {
        return address == 0L ? null : new XrControllerModelNodePropertiesMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrControllerModelNodePropertiesMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrControllerModelNodePropertiesMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrControllerModelNodePropertiesMSFT malloc(MemoryStack stack) {
        return new XrControllerModelNodePropertiesMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrControllerModelNodePropertiesMSFT calloc(MemoryStack stack) {
        return new XrControllerModelNodePropertiesMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static ByteBuffer nparentNodeName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)PARENTNODENAME, 64);
    }

    public static String nparentNodeNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)PARENTNODENAME);
    }

    public static ByteBuffer nnodeName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NODENAME, 64);
    }

    public static String nnodeNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)NODENAME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nparentNodeName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)PARENTNODENAME, value.remaining());
    }

    public static void nnodeName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)NODENAME, value.remaining());
    }

    static {
        Struct.Layout layout = XrControllerModelNodePropertiesMSFT.__struct(XrControllerModelNodePropertiesMSFT.__member(4), XrControllerModelNodePropertiesMSFT.__member(POINTER_SIZE), XrControllerModelNodePropertiesMSFT.__array(1, 64), XrControllerModelNodePropertiesMSFT.__array(1, 64));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PARENTNODENAME = layout.offsetof(2);
        NODENAME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrControllerModelNodePropertiesMSFT, Buffer>
    implements NativeResource {
        private static final XrControllerModelNodePropertiesMSFT ELEMENT_FACTORY = XrControllerModelNodePropertiesMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrControllerModelNodePropertiesMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrControllerModelNodePropertiesMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrControllerModelNodePropertiesMSFT.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT]")
        public ByteBuffer parentNodeName() {
            return XrControllerModelNodePropertiesMSFT.nparentNodeName(this.address());
        }

        @NativeType(value="char[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT]")
        public String parentNodeNameString() {
            return XrControllerModelNodePropertiesMSFT.nparentNodeNameString(this.address());
        }

        @NativeType(value="char[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT]")
        public ByteBuffer nodeName() {
            return XrControllerModelNodePropertiesMSFT.nnodeName(this.address());
        }

        @NativeType(value="char[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT]")
        public String nodeNameString() {
            return XrControllerModelNodePropertiesMSFT.nnodeNameString(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrControllerModelNodePropertiesMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000055001);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrControllerModelNodePropertiesMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer parentNodeName(@NativeType(value="char[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT]") ByteBuffer value) {
            XrControllerModelNodePropertiesMSFT.nparentNodeName(this.address(), value);
            return this;
        }

        public Buffer nodeName(@NativeType(value="char[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT]") ByteBuffer value) {
            XrControllerModelNodePropertiesMSFT.nnodeName(this.address(), value);
            return this;
        }
    }
}

