/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.MLCoordinateFrameUID;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCoordinateSpaceCreateInfoML
extends Struct<XrCoordinateSpaceCreateInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CFUID;
    public static final int POSEINCOORDINATESPACE;

    protected XrCoordinateSpaceCreateInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrCoordinateSpaceCreateInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrCoordinateSpaceCreateInfoML(address, container);
    }

    public XrCoordinateSpaceCreateInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrCoordinateSpaceCreateInfoML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCoordinateSpaceCreateInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCoordinateSpaceCreateInfoML.nnext(this.address());
    }

    public MLCoordinateFrameUID cfuid() {
        return XrCoordinateSpaceCreateInfoML.ncfuid(this.address());
    }

    public XrPosef poseInCoordinateSpace() {
        return XrCoordinateSpaceCreateInfoML.nposeInCoordinateSpace(this.address());
    }

    public XrCoordinateSpaceCreateInfoML type(@NativeType(value="XrStructureType") int value) {
        XrCoordinateSpaceCreateInfoML.ntype(this.address(), value);
        return this;
    }

    public XrCoordinateSpaceCreateInfoML type$Default() {
        return this.type(1000137000);
    }

    public XrCoordinateSpaceCreateInfoML next(@NativeType(value="void const *") long value) {
        XrCoordinateSpaceCreateInfoML.nnext(this.address(), value);
        return this;
    }

    public XrCoordinateSpaceCreateInfoML cfuid(MLCoordinateFrameUID value) {
        XrCoordinateSpaceCreateInfoML.ncfuid(this.address(), value);
        return this;
    }

    public XrCoordinateSpaceCreateInfoML poseInCoordinateSpace(XrPosef value) {
        XrCoordinateSpaceCreateInfoML.nposeInCoordinateSpace(this.address(), value);
        return this;
    }

    public XrCoordinateSpaceCreateInfoML poseInCoordinateSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInCoordinateSpace());
        return this;
    }

    public XrCoordinateSpaceCreateInfoML set(int type, long next, MLCoordinateFrameUID cfuid, XrPosef poseInCoordinateSpace) {
        this.type(type);
        this.next(next);
        this.cfuid(cfuid);
        this.poseInCoordinateSpace(poseInCoordinateSpace);
        return this;
    }

    public XrCoordinateSpaceCreateInfoML set(XrCoordinateSpaceCreateInfoML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrCoordinateSpaceCreateInfoML malloc() {
        return new XrCoordinateSpaceCreateInfoML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrCoordinateSpaceCreateInfoML calloc() {
        return new XrCoordinateSpaceCreateInfoML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrCoordinateSpaceCreateInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrCoordinateSpaceCreateInfoML(MemoryUtil.memAddress(container), container);
    }

    public static XrCoordinateSpaceCreateInfoML create(long address) {
        return new XrCoordinateSpaceCreateInfoML(address, null);
    }

    public static @Nullable XrCoordinateSpaceCreateInfoML createSafe(long address) {
        return address == 0L ? null : new XrCoordinateSpaceCreateInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrCoordinateSpaceCreateInfoML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCoordinateSpaceCreateInfoML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrCoordinateSpaceCreateInfoML malloc(MemoryStack stack) {
        return new XrCoordinateSpaceCreateInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrCoordinateSpaceCreateInfoML calloc(MemoryStack stack) {
        return new XrCoordinateSpaceCreateInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static MLCoordinateFrameUID ncfuid(long struct) {
        return MLCoordinateFrameUID.create(struct + (long)CFUID);
    }

    public static XrPosef nposeInCoordinateSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINCOORDINATESPACE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ncfuid(long struct, MLCoordinateFrameUID value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CFUID, MLCoordinateFrameUID.SIZEOF);
    }

    public static void nposeInCoordinateSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSEINCOORDINATESPACE, XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrCoordinateSpaceCreateInfoML.__struct(XrCoordinateSpaceCreateInfoML.__member(4), XrCoordinateSpaceCreateInfoML.__member(POINTER_SIZE), XrCoordinateSpaceCreateInfoML.__member(MLCoordinateFrameUID.SIZEOF, MLCoordinateFrameUID.ALIGNOF), XrCoordinateSpaceCreateInfoML.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CFUID = layout.offsetof(2);
        POSEINCOORDINATESPACE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrCoordinateSpaceCreateInfoML, Buffer>
    implements NativeResource {
        private static final XrCoordinateSpaceCreateInfoML ELEMENT_FACTORY = XrCoordinateSpaceCreateInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrCoordinateSpaceCreateInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCoordinateSpaceCreateInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCoordinateSpaceCreateInfoML.nnext(this.address());
        }

        public MLCoordinateFrameUID cfuid() {
            return XrCoordinateSpaceCreateInfoML.ncfuid(this.address());
        }

        public XrPosef poseInCoordinateSpace() {
            return XrCoordinateSpaceCreateInfoML.nposeInCoordinateSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCoordinateSpaceCreateInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000137000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCoordinateSpaceCreateInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer cfuid(MLCoordinateFrameUID value) {
            XrCoordinateSpaceCreateInfoML.ncfuid(this.address(), value);
            return this;
        }

        public Buffer poseInCoordinateSpace(XrPosef value) {
            XrCoordinateSpaceCreateInfoML.nposeInCoordinateSpace(this.address(), value);
            return this;
        }

        public Buffer poseInCoordinateSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInCoordinateSpace());
            return this;
        }
    }
}

