/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrDebugUtilsObjectNameInfoEXT
extends Struct<XrDebugUtilsObjectNameInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int OBJECTTYPE;
    public static final int OBJECTHANDLE;
    public static final int OBJECTNAME;

    protected XrDebugUtilsObjectNameInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrDebugUtilsObjectNameInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new XrDebugUtilsObjectNameInfoEXT(address, container);
    }

    public XrDebugUtilsObjectNameInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrDebugUtilsObjectNameInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrDebugUtilsObjectNameInfoEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrDebugUtilsObjectNameInfoEXT.nnext(this.address());
    }

    @NativeType(value="XrObjectType")
    public int objectType() {
        return XrDebugUtilsObjectNameInfoEXT.nobjectType(this.address());
    }

    @NativeType(value="uint64_t")
    public long objectHandle() {
        return XrDebugUtilsObjectNameInfoEXT.nobjectHandle(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer objectName() {
        return XrDebugUtilsObjectNameInfoEXT.nobjectName(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable String objectNameString() {
        return XrDebugUtilsObjectNameInfoEXT.nobjectNameString(this.address());
    }

    public XrDebugUtilsObjectNameInfoEXT type(@NativeType(value="XrStructureType") int value) {
        XrDebugUtilsObjectNameInfoEXT.ntype(this.address(), value);
        return this;
    }

    public XrDebugUtilsObjectNameInfoEXT type$Default() {
        return this.type(1000019000);
    }

    public XrDebugUtilsObjectNameInfoEXT next(@NativeType(value="void const *") long value) {
        XrDebugUtilsObjectNameInfoEXT.nnext(this.address(), value);
        return this;
    }

    public XrDebugUtilsObjectNameInfoEXT objectType(@NativeType(value="XrObjectType") int value) {
        XrDebugUtilsObjectNameInfoEXT.nobjectType(this.address(), value);
        return this;
    }

    public XrDebugUtilsObjectNameInfoEXT objectHandle(@NativeType(value="uint64_t") long value) {
        XrDebugUtilsObjectNameInfoEXT.nobjectHandle(this.address(), value);
        return this;
    }

    public XrDebugUtilsObjectNameInfoEXT objectName(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        XrDebugUtilsObjectNameInfoEXT.nobjectName(this.address(), value);
        return this;
    }

    public XrDebugUtilsObjectNameInfoEXT set(int type, long next, int objectType, long objectHandle, @Nullable ByteBuffer objectName) {
        this.type(type);
        this.next(next);
        this.objectType(objectType);
        this.objectHandle(objectHandle);
        this.objectName(objectName);
        return this;
    }

    public XrDebugUtilsObjectNameInfoEXT set(XrDebugUtilsObjectNameInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrDebugUtilsObjectNameInfoEXT malloc() {
        return new XrDebugUtilsObjectNameInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrDebugUtilsObjectNameInfoEXT calloc() {
        return new XrDebugUtilsObjectNameInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrDebugUtilsObjectNameInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrDebugUtilsObjectNameInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static XrDebugUtilsObjectNameInfoEXT create(long address) {
        return new XrDebugUtilsObjectNameInfoEXT(address, null);
    }

    public static @Nullable XrDebugUtilsObjectNameInfoEXT createSafe(long address) {
        return address == 0L ? null : new XrDebugUtilsObjectNameInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrDebugUtilsObjectNameInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrDebugUtilsObjectNameInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrDebugUtilsObjectNameInfoEXT malloc(MemoryStack stack) {
        return new XrDebugUtilsObjectNameInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrDebugUtilsObjectNameInfoEXT calloc(MemoryStack stack) {
        return new XrDebugUtilsObjectNameInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nobjectType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OBJECTTYPE);
    }

    public static long nobjectHandle(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OBJECTHANDLE);
    }

    public static @Nullable ByteBuffer nobjectName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)OBJECTNAME));
    }

    public static @Nullable String nobjectNameString(long struct) {
        return MemoryUtil.memUTF8Safe(MemoryUtil.memGetAddress(struct + (long)OBJECTNAME));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nobjectType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OBJECTTYPE, value);
    }

    public static void nobjectHandle(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OBJECTHANDLE, value);
    }

    public static void nobjectName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)OBJECTNAME, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = XrDebugUtilsObjectNameInfoEXT.__struct(XrDebugUtilsObjectNameInfoEXT.__member(4), XrDebugUtilsObjectNameInfoEXT.__member(POINTER_SIZE), XrDebugUtilsObjectNameInfoEXT.__member(4), XrDebugUtilsObjectNameInfoEXT.__member(8), XrDebugUtilsObjectNameInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        OBJECTTYPE = layout.offsetof(2);
        OBJECTHANDLE = layout.offsetof(3);
        OBJECTNAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrDebugUtilsObjectNameInfoEXT, Buffer>
    implements NativeResource {
        private static final XrDebugUtilsObjectNameInfoEXT ELEMENT_FACTORY = XrDebugUtilsObjectNameInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrDebugUtilsObjectNameInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrDebugUtilsObjectNameInfoEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrDebugUtilsObjectNameInfoEXT.nnext(this.address());
        }

        @NativeType(value="XrObjectType")
        public int objectType() {
            return XrDebugUtilsObjectNameInfoEXT.nobjectType(this.address());
        }

        @NativeType(value="uint64_t")
        public long objectHandle() {
            return XrDebugUtilsObjectNameInfoEXT.nobjectHandle(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable ByteBuffer objectName() {
            return XrDebugUtilsObjectNameInfoEXT.nobjectName(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable String objectNameString() {
            return XrDebugUtilsObjectNameInfoEXT.nobjectNameString(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrDebugUtilsObjectNameInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000019000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrDebugUtilsObjectNameInfoEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer objectType(@NativeType(value="XrObjectType") int value) {
            XrDebugUtilsObjectNameInfoEXT.nobjectType(this.address(), value);
            return this;
        }

        public Buffer objectHandle(@NativeType(value="uint64_t") long value) {
            XrDebugUtilsObjectNameInfoEXT.nobjectHandle(this.address(), value);
            return this;
        }

        public Buffer objectName(@NativeType(value="char const *") @Nullable ByteBuffer value) {
            XrDebugUtilsObjectNameInfoEXT.nobjectName(this.address(), value);
            return this;
        }
    }
}

