/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEnvironmentDepthProviderCreateInfoMETA
extends Struct<XrEnvironmentDepthProviderCreateInfoMETA>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CREATEFLAGS;

    protected XrEnvironmentDepthProviderCreateInfoMETA(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrEnvironmentDepthProviderCreateInfoMETA create(long address, @Nullable ByteBuffer container) {
        return new XrEnvironmentDepthProviderCreateInfoMETA(address, container);
    }

    public XrEnvironmentDepthProviderCreateInfoMETA(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEnvironmentDepthProviderCreateInfoMETA.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEnvironmentDepthProviderCreateInfoMETA.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEnvironmentDepthProviderCreateInfoMETA.nnext(this.address());
    }

    @NativeType(value="XrEnvironmentDepthProviderCreateFlagsMETA")
    public long createFlags() {
        return XrEnvironmentDepthProviderCreateInfoMETA.ncreateFlags(this.address());
    }

    public XrEnvironmentDepthProviderCreateInfoMETA type(@NativeType(value="XrStructureType") int value) {
        XrEnvironmentDepthProviderCreateInfoMETA.ntype(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthProviderCreateInfoMETA type$Default() {
        return this.type(1000291000);
    }

    public XrEnvironmentDepthProviderCreateInfoMETA next(@NativeType(value="void const *") long value) {
        XrEnvironmentDepthProviderCreateInfoMETA.nnext(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthProviderCreateInfoMETA createFlags(@NativeType(value="XrEnvironmentDepthProviderCreateFlagsMETA") long value) {
        XrEnvironmentDepthProviderCreateInfoMETA.ncreateFlags(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthProviderCreateInfoMETA set(int type, long next, long createFlags) {
        this.type(type);
        this.next(next);
        this.createFlags(createFlags);
        return this;
    }

    public XrEnvironmentDepthProviderCreateInfoMETA set(XrEnvironmentDepthProviderCreateInfoMETA src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEnvironmentDepthProviderCreateInfoMETA malloc() {
        return new XrEnvironmentDepthProviderCreateInfoMETA(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrEnvironmentDepthProviderCreateInfoMETA calloc() {
        return new XrEnvironmentDepthProviderCreateInfoMETA(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrEnvironmentDepthProviderCreateInfoMETA create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrEnvironmentDepthProviderCreateInfoMETA(MemoryUtil.memAddress(container), container);
    }

    public static XrEnvironmentDepthProviderCreateInfoMETA create(long address) {
        return new XrEnvironmentDepthProviderCreateInfoMETA(address, null);
    }

    public static @Nullable XrEnvironmentDepthProviderCreateInfoMETA createSafe(long address) {
        return address == 0L ? null : new XrEnvironmentDepthProviderCreateInfoMETA(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrEnvironmentDepthProviderCreateInfoMETA.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEnvironmentDepthProviderCreateInfoMETA.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrEnvironmentDepthProviderCreateInfoMETA malloc(MemoryStack stack) {
        return new XrEnvironmentDepthProviderCreateInfoMETA(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrEnvironmentDepthProviderCreateInfoMETA calloc(MemoryStack stack) {
        return new XrEnvironmentDepthProviderCreateInfoMETA(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long ncreateFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CREATEFLAGS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ncreateFlags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)CREATEFLAGS, value);
    }

    static {
        Struct.Layout layout = XrEnvironmentDepthProviderCreateInfoMETA.__struct(XrEnvironmentDepthProviderCreateInfoMETA.__member(4), XrEnvironmentDepthProviderCreateInfoMETA.__member(POINTER_SIZE), XrEnvironmentDepthProviderCreateInfoMETA.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CREATEFLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrEnvironmentDepthProviderCreateInfoMETA, Buffer>
    implements NativeResource {
        private static final XrEnvironmentDepthProviderCreateInfoMETA ELEMENT_FACTORY = XrEnvironmentDepthProviderCreateInfoMETA.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrEnvironmentDepthProviderCreateInfoMETA getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEnvironmentDepthProviderCreateInfoMETA.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEnvironmentDepthProviderCreateInfoMETA.nnext(this.address());
        }

        @NativeType(value="XrEnvironmentDepthProviderCreateFlagsMETA")
        public long createFlags() {
            return XrEnvironmentDepthProviderCreateInfoMETA.ncreateFlags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEnvironmentDepthProviderCreateInfoMETA.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000291000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEnvironmentDepthProviderCreateInfoMETA.nnext(this.address(), value);
            return this;
        }

        public Buffer createFlags(@NativeType(value="XrEnvironmentDepthProviderCreateFlagsMETA") long value) {
            XrEnvironmentDepthProviderCreateInfoMETA.ncreateFlags(this.address(), value);
            return this;
        }
    }
}

