/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEventDataBaseHeader;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataInstanceLossPending
extends Struct<XrEventDataInstanceLossPending>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LOSSTIME;

    protected XrEventDataInstanceLossPending(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrEventDataInstanceLossPending create(long address, @Nullable ByteBuffer container) {
        return new XrEventDataInstanceLossPending(address, container);
    }

    public XrEventDataInstanceLossPending(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEventDataInstanceLossPending.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataInstanceLossPending.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataInstanceLossPending.nnext(this.address());
    }

    @NativeType(value="XrTime")
    public long lossTime() {
        return XrEventDataInstanceLossPending.nlossTime(this.address());
    }

    public XrEventDataInstanceLossPending type(@NativeType(value="XrStructureType") int value) {
        XrEventDataInstanceLossPending.ntype(this.address(), value);
        return this;
    }

    public XrEventDataInstanceLossPending type$Default() {
        return this.type(17);
    }

    public XrEventDataInstanceLossPending next(@NativeType(value="void const *") long value) {
        XrEventDataInstanceLossPending.nnext(this.address(), value);
        return this;
    }

    public XrEventDataInstanceLossPending set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrEventDataInstanceLossPending set(XrEventDataInstanceLossPending src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEventDataInstanceLossPending malloc() {
        return new XrEventDataInstanceLossPending(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrEventDataInstanceLossPending calloc() {
        return new XrEventDataInstanceLossPending(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrEventDataInstanceLossPending create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrEventDataInstanceLossPending(MemoryUtil.memAddress(container), container);
    }

    public static XrEventDataInstanceLossPending create(long address) {
        return new XrEventDataInstanceLossPending(address, null);
    }

    public static @Nullable XrEventDataInstanceLossPending createSafe(long address) {
        return address == 0L ? null : new XrEventDataInstanceLossPending(address, null);
    }

    public static XrEventDataInstanceLossPending create(XrEventDataBaseHeader value) {
        return new XrEventDataInstanceLossPending(value.address(), XrEventDataInstanceLossPending.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrEventDataInstanceLossPending.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataInstanceLossPending.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrEventDataBaseHeader.Buffer value) {
        return new Buffer(value.address(), XrEventDataInstanceLossPending.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrEventDataInstanceLossPending malloc(MemoryStack stack) {
        return new XrEventDataInstanceLossPending(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrEventDataInstanceLossPending calloc(MemoryStack stack) {
        return new XrEventDataInstanceLossPending(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nlossTime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LOSSTIME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrEventDataInstanceLossPending.__struct(XrEventDataInstanceLossPending.__member(4), XrEventDataInstanceLossPending.__member(POINTER_SIZE), XrEventDataInstanceLossPending.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LOSSTIME = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataInstanceLossPending, Buffer>
    implements NativeResource {
        private static final XrEventDataInstanceLossPending ELEMENT_FACTORY = XrEventDataInstanceLossPending.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrEventDataInstanceLossPending getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataInstanceLossPending.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataInstanceLossPending.nnext(this.address());
        }

        @NativeType(value="XrTime")
        public long lossTime() {
            return XrEventDataInstanceLossPending.nlossTime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataInstanceLossPending.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(17);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataInstanceLossPending.nnext(this.address(), value);
            return this;
        }
    }
}

