/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExtensionProperties
extends Struct<XrExtensionProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int EXTENSIONNAME;
    public static final int EXTENSIONVERSION;

    protected XrExtensionProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrExtensionProperties create(long address, @Nullable ByteBuffer container) {
        return new XrExtensionProperties(address, container);
    }

    public XrExtensionProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrExtensionProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrExtensionProperties.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrExtensionProperties.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_EXTENSION_NAME_SIZE]")
    public ByteBuffer extensionName() {
        return XrExtensionProperties.nextensionName(this.address());
    }

    @NativeType(value="char[XR_MAX_EXTENSION_NAME_SIZE]")
    public String extensionNameString() {
        return XrExtensionProperties.nextensionNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int extensionVersion() {
        return XrExtensionProperties.nextensionVersion(this.address());
    }

    public XrExtensionProperties type(@NativeType(value="XrStructureType") int value) {
        XrExtensionProperties.ntype(this.address(), value);
        return this;
    }

    public XrExtensionProperties type$Default() {
        return this.type(2);
    }

    public XrExtensionProperties next(@NativeType(value="void *") long value) {
        XrExtensionProperties.nnext(this.address(), value);
        return this;
    }

    public XrExtensionProperties set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrExtensionProperties set(XrExtensionProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrExtensionProperties malloc() {
        return new XrExtensionProperties(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrExtensionProperties calloc() {
        return new XrExtensionProperties(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrExtensionProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrExtensionProperties(MemoryUtil.memAddress(container), container);
    }

    public static XrExtensionProperties create(long address) {
        return new XrExtensionProperties(address, null);
    }

    public static @Nullable XrExtensionProperties createSafe(long address) {
        return address == 0L ? null : new XrExtensionProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrExtensionProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtensionProperties.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrExtensionProperties malloc(MemoryStack stack) {
        return new XrExtensionProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrExtensionProperties calloc(MemoryStack stack) {
        return new XrExtensionProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static ByteBuffer nextensionName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)EXTENSIONNAME, 128);
    }

    public static String nextensionNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)EXTENSIONNAME);
    }

    public static int nextensionVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXTENSIONVERSION);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrExtensionProperties.__struct(XrExtensionProperties.__member(4), XrExtensionProperties.__member(POINTER_SIZE), XrExtensionProperties.__array(1, 128), XrExtensionProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        EXTENSIONNAME = layout.offsetof(2);
        EXTENSIONVERSION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrExtensionProperties, Buffer>
    implements NativeResource {
        private static final XrExtensionProperties ELEMENT_FACTORY = XrExtensionProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrExtensionProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrExtensionProperties.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrExtensionProperties.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_EXTENSION_NAME_SIZE]")
        public ByteBuffer extensionName() {
            return XrExtensionProperties.nextensionName(this.address());
        }

        @NativeType(value="char[XR_MAX_EXTENSION_NAME_SIZE]")
        public String extensionNameString() {
            return XrExtensionProperties.nextensionNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int extensionVersion() {
            return XrExtensionProperties.nextensionVersion(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrExtensionProperties.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(2);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrExtensionProperties.nnext(this.address(), value);
            return this;
        }
    }
}

