/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExtent2Di
extends Struct<XrExtent2Di>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    protected XrExtent2Di(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrExtent2Di create(long address, @Nullable ByteBuffer container) {
        return new XrExtent2Di(address, container);
    }

    public XrExtent2Di(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrExtent2Di.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int width() {
        return XrExtent2Di.nwidth(this.address());
    }

    @NativeType(value="int32_t")
    public int height() {
        return XrExtent2Di.nheight(this.address());
    }

    public XrExtent2Di width(@NativeType(value="int32_t") int value) {
        XrExtent2Di.nwidth(this.address(), value);
        return this;
    }

    public XrExtent2Di height(@NativeType(value="int32_t") int value) {
        XrExtent2Di.nheight(this.address(), value);
        return this;
    }

    public XrExtent2Di set(int width, int height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public XrExtent2Di set(XrExtent2Di src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrExtent2Di malloc() {
        return new XrExtent2Di(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrExtent2Di calloc() {
        return new XrExtent2Di(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrExtent2Di create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrExtent2Di(MemoryUtil.memAddress(container), container);
    }

    public static XrExtent2Di create(long address) {
        return new XrExtent2Di(address, null);
    }

    public static @Nullable XrExtent2Di createSafe(long address) {
        return address == 0L ? null : new XrExtent2Di(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrExtent2Di.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtent2Di.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrExtent2Di malloc(MemoryStack stack) {
        return new XrExtent2Di(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrExtent2Di calloc(MemoryStack stack) {
        return new XrExtent2Di(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = XrExtent2Di.__struct(XrExtent2Di.__member(4), XrExtent2Di.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrExtent2Di, Buffer>
    implements NativeResource {
        private static final XrExtent2Di ELEMENT_FACTORY = XrExtent2Di.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrExtent2Di getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int width() {
            return XrExtent2Di.nwidth(this.address());
        }

        @NativeType(value="int32_t")
        public int height() {
            return XrExtent2Di.nheight(this.address());
        }

        public Buffer width(@NativeType(value="int32_t") int value) {
            XrExtent2Di.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="int32_t") int value) {
            XrExtent2Di.nheight(this.address(), value);
            return this;
        }
    }
}

