/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent2Di;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExternalCameraIntrinsicsOCULUS
extends Struct<XrExternalCameraIntrinsicsOCULUS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LASTCHANGETIME;
    public static final int FOV;
    public static final int VIRTUALNEARPLANEDISTANCE;
    public static final int VIRTUALFARPLANEDISTANCE;
    public static final int IMAGESENSORPIXELRESOLUTION;

    protected XrExternalCameraIntrinsicsOCULUS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrExternalCameraIntrinsicsOCULUS create(long address, @Nullable ByteBuffer container) {
        return new XrExternalCameraIntrinsicsOCULUS(address, container);
    }

    public XrExternalCameraIntrinsicsOCULUS(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrExternalCameraIntrinsicsOCULUS.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrTime")
    public long lastChangeTime() {
        return XrExternalCameraIntrinsicsOCULUS.nlastChangeTime(this.address());
    }

    public XrFovf fov() {
        return XrExternalCameraIntrinsicsOCULUS.nfov(this.address());
    }

    public float virtualNearPlaneDistance() {
        return XrExternalCameraIntrinsicsOCULUS.nvirtualNearPlaneDistance(this.address());
    }

    public float virtualFarPlaneDistance() {
        return XrExternalCameraIntrinsicsOCULUS.nvirtualFarPlaneDistance(this.address());
    }

    public XrExtent2Di imageSensorPixelResolution() {
        return XrExternalCameraIntrinsicsOCULUS.nimageSensorPixelResolution(this.address());
    }

    public XrExternalCameraIntrinsicsOCULUS lastChangeTime(@NativeType(value="XrTime") long value) {
        XrExternalCameraIntrinsicsOCULUS.nlastChangeTime(this.address(), value);
        return this;
    }

    public XrExternalCameraIntrinsicsOCULUS fov(XrFovf value) {
        XrExternalCameraIntrinsicsOCULUS.nfov(this.address(), value);
        return this;
    }

    public XrExternalCameraIntrinsicsOCULUS fov(Consumer<XrFovf> consumer) {
        consumer.accept(this.fov());
        return this;
    }

    public XrExternalCameraIntrinsicsOCULUS virtualNearPlaneDistance(float value) {
        XrExternalCameraIntrinsicsOCULUS.nvirtualNearPlaneDistance(this.address(), value);
        return this;
    }

    public XrExternalCameraIntrinsicsOCULUS virtualFarPlaneDistance(float value) {
        XrExternalCameraIntrinsicsOCULUS.nvirtualFarPlaneDistance(this.address(), value);
        return this;
    }

    public XrExternalCameraIntrinsicsOCULUS imageSensorPixelResolution(XrExtent2Di value) {
        XrExternalCameraIntrinsicsOCULUS.nimageSensorPixelResolution(this.address(), value);
        return this;
    }

    public XrExternalCameraIntrinsicsOCULUS imageSensorPixelResolution(Consumer<XrExtent2Di> consumer) {
        consumer.accept(this.imageSensorPixelResolution());
        return this;
    }

    public XrExternalCameraIntrinsicsOCULUS set(long lastChangeTime, XrFovf fov, float virtualNearPlaneDistance, float virtualFarPlaneDistance, XrExtent2Di imageSensorPixelResolution) {
        this.lastChangeTime(lastChangeTime);
        this.fov(fov);
        this.virtualNearPlaneDistance(virtualNearPlaneDistance);
        this.virtualFarPlaneDistance(virtualFarPlaneDistance);
        this.imageSensorPixelResolution(imageSensorPixelResolution);
        return this;
    }

    public XrExternalCameraIntrinsicsOCULUS set(XrExternalCameraIntrinsicsOCULUS src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrExternalCameraIntrinsicsOCULUS malloc() {
        return new XrExternalCameraIntrinsicsOCULUS(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrExternalCameraIntrinsicsOCULUS calloc() {
        return new XrExternalCameraIntrinsicsOCULUS(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrExternalCameraIntrinsicsOCULUS create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrExternalCameraIntrinsicsOCULUS(MemoryUtil.memAddress(container), container);
    }

    public static XrExternalCameraIntrinsicsOCULUS create(long address) {
        return new XrExternalCameraIntrinsicsOCULUS(address, null);
    }

    public static @Nullable XrExternalCameraIntrinsicsOCULUS createSafe(long address) {
        return address == 0L ? null : new XrExternalCameraIntrinsicsOCULUS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrExternalCameraIntrinsicsOCULUS.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExternalCameraIntrinsicsOCULUS.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrExternalCameraIntrinsicsOCULUS malloc(MemoryStack stack) {
        return new XrExternalCameraIntrinsicsOCULUS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrExternalCameraIntrinsicsOCULUS calloc(MemoryStack stack) {
        return new XrExternalCameraIntrinsicsOCULUS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nlastChangeTime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LASTCHANGETIME);
    }

    public static XrFovf nfov(long struct) {
        return XrFovf.create(struct + (long)FOV);
    }

    public static float nvirtualNearPlaneDistance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)VIRTUALNEARPLANEDISTANCE);
    }

    public static float nvirtualFarPlaneDistance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)VIRTUALFARPLANEDISTANCE);
    }

    public static XrExtent2Di nimageSensorPixelResolution(long struct) {
        return XrExtent2Di.create(struct + (long)IMAGESENSORPIXELRESOLUTION);
    }

    public static void nlastChangeTime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)LASTCHANGETIME, value);
    }

    public static void nfov(long struct, XrFovf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FOV, XrFovf.SIZEOF);
    }

    public static void nvirtualNearPlaneDistance(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)VIRTUALNEARPLANEDISTANCE, value);
    }

    public static void nvirtualFarPlaneDistance(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)VIRTUALFARPLANEDISTANCE, value);
    }

    public static void nimageSensorPixelResolution(long struct, XrExtent2Di value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGESENSORPIXELRESOLUTION, XrExtent2Di.SIZEOF);
    }

    static {
        Struct.Layout layout = XrExternalCameraIntrinsicsOCULUS.__struct(XrExternalCameraIntrinsicsOCULUS.__member(8), XrExternalCameraIntrinsicsOCULUS.__member(XrFovf.SIZEOF, XrFovf.ALIGNOF), XrExternalCameraIntrinsicsOCULUS.__member(4), XrExternalCameraIntrinsicsOCULUS.__member(4), XrExternalCameraIntrinsicsOCULUS.__member(XrExtent2Di.SIZEOF, XrExtent2Di.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LASTCHANGETIME = layout.offsetof(0);
        FOV = layout.offsetof(1);
        VIRTUALNEARPLANEDISTANCE = layout.offsetof(2);
        VIRTUALFARPLANEDISTANCE = layout.offsetof(3);
        IMAGESENSORPIXELRESOLUTION = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrExternalCameraIntrinsicsOCULUS, Buffer>
    implements NativeResource {
        private static final XrExternalCameraIntrinsicsOCULUS ELEMENT_FACTORY = XrExternalCameraIntrinsicsOCULUS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrExternalCameraIntrinsicsOCULUS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrTime")
        public long lastChangeTime() {
            return XrExternalCameraIntrinsicsOCULUS.nlastChangeTime(this.address());
        }

        public XrFovf fov() {
            return XrExternalCameraIntrinsicsOCULUS.nfov(this.address());
        }

        public float virtualNearPlaneDistance() {
            return XrExternalCameraIntrinsicsOCULUS.nvirtualNearPlaneDistance(this.address());
        }

        public float virtualFarPlaneDistance() {
            return XrExternalCameraIntrinsicsOCULUS.nvirtualFarPlaneDistance(this.address());
        }

        public XrExtent2Di imageSensorPixelResolution() {
            return XrExternalCameraIntrinsicsOCULUS.nimageSensorPixelResolution(this.address());
        }

        public Buffer lastChangeTime(@NativeType(value="XrTime") long value) {
            XrExternalCameraIntrinsicsOCULUS.nlastChangeTime(this.address(), value);
            return this;
        }

        public Buffer fov(XrFovf value) {
            XrExternalCameraIntrinsicsOCULUS.nfov(this.address(), value);
            return this;
        }

        public Buffer fov(Consumer<XrFovf> consumer) {
            consumer.accept(this.fov());
            return this;
        }

        public Buffer virtualNearPlaneDistance(float value) {
            XrExternalCameraIntrinsicsOCULUS.nvirtualNearPlaneDistance(this.address(), value);
            return this;
        }

        public Buffer virtualFarPlaneDistance(float value) {
            XrExternalCameraIntrinsicsOCULUS.nvirtualFarPlaneDistance(this.address(), value);
            return this;
        }

        public Buffer imageSensorPixelResolution(XrExtent2Di value) {
            XrExternalCameraIntrinsicsOCULUS.nimageSensorPixelResolution(this.address(), value);
            return this;
        }

        public Buffer imageSensorPixelResolution(Consumer<XrExtent2Di> consumer) {
            consumer.accept(this.imageSensorPixelResolution());
            return this;
        }
    }
}

