/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFaceExpressionInfoFB
extends Struct<XrFaceExpressionInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int TIME;

    protected XrFaceExpressionInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrFaceExpressionInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrFaceExpressionInfoFB(address, container);
    }

    public XrFaceExpressionInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrFaceExpressionInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFaceExpressionInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrFaceExpressionInfoFB.nnext(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrFaceExpressionInfoFB.ntime(this.address());
    }

    public XrFaceExpressionInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrFaceExpressionInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrFaceExpressionInfoFB type$Default() {
        return this.type(1000201002);
    }

    public XrFaceExpressionInfoFB next(@NativeType(value="void const *") long value) {
        XrFaceExpressionInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrFaceExpressionInfoFB time(@NativeType(value="XrTime") long value) {
        XrFaceExpressionInfoFB.ntime(this.address(), value);
        return this;
    }

    public XrFaceExpressionInfoFB set(int type, long next, long time) {
        this.type(type);
        this.next(next);
        this.time(time);
        return this;
    }

    public XrFaceExpressionInfoFB set(XrFaceExpressionInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrFaceExpressionInfoFB malloc() {
        return new XrFaceExpressionInfoFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrFaceExpressionInfoFB calloc() {
        return new XrFaceExpressionInfoFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrFaceExpressionInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrFaceExpressionInfoFB(MemoryUtil.memAddress(container), container);
    }

    public static XrFaceExpressionInfoFB create(long address) {
        return new XrFaceExpressionInfoFB(address, null);
    }

    public static @Nullable XrFaceExpressionInfoFB createSafe(long address) {
        return address == 0L ? null : new XrFaceExpressionInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrFaceExpressionInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFaceExpressionInfoFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFaceExpressionInfoFB malloc(MemoryStack stack) {
        return new XrFaceExpressionInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFaceExpressionInfoFB calloc(MemoryStack stack) {
        return new XrFaceExpressionInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    static {
        Struct.Layout layout = XrFaceExpressionInfoFB.__struct(XrFaceExpressionInfoFB.__member(4), XrFaceExpressionInfoFB.__member(POINTER_SIZE), XrFaceExpressionInfoFB.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        TIME = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrFaceExpressionInfoFB, Buffer>
    implements NativeResource {
        private static final XrFaceExpressionInfoFB ELEMENT_FACTORY = XrFaceExpressionInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrFaceExpressionInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFaceExpressionInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrFaceExpressionInfoFB.nnext(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrFaceExpressionInfoFB.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFaceExpressionInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000201002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrFaceExpressionInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrFaceExpressionInfoFB.ntime(this.address(), value);
            return this;
        }
    }
}

