/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFaceExpressionWeights2FB
extends Struct<XrFaceExpressionWeights2FB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int WEIGHTCOUNT;
    public static final int WEIGHTS;
    public static final int CONFIDENCECOUNT;
    public static final int CONFIDENCES;
    public static final int ISVALID;
    public static final int ISEYEFOLLOWINGBLENDSHAPESVALID;
    public static final int DATASOURCE;
    public static final int TIME;

    protected XrFaceExpressionWeights2FB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrFaceExpressionWeights2FB create(long address, @Nullable ByteBuffer container) {
        return new XrFaceExpressionWeights2FB(address, container);
    }

    public XrFaceExpressionWeights2FB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrFaceExpressionWeights2FB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFaceExpressionWeights2FB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrFaceExpressionWeights2FB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int weightCount() {
        return XrFaceExpressionWeights2FB.nweightCount(this.address());
    }

    @NativeType(value="float *")
    public FloatBuffer weights() {
        return XrFaceExpressionWeights2FB.nweights(this.address());
    }

    @NativeType(value="uint32_t")
    public int confidenceCount() {
        return XrFaceExpressionWeights2FB.nconfidenceCount(this.address());
    }

    @NativeType(value="float *")
    public FloatBuffer confidences() {
        return XrFaceExpressionWeights2FB.nconfidences(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isValid() {
        return XrFaceExpressionWeights2FB.nisValid(this.address()) != 0;
    }

    @NativeType(value="XrBool32")
    public boolean isEyeFollowingBlendshapesValid() {
        return XrFaceExpressionWeights2FB.nisEyeFollowingBlendshapesValid(this.address()) != 0;
    }

    @NativeType(value="XrFaceTrackingDataSource2FB")
    public int dataSource() {
        return XrFaceExpressionWeights2FB.ndataSource(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrFaceExpressionWeights2FB.ntime(this.address());
    }

    public XrFaceExpressionWeights2FB type(@NativeType(value="XrStructureType") int value) {
        XrFaceExpressionWeights2FB.ntype(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeights2FB type$Default() {
        return this.type(1000287016);
    }

    public XrFaceExpressionWeights2FB next(@NativeType(value="void *") long value) {
        XrFaceExpressionWeights2FB.nnext(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeights2FB weights(@NativeType(value="float *") FloatBuffer value) {
        XrFaceExpressionWeights2FB.nweights(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeights2FB confidences(@NativeType(value="float *") FloatBuffer value) {
        XrFaceExpressionWeights2FB.nconfidences(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeights2FB isValid(@NativeType(value="XrBool32") boolean value) {
        XrFaceExpressionWeights2FB.nisValid(this.address(), value ? 1 : 0);
        return this;
    }

    public XrFaceExpressionWeights2FB isEyeFollowingBlendshapesValid(@NativeType(value="XrBool32") boolean value) {
        XrFaceExpressionWeights2FB.nisEyeFollowingBlendshapesValid(this.address(), value ? 1 : 0);
        return this;
    }

    public XrFaceExpressionWeights2FB dataSource(@NativeType(value="XrFaceTrackingDataSource2FB") int value) {
        XrFaceExpressionWeights2FB.ndataSource(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeights2FB time(@NativeType(value="XrTime") long value) {
        XrFaceExpressionWeights2FB.ntime(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeights2FB set(int type, long next, FloatBuffer weights, FloatBuffer confidences, boolean isValid, boolean isEyeFollowingBlendshapesValid, int dataSource, long time) {
        this.type(type);
        this.next(next);
        this.weights(weights);
        this.confidences(confidences);
        this.isValid(isValid);
        this.isEyeFollowingBlendshapesValid(isEyeFollowingBlendshapesValid);
        this.dataSource(dataSource);
        this.time(time);
        return this;
    }

    public XrFaceExpressionWeights2FB set(XrFaceExpressionWeights2FB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrFaceExpressionWeights2FB malloc() {
        return new XrFaceExpressionWeights2FB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrFaceExpressionWeights2FB calloc() {
        return new XrFaceExpressionWeights2FB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrFaceExpressionWeights2FB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrFaceExpressionWeights2FB(MemoryUtil.memAddress(container), container);
    }

    public static XrFaceExpressionWeights2FB create(long address) {
        return new XrFaceExpressionWeights2FB(address, null);
    }

    public static @Nullable XrFaceExpressionWeights2FB createSafe(long address) {
        return address == 0L ? null : new XrFaceExpressionWeights2FB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrFaceExpressionWeights2FB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFaceExpressionWeights2FB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFaceExpressionWeights2FB malloc(MemoryStack stack) {
        return new XrFaceExpressionWeights2FB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFaceExpressionWeights2FB calloc(MemoryStack stack) {
        return new XrFaceExpressionWeights2FB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nweightCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WEIGHTCOUNT);
    }

    public static FloatBuffer nweights(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)WEIGHTS), XrFaceExpressionWeights2FB.nweightCount(struct));
    }

    public static int nconfidenceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONFIDENCECOUNT);
    }

    public static FloatBuffer nconfidences(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)CONFIDENCES), XrFaceExpressionWeights2FB.nconfidenceCount(struct));
    }

    public static int nisValid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISVALID);
    }

    public static int nisEyeFollowingBlendshapesValid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISEYEFOLLOWINGBLENDSHAPESVALID);
    }

    public static int ndataSource(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DATASOURCE);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nweightCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WEIGHTCOUNT, value);
    }

    public static void nweights(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)WEIGHTS, MemoryUtil.memAddress(value));
        XrFaceExpressionWeights2FB.nweightCount(struct, value.remaining());
    }

    public static void nconfidenceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONFIDENCECOUNT, value);
    }

    public static void nconfidences(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)CONFIDENCES, MemoryUtil.memAddress(value));
        XrFaceExpressionWeights2FB.nconfidenceCount(struct, value.remaining());
    }

    public static void nisValid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ISVALID, value);
    }

    public static void nisEyeFollowingBlendshapesValid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ISEYEFOLLOWINGBLENDSHAPESVALID, value);
    }

    public static void ndataSource(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DATASOURCE, value);
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)WEIGHTS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CONFIDENCES));
    }

    static {
        Struct.Layout layout = XrFaceExpressionWeights2FB.__struct(XrFaceExpressionWeights2FB.__member(4), XrFaceExpressionWeights2FB.__member(POINTER_SIZE), XrFaceExpressionWeights2FB.__member(4), XrFaceExpressionWeights2FB.__member(POINTER_SIZE), XrFaceExpressionWeights2FB.__member(4), XrFaceExpressionWeights2FB.__member(POINTER_SIZE), XrFaceExpressionWeights2FB.__member(4), XrFaceExpressionWeights2FB.__member(4), XrFaceExpressionWeights2FB.__member(4), XrFaceExpressionWeights2FB.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        WEIGHTCOUNT = layout.offsetof(2);
        WEIGHTS = layout.offsetof(3);
        CONFIDENCECOUNT = layout.offsetof(4);
        CONFIDENCES = layout.offsetof(5);
        ISVALID = layout.offsetof(6);
        ISEYEFOLLOWINGBLENDSHAPESVALID = layout.offsetof(7);
        DATASOURCE = layout.offsetof(8);
        TIME = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<XrFaceExpressionWeights2FB, Buffer>
    implements NativeResource {
        private static final XrFaceExpressionWeights2FB ELEMENT_FACTORY = XrFaceExpressionWeights2FB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrFaceExpressionWeights2FB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFaceExpressionWeights2FB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrFaceExpressionWeights2FB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int weightCount() {
            return XrFaceExpressionWeights2FB.nweightCount(this.address());
        }

        @NativeType(value="float *")
        public FloatBuffer weights() {
            return XrFaceExpressionWeights2FB.nweights(this.address());
        }

        @NativeType(value="uint32_t")
        public int confidenceCount() {
            return XrFaceExpressionWeights2FB.nconfidenceCount(this.address());
        }

        @NativeType(value="float *")
        public FloatBuffer confidences() {
            return XrFaceExpressionWeights2FB.nconfidences(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isValid() {
            return XrFaceExpressionWeights2FB.nisValid(this.address()) != 0;
        }

        @NativeType(value="XrBool32")
        public boolean isEyeFollowingBlendshapesValid() {
            return XrFaceExpressionWeights2FB.nisEyeFollowingBlendshapesValid(this.address()) != 0;
        }

        @NativeType(value="XrFaceTrackingDataSource2FB")
        public int dataSource() {
            return XrFaceExpressionWeights2FB.ndataSource(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrFaceExpressionWeights2FB.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFaceExpressionWeights2FB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000287016);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrFaceExpressionWeights2FB.nnext(this.address(), value);
            return this;
        }

        public Buffer weights(@NativeType(value="float *") FloatBuffer value) {
            XrFaceExpressionWeights2FB.nweights(this.address(), value);
            return this;
        }

        public Buffer confidences(@NativeType(value="float *") FloatBuffer value) {
            XrFaceExpressionWeights2FB.nconfidences(this.address(), value);
            return this;
        }

        public Buffer isValid(@NativeType(value="XrBool32") boolean value) {
            XrFaceExpressionWeights2FB.nisValid(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer isEyeFollowingBlendshapesValid(@NativeType(value="XrBool32") boolean value) {
            XrFaceExpressionWeights2FB.nisEyeFollowingBlendshapesValid(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer dataSource(@NativeType(value="XrFaceTrackingDataSource2FB") int value) {
            XrFaceExpressionWeights2FB.ndataSource(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrFaceExpressionWeights2FB.ntime(this.address(), value);
            return this;
        }
    }
}

