/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFaceExpressionStatusFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFaceExpressionWeightsFB
extends Struct<XrFaceExpressionWeightsFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int WEIGHTCOUNT;
    public static final int WEIGHTS;
    public static final int CONFIDENCECOUNT;
    public static final int CONFIDENCES;
    public static final int STATUS;
    public static final int TIME;

    protected XrFaceExpressionWeightsFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrFaceExpressionWeightsFB create(long address, @Nullable ByteBuffer container) {
        return new XrFaceExpressionWeightsFB(address, container);
    }

    public XrFaceExpressionWeightsFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrFaceExpressionWeightsFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFaceExpressionWeightsFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrFaceExpressionWeightsFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int weightCount() {
        return XrFaceExpressionWeightsFB.nweightCount(this.address());
    }

    @NativeType(value="float *")
    public FloatBuffer weights() {
        return XrFaceExpressionWeightsFB.nweights(this.address());
    }

    @NativeType(value="uint32_t")
    public int confidenceCount() {
        return XrFaceExpressionWeightsFB.nconfidenceCount(this.address());
    }

    @NativeType(value="float *")
    public FloatBuffer confidences() {
        return XrFaceExpressionWeightsFB.nconfidences(this.address());
    }

    public XrFaceExpressionStatusFB status() {
        return XrFaceExpressionWeightsFB.nstatus(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrFaceExpressionWeightsFB.ntime(this.address());
    }

    public XrFaceExpressionWeightsFB type(@NativeType(value="XrStructureType") int value) {
        XrFaceExpressionWeightsFB.ntype(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeightsFB type$Default() {
        return this.type(1000201006);
    }

    public XrFaceExpressionWeightsFB next(@NativeType(value="void *") long value) {
        XrFaceExpressionWeightsFB.nnext(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeightsFB weights(@NativeType(value="float *") FloatBuffer value) {
        XrFaceExpressionWeightsFB.nweights(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeightsFB confidences(@NativeType(value="float *") FloatBuffer value) {
        XrFaceExpressionWeightsFB.nconfidences(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeightsFB status(XrFaceExpressionStatusFB value) {
        XrFaceExpressionWeightsFB.nstatus(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeightsFB status(Consumer<XrFaceExpressionStatusFB> consumer) {
        consumer.accept(this.status());
        return this;
    }

    public XrFaceExpressionWeightsFB time(@NativeType(value="XrTime") long value) {
        XrFaceExpressionWeightsFB.ntime(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeightsFB set(int type, long next, FloatBuffer weights, FloatBuffer confidences, XrFaceExpressionStatusFB status, long time) {
        this.type(type);
        this.next(next);
        this.weights(weights);
        this.confidences(confidences);
        this.status(status);
        this.time(time);
        return this;
    }

    public XrFaceExpressionWeightsFB set(XrFaceExpressionWeightsFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrFaceExpressionWeightsFB malloc() {
        return new XrFaceExpressionWeightsFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrFaceExpressionWeightsFB calloc() {
        return new XrFaceExpressionWeightsFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrFaceExpressionWeightsFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrFaceExpressionWeightsFB(MemoryUtil.memAddress(container), container);
    }

    public static XrFaceExpressionWeightsFB create(long address) {
        return new XrFaceExpressionWeightsFB(address, null);
    }

    public static @Nullable XrFaceExpressionWeightsFB createSafe(long address) {
        return address == 0L ? null : new XrFaceExpressionWeightsFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrFaceExpressionWeightsFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFaceExpressionWeightsFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFaceExpressionWeightsFB malloc(MemoryStack stack) {
        return new XrFaceExpressionWeightsFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFaceExpressionWeightsFB calloc(MemoryStack stack) {
        return new XrFaceExpressionWeightsFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nweightCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WEIGHTCOUNT);
    }

    public static FloatBuffer nweights(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)WEIGHTS), XrFaceExpressionWeightsFB.nweightCount(struct));
    }

    public static int nconfidenceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONFIDENCECOUNT);
    }

    public static FloatBuffer nconfidences(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)CONFIDENCES), XrFaceExpressionWeightsFB.nconfidenceCount(struct));
    }

    public static XrFaceExpressionStatusFB nstatus(long struct) {
        return XrFaceExpressionStatusFB.create(struct + (long)STATUS);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nweightCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WEIGHTCOUNT, value);
    }

    public static void nweights(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)WEIGHTS, MemoryUtil.memAddress(value));
        XrFaceExpressionWeightsFB.nweightCount(struct, value.remaining());
    }

    public static void nconfidenceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONFIDENCECOUNT, value);
    }

    public static void nconfidences(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)CONFIDENCES, MemoryUtil.memAddress(value));
        XrFaceExpressionWeightsFB.nconfidenceCount(struct, value.remaining());
    }

    public static void nstatus(long struct, XrFaceExpressionStatusFB value) {
        MemoryUtil.memCopy(value.address(), struct + (long)STATUS, XrFaceExpressionStatusFB.SIZEOF);
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)WEIGHTS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CONFIDENCES));
    }

    static {
        Struct.Layout layout = XrFaceExpressionWeightsFB.__struct(XrFaceExpressionWeightsFB.__member(4), XrFaceExpressionWeightsFB.__member(POINTER_SIZE), XrFaceExpressionWeightsFB.__member(4), XrFaceExpressionWeightsFB.__member(POINTER_SIZE), XrFaceExpressionWeightsFB.__member(4), XrFaceExpressionWeightsFB.__member(POINTER_SIZE), XrFaceExpressionWeightsFB.__member(XrFaceExpressionStatusFB.SIZEOF, XrFaceExpressionStatusFB.ALIGNOF), XrFaceExpressionWeightsFB.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        WEIGHTCOUNT = layout.offsetof(2);
        WEIGHTS = layout.offsetof(3);
        CONFIDENCECOUNT = layout.offsetof(4);
        CONFIDENCES = layout.offsetof(5);
        STATUS = layout.offsetof(6);
        TIME = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrFaceExpressionWeightsFB, Buffer>
    implements NativeResource {
        private static final XrFaceExpressionWeightsFB ELEMENT_FACTORY = XrFaceExpressionWeightsFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrFaceExpressionWeightsFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFaceExpressionWeightsFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrFaceExpressionWeightsFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int weightCount() {
            return XrFaceExpressionWeightsFB.nweightCount(this.address());
        }

        @NativeType(value="float *")
        public FloatBuffer weights() {
            return XrFaceExpressionWeightsFB.nweights(this.address());
        }

        @NativeType(value="uint32_t")
        public int confidenceCount() {
            return XrFaceExpressionWeightsFB.nconfidenceCount(this.address());
        }

        @NativeType(value="float *")
        public FloatBuffer confidences() {
            return XrFaceExpressionWeightsFB.nconfidences(this.address());
        }

        public XrFaceExpressionStatusFB status() {
            return XrFaceExpressionWeightsFB.nstatus(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrFaceExpressionWeightsFB.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFaceExpressionWeightsFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000201006);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrFaceExpressionWeightsFB.nnext(this.address(), value);
            return this;
        }

        public Buffer weights(@NativeType(value="float *") FloatBuffer value) {
            XrFaceExpressionWeightsFB.nweights(this.address(), value);
            return this;
        }

        public Buffer confidences(@NativeType(value="float *") FloatBuffer value) {
            XrFaceExpressionWeightsFB.nconfidences(this.address(), value);
            return this;
        }

        public Buffer status(XrFaceExpressionStatusFB value) {
            XrFaceExpressionWeightsFB.nstatus(this.address(), value);
            return this;
        }

        public Buffer status(Consumer<XrFaceExpressionStatusFB> consumer) {
            consumer.accept(this.status());
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrFaceExpressionWeightsFB.ntime(this.address(), value);
            return this;
        }
    }
}

