/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFaceTrackerCreateInfo2FB
extends Struct<XrFaceTrackerCreateInfo2FB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FACEEXPRESSIONSET;
    public static final int REQUESTEDDATASOURCECOUNT;
    public static final int REQUESTEDDATASOURCES;

    protected XrFaceTrackerCreateInfo2FB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrFaceTrackerCreateInfo2FB create(long address, @Nullable ByteBuffer container) {
        return new XrFaceTrackerCreateInfo2FB(address, container);
    }

    public XrFaceTrackerCreateInfo2FB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrFaceTrackerCreateInfo2FB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFaceTrackerCreateInfo2FB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrFaceTrackerCreateInfo2FB.nnext(this.address());
    }

    @NativeType(value="XrFaceExpressionSet2FB")
    public int faceExpressionSet() {
        return XrFaceTrackerCreateInfo2FB.nfaceExpressionSet(this.address());
    }

    @NativeType(value="uint32_t")
    public int requestedDataSourceCount() {
        return XrFaceTrackerCreateInfo2FB.nrequestedDataSourceCount(this.address());
    }

    @NativeType(value="XrFaceTrackingDataSource2FB *")
    public @Nullable IntBuffer requestedDataSources() {
        return XrFaceTrackerCreateInfo2FB.nrequestedDataSources(this.address());
    }

    public XrFaceTrackerCreateInfo2FB type(@NativeType(value="XrStructureType") int value) {
        XrFaceTrackerCreateInfo2FB.ntype(this.address(), value);
        return this;
    }

    public XrFaceTrackerCreateInfo2FB type$Default() {
        return this.type(1000287014);
    }

    public XrFaceTrackerCreateInfo2FB next(@NativeType(value="void const *") long value) {
        XrFaceTrackerCreateInfo2FB.nnext(this.address(), value);
        return this;
    }

    public XrFaceTrackerCreateInfo2FB faceExpressionSet(@NativeType(value="XrFaceExpressionSet2FB") int value) {
        XrFaceTrackerCreateInfo2FB.nfaceExpressionSet(this.address(), value);
        return this;
    }

    public XrFaceTrackerCreateInfo2FB requestedDataSourceCount(@NativeType(value="uint32_t") int value) {
        XrFaceTrackerCreateInfo2FB.nrequestedDataSourceCount(this.address(), value);
        return this;
    }

    public XrFaceTrackerCreateInfo2FB requestedDataSources(@NativeType(value="XrFaceTrackingDataSource2FB *") @Nullable IntBuffer value) {
        XrFaceTrackerCreateInfo2FB.nrequestedDataSources(this.address(), value);
        return this;
    }

    public XrFaceTrackerCreateInfo2FB set(int type, long next, int faceExpressionSet, int requestedDataSourceCount, @Nullable IntBuffer requestedDataSources) {
        this.type(type);
        this.next(next);
        this.faceExpressionSet(faceExpressionSet);
        this.requestedDataSourceCount(requestedDataSourceCount);
        this.requestedDataSources(requestedDataSources);
        return this;
    }

    public XrFaceTrackerCreateInfo2FB set(XrFaceTrackerCreateInfo2FB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrFaceTrackerCreateInfo2FB malloc() {
        return new XrFaceTrackerCreateInfo2FB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrFaceTrackerCreateInfo2FB calloc() {
        return new XrFaceTrackerCreateInfo2FB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrFaceTrackerCreateInfo2FB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrFaceTrackerCreateInfo2FB(MemoryUtil.memAddress(container), container);
    }

    public static XrFaceTrackerCreateInfo2FB create(long address) {
        return new XrFaceTrackerCreateInfo2FB(address, null);
    }

    public static @Nullable XrFaceTrackerCreateInfo2FB createSafe(long address) {
        return address == 0L ? null : new XrFaceTrackerCreateInfo2FB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrFaceTrackerCreateInfo2FB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFaceTrackerCreateInfo2FB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFaceTrackerCreateInfo2FB malloc(MemoryStack stack) {
        return new XrFaceTrackerCreateInfo2FB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFaceTrackerCreateInfo2FB calloc(MemoryStack stack) {
        return new XrFaceTrackerCreateInfo2FB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nfaceExpressionSet(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FACEEXPRESSIONSET);
    }

    public static int nrequestedDataSourceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REQUESTEDDATASOURCECOUNT);
    }

    public static @Nullable IntBuffer nrequestedDataSources(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)REQUESTEDDATASOURCES), XrFaceTrackerCreateInfo2FB.nrequestedDataSourceCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nfaceExpressionSet(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FACEEXPRESSIONSET, value);
    }

    public static void nrequestedDataSourceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REQUESTEDDATASOURCECOUNT, value);
    }

    public static void nrequestedDataSources(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)REQUESTEDDATASOURCES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrFaceTrackerCreateInfo2FB.nrequestedDataSourceCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrFaceTrackerCreateInfo2FB.__struct(XrFaceTrackerCreateInfo2FB.__member(4), XrFaceTrackerCreateInfo2FB.__member(POINTER_SIZE), XrFaceTrackerCreateInfo2FB.__member(4), XrFaceTrackerCreateInfo2FB.__member(4), XrFaceTrackerCreateInfo2FB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FACEEXPRESSIONSET = layout.offsetof(2);
        REQUESTEDDATASOURCECOUNT = layout.offsetof(3);
        REQUESTEDDATASOURCES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrFaceTrackerCreateInfo2FB, Buffer>
    implements NativeResource {
        private static final XrFaceTrackerCreateInfo2FB ELEMENT_FACTORY = XrFaceTrackerCreateInfo2FB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrFaceTrackerCreateInfo2FB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFaceTrackerCreateInfo2FB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrFaceTrackerCreateInfo2FB.nnext(this.address());
        }

        @NativeType(value="XrFaceExpressionSet2FB")
        public int faceExpressionSet() {
            return XrFaceTrackerCreateInfo2FB.nfaceExpressionSet(this.address());
        }

        @NativeType(value="uint32_t")
        public int requestedDataSourceCount() {
            return XrFaceTrackerCreateInfo2FB.nrequestedDataSourceCount(this.address());
        }

        @NativeType(value="XrFaceTrackingDataSource2FB *")
        public @Nullable IntBuffer requestedDataSources() {
            return XrFaceTrackerCreateInfo2FB.nrequestedDataSources(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFaceTrackerCreateInfo2FB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000287014);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrFaceTrackerCreateInfo2FB.nnext(this.address(), value);
            return this;
        }

        public Buffer faceExpressionSet(@NativeType(value="XrFaceExpressionSet2FB") int value) {
            XrFaceTrackerCreateInfo2FB.nfaceExpressionSet(this.address(), value);
            return this;
        }

        public Buffer requestedDataSourceCount(@NativeType(value="uint32_t") int value) {
            XrFaceTrackerCreateInfo2FB.nrequestedDataSourceCount(this.address(), value);
            return this;
        }

        public Buffer requestedDataSources(@NativeType(value="XrFaceTrackingDataSource2FB *") @Nullable IntBuffer value) {
            XrFaceTrackerCreateInfo2FB.nrequestedDataSources(this.address(), value);
            return this;
        }
    }
}

