/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSecondaryViewConfigurationFrameStateMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFrameState
extends Struct<XrFrameState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PREDICTEDDISPLAYTIME;
    public static final int PREDICTEDDISPLAYPERIOD;
    public static final int SHOULDRENDER;

    protected XrFrameState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrFrameState create(long address, @Nullable ByteBuffer container) {
        return new XrFrameState(address, container);
    }

    public XrFrameState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrFrameState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFrameState.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrFrameState.nnext(this.address());
    }

    @NativeType(value="XrTime")
    public long predictedDisplayTime() {
        return XrFrameState.npredictedDisplayTime(this.address());
    }

    @NativeType(value="XrDuration")
    public long predictedDisplayPeriod() {
        return XrFrameState.npredictedDisplayPeriod(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean shouldRender() {
        return XrFrameState.nshouldRender(this.address()) != 0;
    }

    public XrFrameState type(@NativeType(value="XrStructureType") int value) {
        XrFrameState.ntype(this.address(), value);
        return this;
    }

    public XrFrameState type$Default() {
        return this.type(44);
    }

    public XrFrameState next(@NativeType(value="void *") long value) {
        XrFrameState.nnext(this.address(), value);
        return this;
    }

    public XrFrameState next(XrSecondaryViewConfigurationFrameStateMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrFrameState predictedDisplayTime(@NativeType(value="XrTime") long value) {
        XrFrameState.npredictedDisplayTime(this.address(), value);
        return this;
    }

    public XrFrameState predictedDisplayPeriod(@NativeType(value="XrDuration") long value) {
        XrFrameState.npredictedDisplayPeriod(this.address(), value);
        return this;
    }

    public XrFrameState shouldRender(@NativeType(value="XrBool32") boolean value) {
        XrFrameState.nshouldRender(this.address(), value ? 1 : 0);
        return this;
    }

    public XrFrameState set(int type, long next, long predictedDisplayTime, long predictedDisplayPeriod, boolean shouldRender) {
        this.type(type);
        this.next(next);
        this.predictedDisplayTime(predictedDisplayTime);
        this.predictedDisplayPeriod(predictedDisplayPeriod);
        this.shouldRender(shouldRender);
        return this;
    }

    public XrFrameState set(XrFrameState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrFrameState malloc() {
        return new XrFrameState(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrFrameState calloc() {
        return new XrFrameState(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrFrameState create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrFrameState(MemoryUtil.memAddress(container), container);
    }

    public static XrFrameState create(long address) {
        return new XrFrameState(address, null);
    }

    public static @Nullable XrFrameState createSafe(long address) {
        return address == 0L ? null : new XrFrameState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrFrameState.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFrameState.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFrameState malloc(MemoryStack stack) {
        return new XrFrameState(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFrameState calloc(MemoryStack stack) {
        return new XrFrameState(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long npredictedDisplayTime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)PREDICTEDDISPLAYTIME);
    }

    public static long npredictedDisplayPeriod(long struct) {
        return MemoryUtil.memGetLong(struct + (long)PREDICTEDDISPLAYPERIOD);
    }

    public static int nshouldRender(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHOULDRENDER);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void npredictedDisplayTime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)PREDICTEDDISPLAYTIME, value);
    }

    public static void npredictedDisplayPeriod(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)PREDICTEDDISPLAYPERIOD, value);
    }

    public static void nshouldRender(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHOULDRENDER, value);
    }

    static {
        Struct.Layout layout = XrFrameState.__struct(XrFrameState.__member(4), XrFrameState.__member(POINTER_SIZE), XrFrameState.__member(8), XrFrameState.__member(8), XrFrameState.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PREDICTEDDISPLAYTIME = layout.offsetof(2);
        PREDICTEDDISPLAYPERIOD = layout.offsetof(3);
        SHOULDRENDER = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrFrameState, Buffer>
    implements NativeResource {
        private static final XrFrameState ELEMENT_FACTORY = XrFrameState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrFrameState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFrameState.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrFrameState.nnext(this.address());
        }

        @NativeType(value="XrTime")
        public long predictedDisplayTime() {
            return XrFrameState.npredictedDisplayTime(this.address());
        }

        @NativeType(value="XrDuration")
        public long predictedDisplayPeriod() {
            return XrFrameState.npredictedDisplayPeriod(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean shouldRender() {
            return XrFrameState.nshouldRender(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFrameState.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(44);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrFrameState.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrSecondaryViewConfigurationFrameStateMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer predictedDisplayTime(@NativeType(value="XrTime") long value) {
            XrFrameState.npredictedDisplayTime(this.address(), value);
            return this;
        }

        public Buffer predictedDisplayPeriod(@NativeType(value="XrDuration") long value) {
            XrFrameState.npredictedDisplayPeriod(this.address(), value);
            return this;
        }

        public Buffer shouldRender(@NativeType(value="XrBool32") boolean value) {
            XrFrameState.nshouldRender(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

