/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGeometryInstanceTransformFB
extends Struct<XrGeometryInstanceTransformFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int TIME;
    public static final int POSE;
    public static final int SCALE;

    protected XrGeometryInstanceTransformFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrGeometryInstanceTransformFB create(long address, @Nullable ByteBuffer container) {
        return new XrGeometryInstanceTransformFB(address, container);
    }

    public XrGeometryInstanceTransformFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrGeometryInstanceTransformFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGeometryInstanceTransformFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGeometryInstanceTransformFB.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrGeometryInstanceTransformFB.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrGeometryInstanceTransformFB.ntime(this.address());
    }

    public XrPosef pose() {
        return XrGeometryInstanceTransformFB.npose(this.address());
    }

    public XrVector3f scale() {
        return XrGeometryInstanceTransformFB.nscale(this.address());
    }

    public XrGeometryInstanceTransformFB type(@NativeType(value="XrStructureType") int value) {
        XrGeometryInstanceTransformFB.ntype(this.address(), value);
        return this;
    }

    public XrGeometryInstanceTransformFB type$Default() {
        return this.type(1000118005);
    }

    public XrGeometryInstanceTransformFB next(@NativeType(value="void const *") long value) {
        XrGeometryInstanceTransformFB.nnext(this.address(), value);
        return this;
    }

    public XrGeometryInstanceTransformFB baseSpace(XrSpace value) {
        XrGeometryInstanceTransformFB.nbaseSpace(this.address(), value);
        return this;
    }

    public XrGeometryInstanceTransformFB time(@NativeType(value="XrTime") long value) {
        XrGeometryInstanceTransformFB.ntime(this.address(), value);
        return this;
    }

    public XrGeometryInstanceTransformFB pose(XrPosef value) {
        XrGeometryInstanceTransformFB.npose(this.address(), value);
        return this;
    }

    public XrGeometryInstanceTransformFB pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrGeometryInstanceTransformFB scale(XrVector3f value) {
        XrGeometryInstanceTransformFB.nscale(this.address(), value);
        return this;
    }

    public XrGeometryInstanceTransformFB scale(Consumer<XrVector3f> consumer) {
        consumer.accept(this.scale());
        return this;
    }

    public XrGeometryInstanceTransformFB set(int type, long next, XrSpace baseSpace, long time, XrPosef pose, XrVector3f scale) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        this.pose(pose);
        this.scale(scale);
        return this;
    }

    public XrGeometryInstanceTransformFB set(XrGeometryInstanceTransformFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrGeometryInstanceTransformFB malloc() {
        return new XrGeometryInstanceTransformFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrGeometryInstanceTransformFB calloc() {
        return new XrGeometryInstanceTransformFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrGeometryInstanceTransformFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrGeometryInstanceTransformFB(MemoryUtil.memAddress(container), container);
    }

    public static XrGeometryInstanceTransformFB create(long address) {
        return new XrGeometryInstanceTransformFB(address, null);
    }

    public static @Nullable XrGeometryInstanceTransformFB createSafe(long address) {
        return address == 0L ? null : new XrGeometryInstanceTransformFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrGeometryInstanceTransformFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGeometryInstanceTransformFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrGeometryInstanceTransformFB malloc(MemoryStack stack) {
        return new XrGeometryInstanceTransformFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrGeometryInstanceTransformFB calloc(MemoryStack stack) {
        return new XrGeometryInstanceTransformFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BASESPACE);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrVector3f nscale(long struct) {
        return XrVector3f.create(struct + (long)SCALE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)BASESPACE, value.address());
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    public static void nscale(long struct, XrVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCALE, XrVector3f.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)BASESPACE));
    }

    static {
        Struct.Layout layout = XrGeometryInstanceTransformFB.__struct(XrGeometryInstanceTransformFB.__member(4), XrGeometryInstanceTransformFB.__member(POINTER_SIZE), XrGeometryInstanceTransformFB.__member(POINTER_SIZE), XrGeometryInstanceTransformFB.__member(8), XrGeometryInstanceTransformFB.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrGeometryInstanceTransformFB.__member(XrVector3f.SIZEOF, XrVector3f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        TIME = layout.offsetof(3);
        POSE = layout.offsetof(4);
        SCALE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrGeometryInstanceTransformFB, Buffer>
    implements NativeResource {
        private static final XrGeometryInstanceTransformFB ELEMENT_FACTORY = XrGeometryInstanceTransformFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrGeometryInstanceTransformFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGeometryInstanceTransformFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGeometryInstanceTransformFB.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrGeometryInstanceTransformFB.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrGeometryInstanceTransformFB.ntime(this.address());
        }

        public XrPosef pose() {
            return XrGeometryInstanceTransformFB.npose(this.address());
        }

        public XrVector3f scale() {
            return XrGeometryInstanceTransformFB.nscale(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGeometryInstanceTransformFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118005);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGeometryInstanceTransformFB.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrGeometryInstanceTransformFB.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrGeometryInstanceTransformFB.ntime(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrGeometryInstanceTransformFB.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer scale(XrVector3f value) {
            XrGeometryInstanceTransformFB.nscale(this.address(), value);
            return this;
        }

        public Buffer scale(Consumer<XrVector3f> consumer) {
            consumer.accept(this.scale());
            return this;
        }
    }
}

