/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGraphicsBindingEGLMNDX
extends Struct<XrGraphicsBindingEGLMNDX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int GETPROCADDRESS;
    public static final int DISPLAY;
    public static final int CONFIG;
    public static final int CONTEXT;

    protected XrGraphicsBindingEGLMNDX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrGraphicsBindingEGLMNDX create(long address, @Nullable ByteBuffer container) {
        return new XrGraphicsBindingEGLMNDX(address, container);
    }

    public XrGraphicsBindingEGLMNDX(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrGraphicsBindingEGLMNDX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGraphicsBindingEGLMNDX.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGraphicsBindingEGLMNDX.nnext(this.address());
    }

    @NativeType(value="PFN_xrEglGetProcAddressMNDX")
    public long getProcAddress() {
        return XrGraphicsBindingEGLMNDX.ngetProcAddress(this.address());
    }

    @NativeType(value="EGLDisplay")
    public long display() {
        return XrGraphicsBindingEGLMNDX.ndisplay(this.address());
    }

    @NativeType(value="EGLConfig")
    public long config() {
        return XrGraphicsBindingEGLMNDX.nconfig(this.address());
    }

    @NativeType(value="EGLContext")
    public long context() {
        return XrGraphicsBindingEGLMNDX.ncontext(this.address());
    }

    public XrGraphicsBindingEGLMNDX type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsBindingEGLMNDX.ntype(this.address(), value);
        return this;
    }

    public XrGraphicsBindingEGLMNDX type$Default() {
        return this.type(1000048004);
    }

    public XrGraphicsBindingEGLMNDX next(@NativeType(value="void const *") long value) {
        XrGraphicsBindingEGLMNDX.nnext(this.address(), value);
        return this;
    }

    public XrGraphicsBindingEGLMNDX getProcAddress(@NativeType(value="PFN_xrEglGetProcAddressMNDX") long value) {
        XrGraphicsBindingEGLMNDX.ngetProcAddress(this.address(), value);
        return this;
    }

    public XrGraphicsBindingEGLMNDX display(@NativeType(value="EGLDisplay") long value) {
        XrGraphicsBindingEGLMNDX.ndisplay(this.address(), value);
        return this;
    }

    public XrGraphicsBindingEGLMNDX config(@NativeType(value="EGLConfig") long value) {
        XrGraphicsBindingEGLMNDX.nconfig(this.address(), value);
        return this;
    }

    public XrGraphicsBindingEGLMNDX context(@NativeType(value="EGLContext") long value) {
        XrGraphicsBindingEGLMNDX.ncontext(this.address(), value);
        return this;
    }

    public XrGraphicsBindingEGLMNDX set(int type, long next, long getProcAddress, long display, long config, long context) {
        this.type(type);
        this.next(next);
        this.getProcAddress(getProcAddress);
        this.display(display);
        this.config(config);
        this.context(context);
        return this;
    }

    public XrGraphicsBindingEGLMNDX set(XrGraphicsBindingEGLMNDX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrGraphicsBindingEGLMNDX malloc() {
        return new XrGraphicsBindingEGLMNDX(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrGraphicsBindingEGLMNDX calloc() {
        return new XrGraphicsBindingEGLMNDX(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrGraphicsBindingEGLMNDX create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrGraphicsBindingEGLMNDX(MemoryUtil.memAddress(container), container);
    }

    public static XrGraphicsBindingEGLMNDX create(long address) {
        return new XrGraphicsBindingEGLMNDX(address, null);
    }

    public static @Nullable XrGraphicsBindingEGLMNDX createSafe(long address) {
        return address == 0L ? null : new XrGraphicsBindingEGLMNDX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrGraphicsBindingEGLMNDX.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsBindingEGLMNDX.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrGraphicsBindingEGLMNDX malloc(MemoryStack stack) {
        return new XrGraphicsBindingEGLMNDX(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrGraphicsBindingEGLMNDX calloc(MemoryStack stack) {
        return new XrGraphicsBindingEGLMNDX(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long ngetProcAddress(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)GETPROCADDRESS);
    }

    public static long ndisplay(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DISPLAY);
    }

    public static long nconfig(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CONFIG);
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CONTEXT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ngetProcAddress(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)GETPROCADDRESS, Checks.check(value));
    }

    public static void ndisplay(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DISPLAY, Checks.check(value));
    }

    public static void nconfig(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CONFIG, Checks.check(value));
    }

    public static void ncontext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CONTEXT, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)GETPROCADDRESS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DISPLAY));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CONFIG));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CONTEXT));
    }

    static {
        Struct.Layout layout = XrGraphicsBindingEGLMNDX.__struct(XrGraphicsBindingEGLMNDX.__member(4), XrGraphicsBindingEGLMNDX.__member(POINTER_SIZE), XrGraphicsBindingEGLMNDX.__member(POINTER_SIZE), XrGraphicsBindingEGLMNDX.__member(POINTER_SIZE), XrGraphicsBindingEGLMNDX.__member(POINTER_SIZE), XrGraphicsBindingEGLMNDX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        GETPROCADDRESS = layout.offsetof(2);
        DISPLAY = layout.offsetof(3);
        CONFIG = layout.offsetof(4);
        CONTEXT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrGraphicsBindingEGLMNDX, Buffer>
    implements NativeResource {
        private static final XrGraphicsBindingEGLMNDX ELEMENT_FACTORY = XrGraphicsBindingEGLMNDX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrGraphicsBindingEGLMNDX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGraphicsBindingEGLMNDX.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGraphicsBindingEGLMNDX.nnext(this.address());
        }

        @NativeType(value="PFN_xrEglGetProcAddressMNDX")
        public long getProcAddress() {
            return XrGraphicsBindingEGLMNDX.ngetProcAddress(this.address());
        }

        @NativeType(value="EGLDisplay")
        public long display() {
            return XrGraphicsBindingEGLMNDX.ndisplay(this.address());
        }

        @NativeType(value="EGLConfig")
        public long config() {
            return XrGraphicsBindingEGLMNDX.nconfig(this.address());
        }

        @NativeType(value="EGLContext")
        public long context() {
            return XrGraphicsBindingEGLMNDX.ncontext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsBindingEGLMNDX.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000048004);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGraphicsBindingEGLMNDX.nnext(this.address(), value);
            return this;
        }

        public Buffer getProcAddress(@NativeType(value="PFN_xrEglGetProcAddressMNDX") long value) {
            XrGraphicsBindingEGLMNDX.ngetProcAddress(this.address(), value);
            return this;
        }

        public Buffer display(@NativeType(value="EGLDisplay") long value) {
            XrGraphicsBindingEGLMNDX.ndisplay(this.address(), value);
            return this;
        }

        public Buffer config(@NativeType(value="EGLConfig") long value) {
            XrGraphicsBindingEGLMNDX.nconfig(this.address(), value);
            return this;
        }

        public Buffer context(@NativeType(value="EGLContext") long value) {
            XrGraphicsBindingEGLMNDX.ncontext(this.address(), value);
            return this;
        }
    }
}

