/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGraphicsBindingOpenGLWaylandKHR
extends Struct<XrGraphicsBindingOpenGLWaylandKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int DISPLAY;

    protected XrGraphicsBindingOpenGLWaylandKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrGraphicsBindingOpenGLWaylandKHR create(long address, @Nullable ByteBuffer container) {
        return new XrGraphicsBindingOpenGLWaylandKHR(address, container);
    }

    public XrGraphicsBindingOpenGLWaylandKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrGraphicsBindingOpenGLWaylandKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGraphicsBindingOpenGLWaylandKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGraphicsBindingOpenGLWaylandKHR.nnext(this.address());
    }

    @NativeType(value="struct wl_display *")
    public long display() {
        return XrGraphicsBindingOpenGLWaylandKHR.ndisplay(this.address());
    }

    public XrGraphicsBindingOpenGLWaylandKHR type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsBindingOpenGLWaylandKHR.ntype(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLWaylandKHR type$Default() {
        return this.type(1000023003);
    }

    public XrGraphicsBindingOpenGLWaylandKHR next(@NativeType(value="void const *") long value) {
        XrGraphicsBindingOpenGLWaylandKHR.nnext(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLWaylandKHR display(@NativeType(value="struct wl_display *") long value) {
        XrGraphicsBindingOpenGLWaylandKHR.ndisplay(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLWaylandKHR set(int type, long next, long display) {
        this.type(type);
        this.next(next);
        this.display(display);
        return this;
    }

    public XrGraphicsBindingOpenGLWaylandKHR set(XrGraphicsBindingOpenGLWaylandKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrGraphicsBindingOpenGLWaylandKHR malloc() {
        return new XrGraphicsBindingOpenGLWaylandKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrGraphicsBindingOpenGLWaylandKHR calloc() {
        return new XrGraphicsBindingOpenGLWaylandKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrGraphicsBindingOpenGLWaylandKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrGraphicsBindingOpenGLWaylandKHR(MemoryUtil.memAddress(container), container);
    }

    public static XrGraphicsBindingOpenGLWaylandKHR create(long address) {
        return new XrGraphicsBindingOpenGLWaylandKHR(address, null);
    }

    public static @Nullable XrGraphicsBindingOpenGLWaylandKHR createSafe(long address) {
        return address == 0L ? null : new XrGraphicsBindingOpenGLWaylandKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrGraphicsBindingOpenGLWaylandKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsBindingOpenGLWaylandKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrGraphicsBindingOpenGLWaylandKHR malloc(MemoryStack stack) {
        return new XrGraphicsBindingOpenGLWaylandKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrGraphicsBindingOpenGLWaylandKHR calloc(MemoryStack stack) {
        return new XrGraphicsBindingOpenGLWaylandKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long ndisplay(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DISPLAY);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ndisplay(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DISPLAY, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DISPLAY));
    }

    static {
        Struct.Layout layout = XrGraphicsBindingOpenGLWaylandKHR.__struct(XrGraphicsBindingOpenGLWaylandKHR.__member(4), XrGraphicsBindingOpenGLWaylandKHR.__member(POINTER_SIZE), XrGraphicsBindingOpenGLWaylandKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        DISPLAY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrGraphicsBindingOpenGLWaylandKHR, Buffer>
    implements NativeResource {
        private static final XrGraphicsBindingOpenGLWaylandKHR ELEMENT_FACTORY = XrGraphicsBindingOpenGLWaylandKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrGraphicsBindingOpenGLWaylandKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGraphicsBindingOpenGLWaylandKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGraphicsBindingOpenGLWaylandKHR.nnext(this.address());
        }

        @NativeType(value="struct wl_display *")
        public long display() {
            return XrGraphicsBindingOpenGLWaylandKHR.ndisplay(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsBindingOpenGLWaylandKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000023003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGraphicsBindingOpenGLWaylandKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer display(@NativeType(value="struct wl_display *") long value) {
            XrGraphicsBindingOpenGLWaylandKHR.ndisplay(this.address(), value);
            return this;
        }
    }
}

