/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGraphicsBindingOpenGLXcbKHR
extends Struct<XrGraphicsBindingOpenGLXcbKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CONNECTION;
    public static final int SCREENNUMBER;
    public static final int FBCONFIGID;
    public static final int VISUALID;
    public static final int GLXDRAWABLE;
    public static final int GLXCONTEXT;

    protected XrGraphicsBindingOpenGLXcbKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrGraphicsBindingOpenGLXcbKHR create(long address, @Nullable ByteBuffer container) {
        return new XrGraphicsBindingOpenGLXcbKHR(address, container);
    }

    public XrGraphicsBindingOpenGLXcbKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrGraphicsBindingOpenGLXcbKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGraphicsBindingOpenGLXcbKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGraphicsBindingOpenGLXcbKHR.nnext(this.address());
    }

    @NativeType(value="xcb_connection_t *")
    public long connection() {
        return XrGraphicsBindingOpenGLXcbKHR.nconnection(this.address());
    }

    @NativeType(value="uint32_t")
    public int screenNumber() {
        return XrGraphicsBindingOpenGLXcbKHR.nscreenNumber(this.address());
    }

    @NativeType(value="xcb_glx_fbconfig_t")
    public int fbconfigid() {
        return XrGraphicsBindingOpenGLXcbKHR.nfbconfigid(this.address());
    }

    @NativeType(value="xcb_visualid_t")
    public int visualid() {
        return XrGraphicsBindingOpenGLXcbKHR.nvisualid(this.address());
    }

    @NativeType(value="xcb_glx_drawable_t")
    public int glxDrawable() {
        return XrGraphicsBindingOpenGLXcbKHR.nglxDrawable(this.address());
    }

    @NativeType(value="xcb_glx_context_t")
    public int glxContext() {
        return XrGraphicsBindingOpenGLXcbKHR.nglxContext(this.address());
    }

    public XrGraphicsBindingOpenGLXcbKHR type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsBindingOpenGLXcbKHR.ntype(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXcbKHR type$Default() {
        return this.type(1000023002);
    }

    public XrGraphicsBindingOpenGLXcbKHR next(@NativeType(value="void const *") long value) {
        XrGraphicsBindingOpenGLXcbKHR.nnext(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXcbKHR connection(@NativeType(value="xcb_connection_t *") long value) {
        XrGraphicsBindingOpenGLXcbKHR.nconnection(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXcbKHR screenNumber(@NativeType(value="uint32_t") int value) {
        XrGraphicsBindingOpenGLXcbKHR.nscreenNumber(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXcbKHR fbconfigid(@NativeType(value="xcb_glx_fbconfig_t") int value) {
        XrGraphicsBindingOpenGLXcbKHR.nfbconfigid(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXcbKHR visualid(@NativeType(value="xcb_visualid_t") int value) {
        XrGraphicsBindingOpenGLXcbKHR.nvisualid(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXcbKHR glxDrawable(@NativeType(value="xcb_glx_drawable_t") int value) {
        XrGraphicsBindingOpenGLXcbKHR.nglxDrawable(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXcbKHR glxContext(@NativeType(value="xcb_glx_context_t") int value) {
        XrGraphicsBindingOpenGLXcbKHR.nglxContext(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXcbKHR set(int type, long next, long connection, int screenNumber, int fbconfigid, int visualid, int glxDrawable, int glxContext) {
        this.type(type);
        this.next(next);
        this.connection(connection);
        this.screenNumber(screenNumber);
        this.fbconfigid(fbconfigid);
        this.visualid(visualid);
        this.glxDrawable(glxDrawable);
        this.glxContext(glxContext);
        return this;
    }

    public XrGraphicsBindingOpenGLXcbKHR set(XrGraphicsBindingOpenGLXcbKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrGraphicsBindingOpenGLXcbKHR malloc() {
        return new XrGraphicsBindingOpenGLXcbKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrGraphicsBindingOpenGLXcbKHR calloc() {
        return new XrGraphicsBindingOpenGLXcbKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrGraphicsBindingOpenGLXcbKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrGraphicsBindingOpenGLXcbKHR(MemoryUtil.memAddress(container), container);
    }

    public static XrGraphicsBindingOpenGLXcbKHR create(long address) {
        return new XrGraphicsBindingOpenGLXcbKHR(address, null);
    }

    public static @Nullable XrGraphicsBindingOpenGLXcbKHR createSafe(long address) {
        return address == 0L ? null : new XrGraphicsBindingOpenGLXcbKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrGraphicsBindingOpenGLXcbKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsBindingOpenGLXcbKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrGraphicsBindingOpenGLXcbKHR malloc(MemoryStack stack) {
        return new XrGraphicsBindingOpenGLXcbKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrGraphicsBindingOpenGLXcbKHR calloc(MemoryStack stack) {
        return new XrGraphicsBindingOpenGLXcbKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nconnection(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CONNECTION);
    }

    public static int nscreenNumber(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SCREENNUMBER);
    }

    public static int nfbconfigid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FBCONFIGID);
    }

    public static int nvisualid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VISUALID);
    }

    public static int nglxDrawable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GLXDRAWABLE);
    }

    public static int nglxContext(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GLXCONTEXT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nconnection(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CONNECTION, Checks.check(value));
    }

    public static void nscreenNumber(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SCREENNUMBER, value);
    }

    public static void nfbconfigid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FBCONFIGID, value);
    }

    public static void nvisualid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VISUALID, value);
    }

    public static void nglxDrawable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GLXDRAWABLE, value);
    }

    public static void nglxContext(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GLXCONTEXT, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CONNECTION));
    }

    static {
        Struct.Layout layout = XrGraphicsBindingOpenGLXcbKHR.__struct(XrGraphicsBindingOpenGLXcbKHR.__member(4), XrGraphicsBindingOpenGLXcbKHR.__member(POINTER_SIZE), XrGraphicsBindingOpenGLXcbKHR.__member(POINTER_SIZE), XrGraphicsBindingOpenGLXcbKHR.__member(4), XrGraphicsBindingOpenGLXcbKHR.__member(4), XrGraphicsBindingOpenGLXcbKHR.__member(4), XrGraphicsBindingOpenGLXcbKHR.__member(4), XrGraphicsBindingOpenGLXcbKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CONNECTION = layout.offsetof(2);
        SCREENNUMBER = layout.offsetof(3);
        FBCONFIGID = layout.offsetof(4);
        VISUALID = layout.offsetof(5);
        GLXDRAWABLE = layout.offsetof(6);
        GLXCONTEXT = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrGraphicsBindingOpenGLXcbKHR, Buffer>
    implements NativeResource {
        private static final XrGraphicsBindingOpenGLXcbKHR ELEMENT_FACTORY = XrGraphicsBindingOpenGLXcbKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrGraphicsBindingOpenGLXcbKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGraphicsBindingOpenGLXcbKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGraphicsBindingOpenGLXcbKHR.nnext(this.address());
        }

        @NativeType(value="xcb_connection_t *")
        public long connection() {
            return XrGraphicsBindingOpenGLXcbKHR.nconnection(this.address());
        }

        @NativeType(value="uint32_t")
        public int screenNumber() {
            return XrGraphicsBindingOpenGLXcbKHR.nscreenNumber(this.address());
        }

        @NativeType(value="xcb_glx_fbconfig_t")
        public int fbconfigid() {
            return XrGraphicsBindingOpenGLXcbKHR.nfbconfigid(this.address());
        }

        @NativeType(value="xcb_visualid_t")
        public int visualid() {
            return XrGraphicsBindingOpenGLXcbKHR.nvisualid(this.address());
        }

        @NativeType(value="xcb_glx_drawable_t")
        public int glxDrawable() {
            return XrGraphicsBindingOpenGLXcbKHR.nglxDrawable(this.address());
        }

        @NativeType(value="xcb_glx_context_t")
        public int glxContext() {
            return XrGraphicsBindingOpenGLXcbKHR.nglxContext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsBindingOpenGLXcbKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000023002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGraphicsBindingOpenGLXcbKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer connection(@NativeType(value="xcb_connection_t *") long value) {
            XrGraphicsBindingOpenGLXcbKHR.nconnection(this.address(), value);
            return this;
        }

        public Buffer screenNumber(@NativeType(value="uint32_t") int value) {
            XrGraphicsBindingOpenGLXcbKHR.nscreenNumber(this.address(), value);
            return this;
        }

        public Buffer fbconfigid(@NativeType(value="xcb_glx_fbconfig_t") int value) {
            XrGraphicsBindingOpenGLXcbKHR.nfbconfigid(this.address(), value);
            return this;
        }

        public Buffer visualid(@NativeType(value="xcb_visualid_t") int value) {
            XrGraphicsBindingOpenGLXcbKHR.nvisualid(this.address(), value);
            return this;
        }

        public Buffer glxDrawable(@NativeType(value="xcb_glx_drawable_t") int value) {
            XrGraphicsBindingOpenGLXcbKHR.nglxDrawable(this.address(), value);
            return this;
        }

        public Buffer glxContext(@NativeType(value="xcb_glx_context_t") int value) {
            XrGraphicsBindingOpenGLXcbKHR.nglxContext(this.address(), value);
            return this;
        }
    }
}

