/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGraphicsBindingOpenGLXlibKHR
extends Struct<XrGraphicsBindingOpenGLXlibKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int XDISPLAY;
    public static final int VISUALID;
    public static final int GLXFBCONFIG;
    public static final int GLXDRAWABLE;
    public static final int GLXCONTEXT;

    protected XrGraphicsBindingOpenGLXlibKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrGraphicsBindingOpenGLXlibKHR create(long address, @Nullable ByteBuffer container) {
        return new XrGraphicsBindingOpenGLXlibKHR(address, container);
    }

    public XrGraphicsBindingOpenGLXlibKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrGraphicsBindingOpenGLXlibKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGraphicsBindingOpenGLXlibKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGraphicsBindingOpenGLXlibKHR.nnext(this.address());
    }

    @NativeType(value="Display *")
    public long xDisplay() {
        return XrGraphicsBindingOpenGLXlibKHR.nxDisplay(this.address());
    }

    @NativeType(value="uint32_t")
    public int visualid() {
        return XrGraphicsBindingOpenGLXlibKHR.nvisualid(this.address());
    }

    @NativeType(value="GLXFBConfig")
    public long glxFBConfig() {
        return XrGraphicsBindingOpenGLXlibKHR.nglxFBConfig(this.address());
    }

    @NativeType(value="GLXDrawable")
    public long glxDrawable() {
        return XrGraphicsBindingOpenGLXlibKHR.nglxDrawable(this.address());
    }

    @NativeType(value="GLXContext")
    public long glxContext() {
        return XrGraphicsBindingOpenGLXlibKHR.nglxContext(this.address());
    }

    public XrGraphicsBindingOpenGLXlibKHR type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsBindingOpenGLXlibKHR.ntype(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXlibKHR type$Default() {
        return this.type(1000023001);
    }

    public XrGraphicsBindingOpenGLXlibKHR next(@NativeType(value="void const *") long value) {
        XrGraphicsBindingOpenGLXlibKHR.nnext(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXlibKHR xDisplay(@NativeType(value="Display *") long value) {
        XrGraphicsBindingOpenGLXlibKHR.nxDisplay(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXlibKHR visualid(@NativeType(value="uint32_t") int value) {
        XrGraphicsBindingOpenGLXlibKHR.nvisualid(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXlibKHR glxFBConfig(@NativeType(value="GLXFBConfig") long value) {
        XrGraphicsBindingOpenGLXlibKHR.nglxFBConfig(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXlibKHR glxDrawable(@NativeType(value="GLXDrawable") long value) {
        XrGraphicsBindingOpenGLXlibKHR.nglxDrawable(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXlibKHR glxContext(@NativeType(value="GLXContext") long value) {
        XrGraphicsBindingOpenGLXlibKHR.nglxContext(this.address(), value);
        return this;
    }

    public XrGraphicsBindingOpenGLXlibKHR set(int type, long next, long xDisplay, int visualid, long glxFBConfig, long glxDrawable, long glxContext) {
        this.type(type);
        this.next(next);
        this.xDisplay(xDisplay);
        this.visualid(visualid);
        this.glxFBConfig(glxFBConfig);
        this.glxDrawable(glxDrawable);
        this.glxContext(glxContext);
        return this;
    }

    public XrGraphicsBindingOpenGLXlibKHR set(XrGraphicsBindingOpenGLXlibKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrGraphicsBindingOpenGLXlibKHR malloc() {
        return new XrGraphicsBindingOpenGLXlibKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrGraphicsBindingOpenGLXlibKHR calloc() {
        return new XrGraphicsBindingOpenGLXlibKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrGraphicsBindingOpenGLXlibKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrGraphicsBindingOpenGLXlibKHR(MemoryUtil.memAddress(container), container);
    }

    public static XrGraphicsBindingOpenGLXlibKHR create(long address) {
        return new XrGraphicsBindingOpenGLXlibKHR(address, null);
    }

    public static @Nullable XrGraphicsBindingOpenGLXlibKHR createSafe(long address) {
        return address == 0L ? null : new XrGraphicsBindingOpenGLXlibKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrGraphicsBindingOpenGLXlibKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsBindingOpenGLXlibKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrGraphicsBindingOpenGLXlibKHR malloc(MemoryStack stack) {
        return new XrGraphicsBindingOpenGLXlibKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrGraphicsBindingOpenGLXlibKHR calloc(MemoryStack stack) {
        return new XrGraphicsBindingOpenGLXlibKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nxDisplay(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)XDISPLAY);
    }

    public static int nvisualid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VISUALID);
    }

    public static long nglxFBConfig(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)GLXFBCONFIG);
    }

    public static long nglxDrawable(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)GLXDRAWABLE);
    }

    public static long nglxContext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)GLXCONTEXT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nxDisplay(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)XDISPLAY, Checks.check(value));
    }

    public static void nvisualid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VISUALID, value);
    }

    public static void nglxFBConfig(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)GLXFBCONFIG, Checks.check(value));
    }

    public static void nglxDrawable(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)GLXDRAWABLE, Checks.check(value));
    }

    public static void nglxContext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)GLXCONTEXT, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)XDISPLAY));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)GLXFBCONFIG));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)GLXDRAWABLE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)GLXCONTEXT));
    }

    static {
        Struct.Layout layout = XrGraphicsBindingOpenGLXlibKHR.__struct(XrGraphicsBindingOpenGLXlibKHR.__member(4), XrGraphicsBindingOpenGLXlibKHR.__member(POINTER_SIZE), XrGraphicsBindingOpenGLXlibKHR.__member(POINTER_SIZE), XrGraphicsBindingOpenGLXlibKHR.__member(4), XrGraphicsBindingOpenGLXlibKHR.__member(POINTER_SIZE), XrGraphicsBindingOpenGLXlibKHR.__member(POINTER_SIZE), XrGraphicsBindingOpenGLXlibKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        XDISPLAY = layout.offsetof(2);
        VISUALID = layout.offsetof(3);
        GLXFBCONFIG = layout.offsetof(4);
        GLXDRAWABLE = layout.offsetof(5);
        GLXCONTEXT = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrGraphicsBindingOpenGLXlibKHR, Buffer>
    implements NativeResource {
        private static final XrGraphicsBindingOpenGLXlibKHR ELEMENT_FACTORY = XrGraphicsBindingOpenGLXlibKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrGraphicsBindingOpenGLXlibKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGraphicsBindingOpenGLXlibKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGraphicsBindingOpenGLXlibKHR.nnext(this.address());
        }

        @NativeType(value="Display *")
        public long xDisplay() {
            return XrGraphicsBindingOpenGLXlibKHR.nxDisplay(this.address());
        }

        @NativeType(value="uint32_t")
        public int visualid() {
            return XrGraphicsBindingOpenGLXlibKHR.nvisualid(this.address());
        }

        @NativeType(value="GLXFBConfig")
        public long glxFBConfig() {
            return XrGraphicsBindingOpenGLXlibKHR.nglxFBConfig(this.address());
        }

        @NativeType(value="GLXDrawable")
        public long glxDrawable() {
            return XrGraphicsBindingOpenGLXlibKHR.nglxDrawable(this.address());
        }

        @NativeType(value="GLXContext")
        public long glxContext() {
            return XrGraphicsBindingOpenGLXlibKHR.nglxContext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsBindingOpenGLXlibKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000023001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGraphicsBindingOpenGLXlibKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer xDisplay(@NativeType(value="Display *") long value) {
            XrGraphicsBindingOpenGLXlibKHR.nxDisplay(this.address(), value);
            return this;
        }

        public Buffer visualid(@NativeType(value="uint32_t") int value) {
            XrGraphicsBindingOpenGLXlibKHR.nvisualid(this.address(), value);
            return this;
        }

        public Buffer glxFBConfig(@NativeType(value="GLXFBConfig") long value) {
            XrGraphicsBindingOpenGLXlibKHR.nglxFBConfig(this.address(), value);
            return this;
        }

        public Buffer glxDrawable(@NativeType(value="GLXDrawable") long value) {
            XrGraphicsBindingOpenGLXlibKHR.nglxDrawable(this.address(), value);
            return this;
        }

        public Buffer glxContext(@NativeType(value="GLXContext") long value) {
            XrGraphicsBindingOpenGLXlibKHR.nglxContext(this.address(), value);
            return this;
        }
    }
}

