/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandJointLocationEXT
extends Struct<XrHandJointLocationEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATIONFLAGS;
    public static final int POSE;
    public static final int RADIUS;

    protected XrHandJointLocationEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrHandJointLocationEXT create(long address, @Nullable ByteBuffer container) {
        return new XrHandJointLocationEXT(address, container);
    }

    public XrHandJointLocationEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandJointLocationEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpaceLocationFlags")
    public long locationFlags() {
        return XrHandJointLocationEXT.nlocationFlags(this.address());
    }

    public XrPosef pose() {
        return XrHandJointLocationEXT.npose(this.address());
    }

    public float radius() {
        return XrHandJointLocationEXT.nradius(this.address());
    }

    public XrHandJointLocationEXT locationFlags(@NativeType(value="XrSpaceLocationFlags") long value) {
        XrHandJointLocationEXT.nlocationFlags(this.address(), value);
        return this;
    }

    public XrHandJointLocationEXT pose(XrPosef value) {
        XrHandJointLocationEXT.npose(this.address(), value);
        return this;
    }

    public XrHandJointLocationEXT pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrHandJointLocationEXT radius(float value) {
        XrHandJointLocationEXT.nradius(this.address(), value);
        return this;
    }

    public XrHandJointLocationEXT set(long locationFlags, XrPosef pose, float radius) {
        this.locationFlags(locationFlags);
        this.pose(pose);
        this.radius(radius);
        return this;
    }

    public XrHandJointLocationEXT set(XrHandJointLocationEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandJointLocationEXT malloc() {
        return new XrHandJointLocationEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrHandJointLocationEXT calloc() {
        return new XrHandJointLocationEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrHandJointLocationEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrHandJointLocationEXT(MemoryUtil.memAddress(container), container);
    }

    public static XrHandJointLocationEXT create(long address) {
        return new XrHandJointLocationEXT(address, null);
    }

    public static @Nullable XrHandJointLocationEXT createSafe(long address) {
        return address == 0L ? null : new XrHandJointLocationEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrHandJointLocationEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandJointLocationEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandJointLocationEXT malloc(MemoryStack stack) {
        return new XrHandJointLocationEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandJointLocationEXT calloc(MemoryStack stack) {
        return new XrHandJointLocationEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nlocationFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LOCATIONFLAGS);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static float nradius(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)RADIUS);
    }

    public static void nlocationFlags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)LOCATIONFLAGS, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    public static void nradius(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)RADIUS, value);
    }

    static {
        Struct.Layout layout = XrHandJointLocationEXT.__struct(XrHandJointLocationEXT.__member(8), XrHandJointLocationEXT.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrHandJointLocationEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATIONFLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
        RADIUS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrHandJointLocationEXT, Buffer>
    implements NativeResource {
        private static final XrHandJointLocationEXT ELEMENT_FACTORY = XrHandJointLocationEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrHandJointLocationEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpaceLocationFlags")
        public long locationFlags() {
            return XrHandJointLocationEXT.nlocationFlags(this.address());
        }

        public XrPosef pose() {
            return XrHandJointLocationEXT.npose(this.address());
        }

        public float radius() {
            return XrHandJointLocationEXT.nradius(this.address());
        }

        public Buffer locationFlags(@NativeType(value="XrSpaceLocationFlags") long value) {
            XrHandJointLocationEXT.nlocationFlags(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrHandJointLocationEXT.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer radius(float value) {
            XrHandJointLocationEXT.nradius(this.address(), value);
            return this;
        }
    }
}

