/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHandCapsuleFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandTrackingCapsulesStateFB
extends Struct<XrHandTrackingCapsulesStateFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CAPSULES;

    protected XrHandTrackingCapsulesStateFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrHandTrackingCapsulesStateFB create(long address, @Nullable ByteBuffer container) {
        return new XrHandTrackingCapsulesStateFB(address, container);
    }

    public XrHandTrackingCapsulesStateFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandTrackingCapsulesStateFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandTrackingCapsulesStateFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrHandTrackingCapsulesStateFB.nnext(this.address());
    }

    @NativeType(value="XrHandCapsuleFB[XR_HAND_TRACKING_CAPSULE_COUNT_FB]")
    public XrHandCapsuleFB.Buffer capsules() {
        return XrHandTrackingCapsulesStateFB.ncapsules(this.address());
    }

    public XrHandCapsuleFB capsules(int index) {
        return XrHandTrackingCapsulesStateFB.ncapsules(this.address(), index);
    }

    public XrHandTrackingCapsulesStateFB type(@NativeType(value="XrStructureType") int value) {
        XrHandTrackingCapsulesStateFB.ntype(this.address(), value);
        return this;
    }

    public XrHandTrackingCapsulesStateFB type$Default() {
        return this.type(1000112000);
    }

    public XrHandTrackingCapsulesStateFB next(@NativeType(value="void *") long value) {
        XrHandTrackingCapsulesStateFB.nnext(this.address(), value);
        return this;
    }

    public XrHandTrackingCapsulesStateFB set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrHandTrackingCapsulesStateFB set(XrHandTrackingCapsulesStateFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandTrackingCapsulesStateFB malloc() {
        return new XrHandTrackingCapsulesStateFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrHandTrackingCapsulesStateFB calloc() {
        return new XrHandTrackingCapsulesStateFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrHandTrackingCapsulesStateFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrHandTrackingCapsulesStateFB(MemoryUtil.memAddress(container), container);
    }

    public static XrHandTrackingCapsulesStateFB create(long address) {
        return new XrHandTrackingCapsulesStateFB(address, null);
    }

    public static @Nullable XrHandTrackingCapsulesStateFB createSafe(long address) {
        return address == 0L ? null : new XrHandTrackingCapsulesStateFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrHandTrackingCapsulesStateFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandTrackingCapsulesStateFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandTrackingCapsulesStateFB malloc(MemoryStack stack) {
        return new XrHandTrackingCapsulesStateFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandTrackingCapsulesStateFB calloc(MemoryStack stack) {
        return new XrHandTrackingCapsulesStateFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static XrHandCapsuleFB.Buffer ncapsules(long struct) {
        return XrHandCapsuleFB.create(struct + (long)CAPSULES, 19);
    }

    public static XrHandCapsuleFB ncapsules(long struct, int index) {
        return XrHandCapsuleFB.create(struct + (long)CAPSULES + Checks.check(index, 19) * (long)XrHandCapsuleFB.SIZEOF);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrHandTrackingCapsulesStateFB.__struct(XrHandTrackingCapsulesStateFB.__member(4), XrHandTrackingCapsulesStateFB.__member(POINTER_SIZE), XrHandTrackingCapsulesStateFB.__array(XrHandCapsuleFB.SIZEOF, XrHandCapsuleFB.ALIGNOF, 19));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CAPSULES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrHandTrackingCapsulesStateFB, Buffer>
    implements NativeResource {
        private static final XrHandTrackingCapsulesStateFB ELEMENT_FACTORY = XrHandTrackingCapsulesStateFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrHandTrackingCapsulesStateFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandTrackingCapsulesStateFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrHandTrackingCapsulesStateFB.nnext(this.address());
        }

        @NativeType(value="XrHandCapsuleFB[XR_HAND_TRACKING_CAPSULE_COUNT_FB]")
        public XrHandCapsuleFB.Buffer capsules() {
            return XrHandTrackingCapsulesStateFB.ncapsules(this.address());
        }

        public XrHandCapsuleFB capsules(int index) {
            return XrHandTrackingCapsulesStateFB.ncapsules(this.address(), index);
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandTrackingCapsulesStateFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000112000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrHandTrackingCapsulesStateFB.nnext(this.address(), value);
            return this;
        }
    }
}

