/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.DispatchableHandle;
import org.lwjgl.openxr.XR;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XRCapabilities;
import org.lwjgl.openxr.XrApplicationInfo;
import org.lwjgl.openxr.XrInstanceCreateInfo;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class XrInstance
extends DispatchableHandle {
    public XrInstance(long handle, XrInstanceCreateInfo ci) {
        super(handle, XrInstance.getInstanceCapabilities(handle, ci));
    }

    private static XRCapabilities getInstanceCapabilities(long handle, XrInstanceCreateInfo ci) {
        XrApplicationInfo appInfo = ci.applicationInfo();
        long apiVersion = appInfo.apiVersion() != 0L ? appInfo.apiVersion() : XR10.XR_MAKE_VERSION(1, 0, 0);
        return new XRCapabilities(functionName -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer pp = stack.mallocPointer(1);
                int result = JNI.callPPPI(handle, MemoryUtil.memAddress(functionName), pp.address(), XR.getGlobalCommands().xrGetInstanceProcAddr);
                if (result != 0 && Checks.DEBUG_FUNCTIONS) {
                    APIUtil.apiLogMissing("XR", functionName);
                }
                long l = pp.get(0);
                return l;
            }
        }, apiVersion, XR.getEnabledExtensionSet(apiVersion, ci.enabledExtensionNames()));
    }
}

