/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrApplicationInfo;
import org.lwjgl.openxr.XrDebugUtilsMessengerCreateInfoEXT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInstanceCreateInfo
extends Struct<XrInstanceCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CREATEFLAGS;
    public static final int APPLICATIONINFO;
    public static final int ENABLEDAPILAYERCOUNT;
    public static final int ENABLEDAPILAYERNAMES;
    public static final int ENABLEDEXTENSIONCOUNT;
    public static final int ENABLEDEXTENSIONNAMES;

    protected XrInstanceCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrInstanceCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new XrInstanceCreateInfo(address, container);
    }

    public XrInstanceCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrInstanceCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInstanceCreateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrInstanceCreateInfo.nnext(this.address());
    }

    @NativeType(value="XrInstanceCreateFlags")
    public long createFlags() {
        return XrInstanceCreateInfo.ncreateFlags(this.address());
    }

    public XrApplicationInfo applicationInfo() {
        return XrInstanceCreateInfo.napplicationInfo(this.address());
    }

    @NativeType(value="uint32_t")
    public int enabledApiLayerCount() {
        return XrInstanceCreateInfo.nenabledApiLayerCount(this.address());
    }

    @NativeType(value="char const * const *")
    public @Nullable PointerBuffer enabledApiLayerNames() {
        return XrInstanceCreateInfo.nenabledApiLayerNames(this.address());
    }

    @NativeType(value="uint32_t")
    public int enabledExtensionCount() {
        return XrInstanceCreateInfo.nenabledExtensionCount(this.address());
    }

    @NativeType(value="char const * const *")
    public @Nullable PointerBuffer enabledExtensionNames() {
        return XrInstanceCreateInfo.nenabledExtensionNames(this.address());
    }

    public XrInstanceCreateInfo type(@NativeType(value="XrStructureType") int value) {
        XrInstanceCreateInfo.ntype(this.address(), value);
        return this;
    }

    public XrInstanceCreateInfo type$Default() {
        return this.type(3);
    }

    public XrInstanceCreateInfo next(@NativeType(value="void const *") long value) {
        XrInstanceCreateInfo.nnext(this.address(), value);
        return this;
    }

    public XrInstanceCreateInfo next(XrDebugUtilsMessengerCreateInfoEXT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrInstanceCreateInfo createFlags(@NativeType(value="XrInstanceCreateFlags") long value) {
        XrInstanceCreateInfo.ncreateFlags(this.address(), value);
        return this;
    }

    public XrInstanceCreateInfo applicationInfo(XrApplicationInfo value) {
        XrInstanceCreateInfo.napplicationInfo(this.address(), value);
        return this;
    }

    public XrInstanceCreateInfo applicationInfo(Consumer<XrApplicationInfo> consumer) {
        consumer.accept(this.applicationInfo());
        return this;
    }

    public XrInstanceCreateInfo enabledApiLayerNames(@NativeType(value="char const * const *") @Nullable PointerBuffer value) {
        XrInstanceCreateInfo.nenabledApiLayerNames(this.address(), value);
        return this;
    }

    public XrInstanceCreateInfo enabledExtensionNames(@NativeType(value="char const * const *") @Nullable PointerBuffer value) {
        XrInstanceCreateInfo.nenabledExtensionNames(this.address(), value);
        return this;
    }

    public XrInstanceCreateInfo set(int type, long next, long createFlags, XrApplicationInfo applicationInfo, @Nullable PointerBuffer enabledApiLayerNames, @Nullable PointerBuffer enabledExtensionNames) {
        this.type(type);
        this.next(next);
        this.createFlags(createFlags);
        this.applicationInfo(applicationInfo);
        this.enabledApiLayerNames(enabledApiLayerNames);
        this.enabledExtensionNames(enabledExtensionNames);
        return this;
    }

    public XrInstanceCreateInfo set(XrInstanceCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrInstanceCreateInfo malloc() {
        return new XrInstanceCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrInstanceCreateInfo calloc() {
        return new XrInstanceCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrInstanceCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrInstanceCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static XrInstanceCreateInfo create(long address) {
        return new XrInstanceCreateInfo(address, null);
    }

    public static @Nullable XrInstanceCreateInfo createSafe(long address) {
        return address == 0L ? null : new XrInstanceCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrInstanceCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInstanceCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrInstanceCreateInfo malloc(MemoryStack stack) {
        return new XrInstanceCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrInstanceCreateInfo calloc(MemoryStack stack) {
        return new XrInstanceCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long ncreateFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CREATEFLAGS);
    }

    public static XrApplicationInfo napplicationInfo(long struct) {
        return XrApplicationInfo.create(struct + (long)APPLICATIONINFO);
    }

    public static int nenabledApiLayerCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ENABLEDAPILAYERCOUNT);
    }

    public static @Nullable PointerBuffer nenabledApiLayerNames(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)ENABLEDAPILAYERNAMES), XrInstanceCreateInfo.nenabledApiLayerCount(struct));
    }

    public static int nenabledExtensionCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ENABLEDEXTENSIONCOUNT);
    }

    public static @Nullable PointerBuffer nenabledExtensionNames(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)ENABLEDEXTENSIONNAMES), XrInstanceCreateInfo.nenabledExtensionCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ncreateFlags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)CREATEFLAGS, value);
    }

    public static void napplicationInfo(long struct, XrApplicationInfo value) {
        MemoryUtil.memCopy(value.address(), struct + (long)APPLICATIONINFO, XrApplicationInfo.SIZEOF);
    }

    public static void nenabledApiLayerCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ENABLEDAPILAYERCOUNT, value);
    }

    public static void nenabledApiLayerNames(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)ENABLEDAPILAYERNAMES, MemoryUtil.memAddressSafe(value));
        XrInstanceCreateInfo.nenabledApiLayerCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nenabledExtensionCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ENABLEDEXTENSIONCOUNT, value);
    }

    public static void nenabledExtensionNames(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)ENABLEDEXTENSIONNAMES, MemoryUtil.memAddressSafe(value));
        XrInstanceCreateInfo.nenabledExtensionCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (XrInstanceCreateInfo.nenabledApiLayerCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)ENABLEDAPILAYERNAMES));
        }
        if (XrInstanceCreateInfo.nenabledExtensionCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)ENABLEDEXTENSIONNAMES));
        }
    }

    static {
        Struct.Layout layout = XrInstanceCreateInfo.__struct(XrInstanceCreateInfo.__member(4), XrInstanceCreateInfo.__member(POINTER_SIZE), XrInstanceCreateInfo.__member(8), XrInstanceCreateInfo.__member(XrApplicationInfo.SIZEOF, XrApplicationInfo.ALIGNOF), XrInstanceCreateInfo.__member(4), XrInstanceCreateInfo.__member(POINTER_SIZE), XrInstanceCreateInfo.__member(4), XrInstanceCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CREATEFLAGS = layout.offsetof(2);
        APPLICATIONINFO = layout.offsetof(3);
        ENABLEDAPILAYERCOUNT = layout.offsetof(4);
        ENABLEDAPILAYERNAMES = layout.offsetof(5);
        ENABLEDEXTENSIONCOUNT = layout.offsetof(6);
        ENABLEDEXTENSIONNAMES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrInstanceCreateInfo, Buffer>
    implements NativeResource {
        private static final XrInstanceCreateInfo ELEMENT_FACTORY = XrInstanceCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrInstanceCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInstanceCreateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrInstanceCreateInfo.nnext(this.address());
        }

        @NativeType(value="XrInstanceCreateFlags")
        public long createFlags() {
            return XrInstanceCreateInfo.ncreateFlags(this.address());
        }

        public XrApplicationInfo applicationInfo() {
            return XrInstanceCreateInfo.napplicationInfo(this.address());
        }

        @NativeType(value="uint32_t")
        public int enabledApiLayerCount() {
            return XrInstanceCreateInfo.nenabledApiLayerCount(this.address());
        }

        @NativeType(value="char const * const *")
        public @Nullable PointerBuffer enabledApiLayerNames() {
            return XrInstanceCreateInfo.nenabledApiLayerNames(this.address());
        }

        @NativeType(value="uint32_t")
        public int enabledExtensionCount() {
            return XrInstanceCreateInfo.nenabledExtensionCount(this.address());
        }

        @NativeType(value="char const * const *")
        public @Nullable PointerBuffer enabledExtensionNames() {
            return XrInstanceCreateInfo.nenabledExtensionNames(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInstanceCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(3);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrInstanceCreateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrDebugUtilsMessengerCreateInfoEXT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer createFlags(@NativeType(value="XrInstanceCreateFlags") long value) {
            XrInstanceCreateInfo.ncreateFlags(this.address(), value);
            return this;
        }

        public Buffer applicationInfo(XrApplicationInfo value) {
            XrInstanceCreateInfo.napplicationInfo(this.address(), value);
            return this;
        }

        public Buffer applicationInfo(Consumer<XrApplicationInfo> consumer) {
            consumer.accept(this.applicationInfo());
            return this;
        }

        public Buffer enabledApiLayerNames(@NativeType(value="char const * const *") @Nullable PointerBuffer value) {
            XrInstanceCreateInfo.nenabledApiLayerNames(this.address(), value);
            return this;
        }

        public Buffer enabledExtensionNames(@NativeType(value="char const * const *") @Nullable PointerBuffer value) {
            XrInstanceCreateInfo.nenabledExtensionNames(this.address(), value);
            return this;
        }
    }
}

