/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrActionSet;
import org.lwjgl.openxr.XrBindingModificationBaseHeaderKHR;
import org.lwjgl.openxr.XrHapticBaseHeader;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInteractionProfileDpadBindingEXT
extends Struct<XrInteractionProfileDpadBindingEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BINDING;
    public static final int ACTIONSET;
    public static final int FORCETHRESHOLD;
    public static final int FORCETHRESHOLDRELEASED;
    public static final int CENTERREGION;
    public static final int WEDGEANGLE;
    public static final int ISSTICKY;
    public static final int ONHAPTIC;
    public static final int OFFHAPTIC;

    protected XrInteractionProfileDpadBindingEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrInteractionProfileDpadBindingEXT create(long address, @Nullable ByteBuffer container) {
        return new XrInteractionProfileDpadBindingEXT(address, container);
    }

    public XrInteractionProfileDpadBindingEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrInteractionProfileDpadBindingEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInteractionProfileDpadBindingEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrInteractionProfileDpadBindingEXT.nnext(this.address());
    }

    @NativeType(value="XrPath")
    public long binding() {
        return XrInteractionProfileDpadBindingEXT.nbinding(this.address());
    }

    @NativeType(value="XrActionSet")
    public long actionSet() {
        return XrInteractionProfileDpadBindingEXT.nactionSet(this.address());
    }

    public float forceThreshold() {
        return XrInteractionProfileDpadBindingEXT.nforceThreshold(this.address());
    }

    public float forceThresholdReleased() {
        return XrInteractionProfileDpadBindingEXT.nforceThresholdReleased(this.address());
    }

    public float centerRegion() {
        return XrInteractionProfileDpadBindingEXT.ncenterRegion(this.address());
    }

    public float wedgeAngle() {
        return XrInteractionProfileDpadBindingEXT.nwedgeAngle(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isSticky() {
        return XrInteractionProfileDpadBindingEXT.nisSticky(this.address()) != 0;
    }

    @NativeType(value="XrHapticBaseHeader const *")
    public @Nullable XrHapticBaseHeader onHaptic() {
        return XrInteractionProfileDpadBindingEXT.nonHaptic(this.address());
    }

    @NativeType(value="XrHapticBaseHeader const *")
    public @Nullable XrHapticBaseHeader offHaptic() {
        return XrInteractionProfileDpadBindingEXT.noffHaptic(this.address());
    }

    public XrInteractionProfileDpadBindingEXT type(@NativeType(value="XrStructureType") int value) {
        XrInteractionProfileDpadBindingEXT.ntype(this.address(), value);
        return this;
    }

    public XrInteractionProfileDpadBindingEXT type$Default() {
        return this.type(1000078000);
    }

    public XrInteractionProfileDpadBindingEXT next(@NativeType(value="void const *") long value) {
        XrInteractionProfileDpadBindingEXT.nnext(this.address(), value);
        return this;
    }

    public XrInteractionProfileDpadBindingEXT binding(@NativeType(value="XrPath") long value) {
        XrInteractionProfileDpadBindingEXT.nbinding(this.address(), value);
        return this;
    }

    public XrInteractionProfileDpadBindingEXT actionSet(XrActionSet value) {
        XrInteractionProfileDpadBindingEXT.nactionSet(this.address(), value);
        return this;
    }

    public XrInteractionProfileDpadBindingEXT forceThreshold(float value) {
        XrInteractionProfileDpadBindingEXT.nforceThreshold(this.address(), value);
        return this;
    }

    public XrInteractionProfileDpadBindingEXT forceThresholdReleased(float value) {
        XrInteractionProfileDpadBindingEXT.nforceThresholdReleased(this.address(), value);
        return this;
    }

    public XrInteractionProfileDpadBindingEXT centerRegion(float value) {
        XrInteractionProfileDpadBindingEXT.ncenterRegion(this.address(), value);
        return this;
    }

    public XrInteractionProfileDpadBindingEXT wedgeAngle(float value) {
        XrInteractionProfileDpadBindingEXT.nwedgeAngle(this.address(), value);
        return this;
    }

    public XrInteractionProfileDpadBindingEXT isSticky(@NativeType(value="XrBool32") boolean value) {
        XrInteractionProfileDpadBindingEXT.nisSticky(this.address(), value ? 1 : 0);
        return this;
    }

    public XrInteractionProfileDpadBindingEXT onHaptic(@NativeType(value="XrHapticBaseHeader const *") @Nullable XrHapticBaseHeader value) {
        XrInteractionProfileDpadBindingEXT.nonHaptic(this.address(), value);
        return this;
    }

    public XrInteractionProfileDpadBindingEXT offHaptic(@NativeType(value="XrHapticBaseHeader const *") @Nullable XrHapticBaseHeader value) {
        XrInteractionProfileDpadBindingEXT.noffHaptic(this.address(), value);
        return this;
    }

    public XrInteractionProfileDpadBindingEXT set(int type, long next, long binding, XrActionSet actionSet, float forceThreshold, float forceThresholdReleased, float centerRegion, float wedgeAngle, boolean isSticky, @Nullable XrHapticBaseHeader onHaptic, @Nullable XrHapticBaseHeader offHaptic) {
        this.type(type);
        this.next(next);
        this.binding(binding);
        this.actionSet(actionSet);
        this.forceThreshold(forceThreshold);
        this.forceThresholdReleased(forceThresholdReleased);
        this.centerRegion(centerRegion);
        this.wedgeAngle(wedgeAngle);
        this.isSticky(isSticky);
        this.onHaptic(onHaptic);
        this.offHaptic(offHaptic);
        return this;
    }

    public XrInteractionProfileDpadBindingEXT set(XrInteractionProfileDpadBindingEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrInteractionProfileDpadBindingEXT malloc() {
        return new XrInteractionProfileDpadBindingEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrInteractionProfileDpadBindingEXT calloc() {
        return new XrInteractionProfileDpadBindingEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrInteractionProfileDpadBindingEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrInteractionProfileDpadBindingEXT(MemoryUtil.memAddress(container), container);
    }

    public static XrInteractionProfileDpadBindingEXT create(long address) {
        return new XrInteractionProfileDpadBindingEXT(address, null);
    }

    public static @Nullable XrInteractionProfileDpadBindingEXT createSafe(long address) {
        return address == 0L ? null : new XrInteractionProfileDpadBindingEXT(address, null);
    }

    public static XrInteractionProfileDpadBindingEXT create(XrBindingModificationBaseHeaderKHR value) {
        return new XrInteractionProfileDpadBindingEXT(value.address(), XrInteractionProfileDpadBindingEXT.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrInteractionProfileDpadBindingEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInteractionProfileDpadBindingEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrBindingModificationBaseHeaderKHR.Buffer value) {
        return new Buffer(value.address(), XrInteractionProfileDpadBindingEXT.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrInteractionProfileDpadBindingEXT malloc(MemoryStack stack) {
        return new XrInteractionProfileDpadBindingEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrInteractionProfileDpadBindingEXT calloc(MemoryStack stack) {
        return new XrInteractionProfileDpadBindingEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nbinding(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BINDING);
    }

    public static long nactionSet(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ACTIONSET);
    }

    public static float nforceThreshold(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FORCETHRESHOLD);
    }

    public static float nforceThresholdReleased(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FORCETHRESHOLDRELEASED);
    }

    public static float ncenterRegion(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CENTERREGION);
    }

    public static float nwedgeAngle(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)WEDGEANGLE);
    }

    public static int nisSticky(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISSTICKY);
    }

    public static @Nullable XrHapticBaseHeader nonHaptic(long struct) {
        return XrHapticBaseHeader.createSafe(MemoryUtil.memGetAddress(struct + (long)ONHAPTIC));
    }

    public static @Nullable XrHapticBaseHeader noffHaptic(long struct) {
        return XrHapticBaseHeader.createSafe(MemoryUtil.memGetAddress(struct + (long)OFFHAPTIC));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbinding(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BINDING, value);
    }

    public static void nactionSet(long struct, XrActionSet value) {
        MemoryUtil.memPutAddress(struct + (long)ACTIONSET, value.address());
    }

    public static void nforceThreshold(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FORCETHRESHOLD, value);
    }

    public static void nforceThresholdReleased(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FORCETHRESHOLDRELEASED, value);
    }

    public static void ncenterRegion(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)CENTERREGION, value);
    }

    public static void nwedgeAngle(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)WEDGEANGLE, value);
    }

    public static void nisSticky(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ISSTICKY, value);
    }

    public static void nonHaptic(long struct, @Nullable XrHapticBaseHeader value) {
        MemoryUtil.memPutAddress(struct + (long)ONHAPTIC, MemoryUtil.memAddressSafe(value));
    }

    public static void noffHaptic(long struct, @Nullable XrHapticBaseHeader value) {
        MemoryUtil.memPutAddress(struct + (long)OFFHAPTIC, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ACTIONSET));
    }

    static {
        Struct.Layout layout = XrInteractionProfileDpadBindingEXT.__struct(XrInteractionProfileDpadBindingEXT.__member(4), XrInteractionProfileDpadBindingEXT.__member(POINTER_SIZE), XrInteractionProfileDpadBindingEXT.__member(8), XrInteractionProfileDpadBindingEXT.__member(POINTER_SIZE), XrInteractionProfileDpadBindingEXT.__member(4), XrInteractionProfileDpadBindingEXT.__member(4), XrInteractionProfileDpadBindingEXT.__member(4), XrInteractionProfileDpadBindingEXT.__member(4), XrInteractionProfileDpadBindingEXT.__member(4), XrInteractionProfileDpadBindingEXT.__member(POINTER_SIZE), XrInteractionProfileDpadBindingEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BINDING = layout.offsetof(2);
        ACTIONSET = layout.offsetof(3);
        FORCETHRESHOLD = layout.offsetof(4);
        FORCETHRESHOLDRELEASED = layout.offsetof(5);
        CENTERREGION = layout.offsetof(6);
        WEDGEANGLE = layout.offsetof(7);
        ISSTICKY = layout.offsetof(8);
        ONHAPTIC = layout.offsetof(9);
        OFFHAPTIC = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<XrInteractionProfileDpadBindingEXT, Buffer>
    implements NativeResource {
        private static final XrInteractionProfileDpadBindingEXT ELEMENT_FACTORY = XrInteractionProfileDpadBindingEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrInteractionProfileDpadBindingEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInteractionProfileDpadBindingEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrInteractionProfileDpadBindingEXT.nnext(this.address());
        }

        @NativeType(value="XrPath")
        public long binding() {
            return XrInteractionProfileDpadBindingEXT.nbinding(this.address());
        }

        @NativeType(value="XrActionSet")
        public long actionSet() {
            return XrInteractionProfileDpadBindingEXT.nactionSet(this.address());
        }

        public float forceThreshold() {
            return XrInteractionProfileDpadBindingEXT.nforceThreshold(this.address());
        }

        public float forceThresholdReleased() {
            return XrInteractionProfileDpadBindingEXT.nforceThresholdReleased(this.address());
        }

        public float centerRegion() {
            return XrInteractionProfileDpadBindingEXT.ncenterRegion(this.address());
        }

        public float wedgeAngle() {
            return XrInteractionProfileDpadBindingEXT.nwedgeAngle(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isSticky() {
            return XrInteractionProfileDpadBindingEXT.nisSticky(this.address()) != 0;
        }

        @NativeType(value="XrHapticBaseHeader const *")
        public @Nullable XrHapticBaseHeader onHaptic() {
            return XrInteractionProfileDpadBindingEXT.nonHaptic(this.address());
        }

        @NativeType(value="XrHapticBaseHeader const *")
        public @Nullable XrHapticBaseHeader offHaptic() {
            return XrInteractionProfileDpadBindingEXT.noffHaptic(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInteractionProfileDpadBindingEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000078000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrInteractionProfileDpadBindingEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="XrPath") long value) {
            XrInteractionProfileDpadBindingEXT.nbinding(this.address(), value);
            return this;
        }

        public Buffer actionSet(XrActionSet value) {
            XrInteractionProfileDpadBindingEXT.nactionSet(this.address(), value);
            return this;
        }

        public Buffer forceThreshold(float value) {
            XrInteractionProfileDpadBindingEXT.nforceThreshold(this.address(), value);
            return this;
        }

        public Buffer forceThresholdReleased(float value) {
            XrInteractionProfileDpadBindingEXT.nforceThresholdReleased(this.address(), value);
            return this;
        }

        public Buffer centerRegion(float value) {
            XrInteractionProfileDpadBindingEXT.ncenterRegion(this.address(), value);
            return this;
        }

        public Buffer wedgeAngle(float value) {
            XrInteractionProfileDpadBindingEXT.nwedgeAngle(this.address(), value);
            return this;
        }

        public Buffer isSticky(@NativeType(value="XrBool32") boolean value) {
            XrInteractionProfileDpadBindingEXT.nisSticky(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer onHaptic(@NativeType(value="XrHapticBaseHeader const *") @Nullable XrHapticBaseHeader value) {
            XrInteractionProfileDpadBindingEXT.nonHaptic(this.address(), value);
            return this;
        }

        public Buffer offHaptic(@NativeType(value="XrHapticBaseHeader const *") @Nullable XrHapticBaseHeader value) {
            XrInteractionProfileDpadBindingEXT.noffHaptic(this.address(), value);
            return this;
        }
    }
}

