/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInteractionProfileState
extends Struct<XrInteractionProfileState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int INTERACTIONPROFILE;

    protected XrInteractionProfileState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrInteractionProfileState create(long address, @Nullable ByteBuffer container) {
        return new XrInteractionProfileState(address, container);
    }

    public XrInteractionProfileState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrInteractionProfileState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInteractionProfileState.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrInteractionProfileState.nnext(this.address());
    }

    @NativeType(value="XrPath")
    public long interactionProfile() {
        return XrInteractionProfileState.ninteractionProfile(this.address());
    }

    public XrInteractionProfileState type(@NativeType(value="XrStructureType") int value) {
        XrInteractionProfileState.ntype(this.address(), value);
        return this;
    }

    public XrInteractionProfileState type$Default() {
        return this.type(53);
    }

    public XrInteractionProfileState next(@NativeType(value="void *") long value) {
        XrInteractionProfileState.nnext(this.address(), value);
        return this;
    }

    public XrInteractionProfileState interactionProfile(@NativeType(value="XrPath") long value) {
        XrInteractionProfileState.ninteractionProfile(this.address(), value);
        return this;
    }

    public XrInteractionProfileState set(int type, long next, long interactionProfile) {
        this.type(type);
        this.next(next);
        this.interactionProfile(interactionProfile);
        return this;
    }

    public XrInteractionProfileState set(XrInteractionProfileState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrInteractionProfileState malloc() {
        return new XrInteractionProfileState(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrInteractionProfileState calloc() {
        return new XrInteractionProfileState(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrInteractionProfileState create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrInteractionProfileState(MemoryUtil.memAddress(container), container);
    }

    public static XrInteractionProfileState create(long address) {
        return new XrInteractionProfileState(address, null);
    }

    public static @Nullable XrInteractionProfileState createSafe(long address) {
        return address == 0L ? null : new XrInteractionProfileState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrInteractionProfileState.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInteractionProfileState.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrInteractionProfileState malloc(MemoryStack stack) {
        return new XrInteractionProfileState(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrInteractionProfileState calloc(MemoryStack stack) {
        return new XrInteractionProfileState(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long ninteractionProfile(long struct) {
        return MemoryUtil.memGetLong(struct + (long)INTERACTIONPROFILE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ninteractionProfile(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)INTERACTIONPROFILE, value);
    }

    static {
        Struct.Layout layout = XrInteractionProfileState.__struct(XrInteractionProfileState.__member(4), XrInteractionProfileState.__member(POINTER_SIZE), XrInteractionProfileState.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        INTERACTIONPROFILE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrInteractionProfileState, Buffer>
    implements NativeResource {
        private static final XrInteractionProfileState ELEMENT_FACTORY = XrInteractionProfileState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrInteractionProfileState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInteractionProfileState.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrInteractionProfileState.nnext(this.address());
        }

        @NativeType(value="XrPath")
        public long interactionProfile() {
            return XrInteractionProfileState.ninteractionProfile(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInteractionProfileState.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(53);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrInteractionProfileState.nnext(this.address(), value);
            return this;
        }

        public Buffer interactionProfile(@NativeType(value="XrPath") long value) {
            XrInteractionProfileState.ninteractionProfile(this.address(), value);
            return this;
        }
    }
}

