/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrKeyboardTrackingDescriptionFB
extends Struct<XrKeyboardTrackingDescriptionFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRACKEDKEYBOARDID;
    public static final int SIZE;
    public static final int FLAGS;
    public static final int NAME;

    protected XrKeyboardTrackingDescriptionFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrKeyboardTrackingDescriptionFB create(long address, @Nullable ByteBuffer container) {
        return new XrKeyboardTrackingDescriptionFB(address, container);
    }

    public XrKeyboardTrackingDescriptionFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrKeyboardTrackingDescriptionFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint64_t")
    public long trackedKeyboardId() {
        return XrKeyboardTrackingDescriptionFB.ntrackedKeyboardId(this.address());
    }

    public XrVector3f size() {
        return XrKeyboardTrackingDescriptionFB.nsize(this.address());
    }

    @NativeType(value="XrKeyboardTrackingFlagsFB")
    public long flags() {
        return XrKeyboardTrackingDescriptionFB.nflags(this.address());
    }

    @NativeType(value="char[XR_MAX_KEYBOARD_TRACKING_NAME_SIZE_FB]")
    public ByteBuffer name() {
        return XrKeyboardTrackingDescriptionFB.nname(this.address());
    }

    @NativeType(value="char[XR_MAX_KEYBOARD_TRACKING_NAME_SIZE_FB]")
    public String nameString() {
        return XrKeyboardTrackingDescriptionFB.nnameString(this.address());
    }

    public static XrKeyboardTrackingDescriptionFB malloc() {
        return new XrKeyboardTrackingDescriptionFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrKeyboardTrackingDescriptionFB calloc() {
        return new XrKeyboardTrackingDescriptionFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrKeyboardTrackingDescriptionFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrKeyboardTrackingDescriptionFB(MemoryUtil.memAddress(container), container);
    }

    public static XrKeyboardTrackingDescriptionFB create(long address) {
        return new XrKeyboardTrackingDescriptionFB(address, null);
    }

    public static @Nullable XrKeyboardTrackingDescriptionFB createSafe(long address) {
        return address == 0L ? null : new XrKeyboardTrackingDescriptionFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrKeyboardTrackingDescriptionFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrKeyboardTrackingDescriptionFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrKeyboardTrackingDescriptionFB malloc(MemoryStack stack) {
        return new XrKeyboardTrackingDescriptionFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrKeyboardTrackingDescriptionFB calloc(MemoryStack stack) {
        return new XrKeyboardTrackingDescriptionFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntrackedKeyboardId(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TRACKEDKEYBOARDID);
    }

    public static XrVector3f nsize(long struct) {
        return XrVector3f.create(struct + (long)SIZE);
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FLAGS);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 128);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)NAME);
    }

    static {
        Struct.Layout layout = XrKeyboardTrackingDescriptionFB.__struct(XrKeyboardTrackingDescriptionFB.__member(8), XrKeyboardTrackingDescriptionFB.__member(XrVector3f.SIZEOF, XrVector3f.ALIGNOF), XrKeyboardTrackingDescriptionFB.__member(8), XrKeyboardTrackingDescriptionFB.__array(1, 128));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRACKEDKEYBOARDID = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        NAME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrKeyboardTrackingDescriptionFB, Buffer>
    implements NativeResource {
        private static final XrKeyboardTrackingDescriptionFB ELEMENT_FACTORY = XrKeyboardTrackingDescriptionFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrKeyboardTrackingDescriptionFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint64_t")
        public long trackedKeyboardId() {
            return XrKeyboardTrackingDescriptionFB.ntrackedKeyboardId(this.address());
        }

        public XrVector3f size() {
            return XrKeyboardTrackingDescriptionFB.nsize(this.address());
        }

        @NativeType(value="XrKeyboardTrackingFlagsFB")
        public long flags() {
            return XrKeyboardTrackingDescriptionFB.nflags(this.address());
        }

        @NativeType(value="char[XR_MAX_KEYBOARD_TRACKING_NAME_SIZE_FB]")
        public ByteBuffer name() {
            return XrKeyboardTrackingDescriptionFB.nname(this.address());
        }

        @NativeType(value="char[XR_MAX_KEYBOARD_TRACKING_NAME_SIZE_FB]")
        public String nameString() {
            return XrKeyboardTrackingDescriptionFB.nnameString(this.address());
        }
    }
}

