/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrUuidEXT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrLocalizationMapML
extends Struct<XrLocalizationMapML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int NAME;
    public static final int MAPUUID;
    public static final int MAPTYPE;

    protected XrLocalizationMapML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrLocalizationMapML create(long address, @Nullable ByteBuffer container) {
        return new XrLocalizationMapML(address, container);
    }

    public XrLocalizationMapML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrLocalizationMapML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrLocalizationMapML.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrLocalizationMapML.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML]")
    public ByteBuffer name() {
        return XrLocalizationMapML.nname(this.address());
    }

    @NativeType(value="char[XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML]")
    public String nameString() {
        return XrLocalizationMapML.nnameString(this.address());
    }

    public XrUuidEXT mapUuid() {
        return XrLocalizationMapML.nmapUuid(this.address());
    }

    @NativeType(value="XrLocalizationMapTypeML")
    public int mapType() {
        return XrLocalizationMapML.nmapType(this.address());
    }

    public XrLocalizationMapML type(@NativeType(value="XrStructureType") int value) {
        XrLocalizationMapML.ntype(this.address(), value);
        return this;
    }

    public XrLocalizationMapML type$Default() {
        return this.type(1000139000);
    }

    public XrLocalizationMapML next(@NativeType(value="void *") long value) {
        XrLocalizationMapML.nnext(this.address(), value);
        return this;
    }

    public XrLocalizationMapML name(@NativeType(value="char[XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML]") ByteBuffer value) {
        XrLocalizationMapML.nname(this.address(), value);
        return this;
    }

    public XrLocalizationMapML mapUuid(XrUuidEXT value) {
        XrLocalizationMapML.nmapUuid(this.address(), value);
        return this;
    }

    public XrLocalizationMapML mapUuid(Consumer<XrUuidEXT> consumer) {
        consumer.accept(this.mapUuid());
        return this;
    }

    public XrLocalizationMapML mapType(@NativeType(value="XrLocalizationMapTypeML") int value) {
        XrLocalizationMapML.nmapType(this.address(), value);
        return this;
    }

    public XrLocalizationMapML set(int type, long next, ByteBuffer name, XrUuidEXT mapUuid, int mapType) {
        this.type(type);
        this.next(next);
        this.name(name);
        this.mapUuid(mapUuid);
        this.mapType(mapType);
        return this;
    }

    public XrLocalizationMapML set(XrLocalizationMapML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrLocalizationMapML malloc() {
        return new XrLocalizationMapML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrLocalizationMapML calloc() {
        return new XrLocalizationMapML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrLocalizationMapML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrLocalizationMapML(MemoryUtil.memAddress(container), container);
    }

    public static XrLocalizationMapML create(long address) {
        return new XrLocalizationMapML(address, null);
    }

    public static @Nullable XrLocalizationMapML createSafe(long address) {
        return address == 0L ? null : new XrLocalizationMapML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrLocalizationMapML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrLocalizationMapML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrLocalizationMapML malloc(MemoryStack stack) {
        return new XrLocalizationMapML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrLocalizationMapML calloc(MemoryStack stack) {
        return new XrLocalizationMapML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 64);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)NAME);
    }

    public static XrUuidEXT nmapUuid(long struct) {
        return XrUuidEXT.create(struct + (long)MAPUUID);
    }

    public static int nmapType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAPTYPE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)NAME, value.remaining());
    }

    public static void nmapUuid(long struct, XrUuidEXT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MAPUUID, XrUuidEXT.SIZEOF);
    }

    public static void nmapType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAPTYPE, value);
    }

    static {
        Struct.Layout layout = XrLocalizationMapML.__struct(XrLocalizationMapML.__member(4), XrLocalizationMapML.__member(POINTER_SIZE), XrLocalizationMapML.__array(1, 64), XrLocalizationMapML.__member(XrUuidEXT.SIZEOF, XrUuidEXT.ALIGNOF), XrLocalizationMapML.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        NAME = layout.offsetof(2);
        MAPUUID = layout.offsetof(3);
        MAPTYPE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrLocalizationMapML, Buffer>
    implements NativeResource {
        private static final XrLocalizationMapML ELEMENT_FACTORY = XrLocalizationMapML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrLocalizationMapML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrLocalizationMapML.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrLocalizationMapML.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML]")
        public ByteBuffer name() {
            return XrLocalizationMapML.nname(this.address());
        }

        @NativeType(value="char[XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML]")
        public String nameString() {
            return XrLocalizationMapML.nnameString(this.address());
        }

        public XrUuidEXT mapUuid() {
            return XrLocalizationMapML.nmapUuid(this.address());
        }

        @NativeType(value="XrLocalizationMapTypeML")
        public int mapType() {
            return XrLocalizationMapML.nmapType(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrLocalizationMapML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000139000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrLocalizationMapML.nnext(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="char[XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML]") ByteBuffer value) {
            XrLocalizationMapML.nname(this.address(), value);
            return this;
        }

        public Buffer mapUuid(XrUuidEXT value) {
            XrLocalizationMapML.nmapUuid(this.address(), value);
            return this;
        }

        public Buffer mapUuid(Consumer<XrUuidEXT> consumer) {
            consumer.accept(this.mapUuid());
            return this;
        }

        public Buffer mapType(@NativeType(value="XrLocalizationMapTypeML") int value) {
            XrLocalizationMapML.nmapType(this.address(), value);
            return this;
        }
    }
}

