/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerDetectorAprilTagInfoML
extends Struct<XrMarkerDetectorAprilTagInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int APRILTAGDICT;

    protected XrMarkerDetectorAprilTagInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrMarkerDetectorAprilTagInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrMarkerDetectorAprilTagInfoML(address, container);
    }

    public XrMarkerDetectorAprilTagInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrMarkerDetectorAprilTagInfoML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerDetectorAprilTagInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrMarkerDetectorAprilTagInfoML.nnext(this.address());
    }

    @NativeType(value="XrMarkerAprilTagDictML")
    public int aprilTagDict() {
        return XrMarkerDetectorAprilTagInfoML.naprilTagDict(this.address());
    }

    public XrMarkerDetectorAprilTagInfoML type(@NativeType(value="XrStructureType") int value) {
        XrMarkerDetectorAprilTagInfoML.ntype(this.address(), value);
        return this;
    }

    public XrMarkerDetectorAprilTagInfoML type$Default() {
        return this.type(1000138004);
    }

    public XrMarkerDetectorAprilTagInfoML next(@NativeType(value="void const *") long value) {
        XrMarkerDetectorAprilTagInfoML.nnext(this.address(), value);
        return this;
    }

    public XrMarkerDetectorAprilTagInfoML aprilTagDict(@NativeType(value="XrMarkerAprilTagDictML") int value) {
        XrMarkerDetectorAprilTagInfoML.naprilTagDict(this.address(), value);
        return this;
    }

    public XrMarkerDetectorAprilTagInfoML set(int type, long next, int aprilTagDict) {
        this.type(type);
        this.next(next);
        this.aprilTagDict(aprilTagDict);
        return this;
    }

    public XrMarkerDetectorAprilTagInfoML set(XrMarkerDetectorAprilTagInfoML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrMarkerDetectorAprilTagInfoML malloc() {
        return new XrMarkerDetectorAprilTagInfoML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrMarkerDetectorAprilTagInfoML calloc() {
        return new XrMarkerDetectorAprilTagInfoML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrMarkerDetectorAprilTagInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrMarkerDetectorAprilTagInfoML(MemoryUtil.memAddress(container), container);
    }

    public static XrMarkerDetectorAprilTagInfoML create(long address) {
        return new XrMarkerDetectorAprilTagInfoML(address, null);
    }

    public static @Nullable XrMarkerDetectorAprilTagInfoML createSafe(long address) {
        return address == 0L ? null : new XrMarkerDetectorAprilTagInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrMarkerDetectorAprilTagInfoML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerDetectorAprilTagInfoML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrMarkerDetectorAprilTagInfoML malloc(MemoryStack stack) {
        return new XrMarkerDetectorAprilTagInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrMarkerDetectorAprilTagInfoML calloc(MemoryStack stack) {
        return new XrMarkerDetectorAprilTagInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int naprilTagDict(long struct) {
        return MemoryUtil.memGetInt(struct + (long)APRILTAGDICT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void naprilTagDict(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)APRILTAGDICT, value);
    }

    static {
        Struct.Layout layout = XrMarkerDetectorAprilTagInfoML.__struct(XrMarkerDetectorAprilTagInfoML.__member(4), XrMarkerDetectorAprilTagInfoML.__member(POINTER_SIZE), XrMarkerDetectorAprilTagInfoML.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        APRILTAGDICT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerDetectorAprilTagInfoML, Buffer>
    implements NativeResource {
        private static final XrMarkerDetectorAprilTagInfoML ELEMENT_FACTORY = XrMarkerDetectorAprilTagInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrMarkerDetectorAprilTagInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerDetectorAprilTagInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrMarkerDetectorAprilTagInfoML.nnext(this.address());
        }

        @NativeType(value="XrMarkerAprilTagDictML")
        public int aprilTagDict() {
            return XrMarkerDetectorAprilTagInfoML.naprilTagDict(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerDetectorAprilTagInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000138004);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrMarkerDetectorAprilTagInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer aprilTagDict(@NativeType(value="XrMarkerAprilTagDictML") int value) {
            XrMarkerDetectorAprilTagInfoML.naprilTagDict(this.address(), value);
            return this;
        }
    }
}

