/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerDetectorCustomProfileInfoML
extends Struct<XrMarkerDetectorCustomProfileInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FPSHINT;
    public static final int RESOLUTIONHINT;
    public static final int CAMERAHINT;
    public static final int CORNERREFINEMETHOD;
    public static final int USEEDGEREFINEMENT;
    public static final int FULLANALYSISINTERVALHINT;

    protected XrMarkerDetectorCustomProfileInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrMarkerDetectorCustomProfileInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrMarkerDetectorCustomProfileInfoML(address, container);
    }

    public XrMarkerDetectorCustomProfileInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrMarkerDetectorCustomProfileInfoML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerDetectorCustomProfileInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrMarkerDetectorCustomProfileInfoML.nnext(this.address());
    }

    @NativeType(value="XrMarkerDetectorFpsML")
    public int fpsHint() {
        return XrMarkerDetectorCustomProfileInfoML.nfpsHint(this.address());
    }

    @NativeType(value="XrMarkerDetectorResolutionML")
    public int resolutionHint() {
        return XrMarkerDetectorCustomProfileInfoML.nresolutionHint(this.address());
    }

    @NativeType(value="XrMarkerDetectorCameraML")
    public int cameraHint() {
        return XrMarkerDetectorCustomProfileInfoML.ncameraHint(this.address());
    }

    @NativeType(value="XrMarkerDetectorCornerRefineMethodML")
    public int cornerRefineMethod() {
        return XrMarkerDetectorCustomProfileInfoML.ncornerRefineMethod(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean useEdgeRefinement() {
        return XrMarkerDetectorCustomProfileInfoML.nuseEdgeRefinement(this.address()) != 0;
    }

    @NativeType(value="XrMarkerDetectorFullAnalysisIntervalML")
    public int fullAnalysisIntervalHint() {
        return XrMarkerDetectorCustomProfileInfoML.nfullAnalysisIntervalHint(this.address());
    }

    public XrMarkerDetectorCustomProfileInfoML type(@NativeType(value="XrStructureType") int value) {
        XrMarkerDetectorCustomProfileInfoML.ntype(this.address(), value);
        return this;
    }

    public XrMarkerDetectorCustomProfileInfoML type$Default() {
        return this.type(1000138005);
    }

    public XrMarkerDetectorCustomProfileInfoML next(@NativeType(value="void const *") long value) {
        XrMarkerDetectorCustomProfileInfoML.nnext(this.address(), value);
        return this;
    }

    public XrMarkerDetectorCustomProfileInfoML fpsHint(@NativeType(value="XrMarkerDetectorFpsML") int value) {
        XrMarkerDetectorCustomProfileInfoML.nfpsHint(this.address(), value);
        return this;
    }

    public XrMarkerDetectorCustomProfileInfoML resolutionHint(@NativeType(value="XrMarkerDetectorResolutionML") int value) {
        XrMarkerDetectorCustomProfileInfoML.nresolutionHint(this.address(), value);
        return this;
    }

    public XrMarkerDetectorCustomProfileInfoML cameraHint(@NativeType(value="XrMarkerDetectorCameraML") int value) {
        XrMarkerDetectorCustomProfileInfoML.ncameraHint(this.address(), value);
        return this;
    }

    public XrMarkerDetectorCustomProfileInfoML cornerRefineMethod(@NativeType(value="XrMarkerDetectorCornerRefineMethodML") int value) {
        XrMarkerDetectorCustomProfileInfoML.ncornerRefineMethod(this.address(), value);
        return this;
    }

    public XrMarkerDetectorCustomProfileInfoML useEdgeRefinement(@NativeType(value="XrBool32") boolean value) {
        XrMarkerDetectorCustomProfileInfoML.nuseEdgeRefinement(this.address(), value ? 1 : 0);
        return this;
    }

    public XrMarkerDetectorCustomProfileInfoML fullAnalysisIntervalHint(@NativeType(value="XrMarkerDetectorFullAnalysisIntervalML") int value) {
        XrMarkerDetectorCustomProfileInfoML.nfullAnalysisIntervalHint(this.address(), value);
        return this;
    }

    public XrMarkerDetectorCustomProfileInfoML set(int type, long next, int fpsHint, int resolutionHint, int cameraHint, int cornerRefineMethod, boolean useEdgeRefinement, int fullAnalysisIntervalHint) {
        this.type(type);
        this.next(next);
        this.fpsHint(fpsHint);
        this.resolutionHint(resolutionHint);
        this.cameraHint(cameraHint);
        this.cornerRefineMethod(cornerRefineMethod);
        this.useEdgeRefinement(useEdgeRefinement);
        this.fullAnalysisIntervalHint(fullAnalysisIntervalHint);
        return this;
    }

    public XrMarkerDetectorCustomProfileInfoML set(XrMarkerDetectorCustomProfileInfoML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrMarkerDetectorCustomProfileInfoML malloc() {
        return new XrMarkerDetectorCustomProfileInfoML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrMarkerDetectorCustomProfileInfoML calloc() {
        return new XrMarkerDetectorCustomProfileInfoML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrMarkerDetectorCustomProfileInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrMarkerDetectorCustomProfileInfoML(MemoryUtil.memAddress(container), container);
    }

    public static XrMarkerDetectorCustomProfileInfoML create(long address) {
        return new XrMarkerDetectorCustomProfileInfoML(address, null);
    }

    public static @Nullable XrMarkerDetectorCustomProfileInfoML createSafe(long address) {
        return address == 0L ? null : new XrMarkerDetectorCustomProfileInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrMarkerDetectorCustomProfileInfoML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerDetectorCustomProfileInfoML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrMarkerDetectorCustomProfileInfoML malloc(MemoryStack stack) {
        return new XrMarkerDetectorCustomProfileInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrMarkerDetectorCustomProfileInfoML calloc(MemoryStack stack) {
        return new XrMarkerDetectorCustomProfileInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nfpsHint(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FPSHINT);
    }

    public static int nresolutionHint(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESOLUTIONHINT);
    }

    public static int ncameraHint(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CAMERAHINT);
    }

    public static int ncornerRefineMethod(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CORNERREFINEMETHOD);
    }

    public static int nuseEdgeRefinement(long struct) {
        return MemoryUtil.memGetInt(struct + (long)USEEDGEREFINEMENT);
    }

    public static int nfullAnalysisIntervalHint(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FULLANALYSISINTERVALHINT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nfpsHint(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FPSHINT, value);
    }

    public static void nresolutionHint(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESOLUTIONHINT, value);
    }

    public static void ncameraHint(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CAMERAHINT, value);
    }

    public static void ncornerRefineMethod(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CORNERREFINEMETHOD, value);
    }

    public static void nuseEdgeRefinement(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)USEEDGEREFINEMENT, value);
    }

    public static void nfullAnalysisIntervalHint(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FULLANALYSISINTERVALHINT, value);
    }

    static {
        Struct.Layout layout = XrMarkerDetectorCustomProfileInfoML.__struct(XrMarkerDetectorCustomProfileInfoML.__member(4), XrMarkerDetectorCustomProfileInfoML.__member(POINTER_SIZE), XrMarkerDetectorCustomProfileInfoML.__member(4), XrMarkerDetectorCustomProfileInfoML.__member(4), XrMarkerDetectorCustomProfileInfoML.__member(4), XrMarkerDetectorCustomProfileInfoML.__member(4), XrMarkerDetectorCustomProfileInfoML.__member(4), XrMarkerDetectorCustomProfileInfoML.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FPSHINT = layout.offsetof(2);
        RESOLUTIONHINT = layout.offsetof(3);
        CAMERAHINT = layout.offsetof(4);
        CORNERREFINEMETHOD = layout.offsetof(5);
        USEEDGEREFINEMENT = layout.offsetof(6);
        FULLANALYSISINTERVALHINT = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerDetectorCustomProfileInfoML, Buffer>
    implements NativeResource {
        private static final XrMarkerDetectorCustomProfileInfoML ELEMENT_FACTORY = XrMarkerDetectorCustomProfileInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrMarkerDetectorCustomProfileInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerDetectorCustomProfileInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrMarkerDetectorCustomProfileInfoML.nnext(this.address());
        }

        @NativeType(value="XrMarkerDetectorFpsML")
        public int fpsHint() {
            return XrMarkerDetectorCustomProfileInfoML.nfpsHint(this.address());
        }

        @NativeType(value="XrMarkerDetectorResolutionML")
        public int resolutionHint() {
            return XrMarkerDetectorCustomProfileInfoML.nresolutionHint(this.address());
        }

        @NativeType(value="XrMarkerDetectorCameraML")
        public int cameraHint() {
            return XrMarkerDetectorCustomProfileInfoML.ncameraHint(this.address());
        }

        @NativeType(value="XrMarkerDetectorCornerRefineMethodML")
        public int cornerRefineMethod() {
            return XrMarkerDetectorCustomProfileInfoML.ncornerRefineMethod(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean useEdgeRefinement() {
            return XrMarkerDetectorCustomProfileInfoML.nuseEdgeRefinement(this.address()) != 0;
        }

        @NativeType(value="XrMarkerDetectorFullAnalysisIntervalML")
        public int fullAnalysisIntervalHint() {
            return XrMarkerDetectorCustomProfileInfoML.nfullAnalysisIntervalHint(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerDetectorCustomProfileInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000138005);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrMarkerDetectorCustomProfileInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer fpsHint(@NativeType(value="XrMarkerDetectorFpsML") int value) {
            XrMarkerDetectorCustomProfileInfoML.nfpsHint(this.address(), value);
            return this;
        }

        public Buffer resolutionHint(@NativeType(value="XrMarkerDetectorResolutionML") int value) {
            XrMarkerDetectorCustomProfileInfoML.nresolutionHint(this.address(), value);
            return this;
        }

        public Buffer cameraHint(@NativeType(value="XrMarkerDetectorCameraML") int value) {
            XrMarkerDetectorCustomProfileInfoML.ncameraHint(this.address(), value);
            return this;
        }

        public Buffer cornerRefineMethod(@NativeType(value="XrMarkerDetectorCornerRefineMethodML") int value) {
            XrMarkerDetectorCustomProfileInfoML.ncornerRefineMethod(this.address(), value);
            return this;
        }

        public Buffer useEdgeRefinement(@NativeType(value="XrBool32") boolean value) {
            XrMarkerDetectorCustomProfileInfoML.nuseEdgeRefinement(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer fullAnalysisIntervalHint(@NativeType(value="XrMarkerDetectorFullAnalysisIntervalML") int value) {
            XrMarkerDetectorCustomProfileInfoML.nfullAnalysisIntervalHint(this.address(), value);
            return this;
        }
    }
}

