/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerSpaceCreateInfoVARJO
extends Struct<XrMarkerSpaceCreateInfoVARJO>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MARKERID;
    public static final int POSEINMARKERSPACE;

    protected XrMarkerSpaceCreateInfoVARJO(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrMarkerSpaceCreateInfoVARJO create(long address, @Nullable ByteBuffer container) {
        return new XrMarkerSpaceCreateInfoVARJO(address, container);
    }

    public XrMarkerSpaceCreateInfoVARJO(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrMarkerSpaceCreateInfoVARJO.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerSpaceCreateInfoVARJO.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrMarkerSpaceCreateInfoVARJO.nnext(this.address());
    }

    @NativeType(value="uint64_t")
    public long markerId() {
        return XrMarkerSpaceCreateInfoVARJO.nmarkerId(this.address());
    }

    public XrPosef poseInMarkerSpace() {
        return XrMarkerSpaceCreateInfoVARJO.nposeInMarkerSpace(this.address());
    }

    public XrMarkerSpaceCreateInfoVARJO type(@NativeType(value="XrStructureType") int value) {
        XrMarkerSpaceCreateInfoVARJO.ntype(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoVARJO type$Default() {
        return this.type(1000124002);
    }

    public XrMarkerSpaceCreateInfoVARJO next(@NativeType(value="void const *") long value) {
        XrMarkerSpaceCreateInfoVARJO.nnext(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoVARJO markerId(@NativeType(value="uint64_t") long value) {
        XrMarkerSpaceCreateInfoVARJO.nmarkerId(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoVARJO poseInMarkerSpace(XrPosef value) {
        XrMarkerSpaceCreateInfoVARJO.nposeInMarkerSpace(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoVARJO poseInMarkerSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInMarkerSpace());
        return this;
    }

    public XrMarkerSpaceCreateInfoVARJO set(int type, long next, long markerId, XrPosef poseInMarkerSpace) {
        this.type(type);
        this.next(next);
        this.markerId(markerId);
        this.poseInMarkerSpace(poseInMarkerSpace);
        return this;
    }

    public XrMarkerSpaceCreateInfoVARJO set(XrMarkerSpaceCreateInfoVARJO src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrMarkerSpaceCreateInfoVARJO malloc() {
        return new XrMarkerSpaceCreateInfoVARJO(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrMarkerSpaceCreateInfoVARJO calloc() {
        return new XrMarkerSpaceCreateInfoVARJO(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrMarkerSpaceCreateInfoVARJO create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrMarkerSpaceCreateInfoVARJO(MemoryUtil.memAddress(container), container);
    }

    public static XrMarkerSpaceCreateInfoVARJO create(long address) {
        return new XrMarkerSpaceCreateInfoVARJO(address, null);
    }

    public static @Nullable XrMarkerSpaceCreateInfoVARJO createSafe(long address) {
        return address == 0L ? null : new XrMarkerSpaceCreateInfoVARJO(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrMarkerSpaceCreateInfoVARJO.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerSpaceCreateInfoVARJO.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrMarkerSpaceCreateInfoVARJO malloc(MemoryStack stack) {
        return new XrMarkerSpaceCreateInfoVARJO(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrMarkerSpaceCreateInfoVARJO calloc(MemoryStack stack) {
        return new XrMarkerSpaceCreateInfoVARJO(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nmarkerId(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MARKERID);
    }

    public static XrPosef nposeInMarkerSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINMARKERSPACE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nmarkerId(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MARKERID, value);
    }

    public static void nposeInMarkerSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSEINMARKERSPACE, XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrMarkerSpaceCreateInfoVARJO.__struct(XrMarkerSpaceCreateInfoVARJO.__member(4), XrMarkerSpaceCreateInfoVARJO.__member(POINTER_SIZE), XrMarkerSpaceCreateInfoVARJO.__member(8), XrMarkerSpaceCreateInfoVARJO.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MARKERID = layout.offsetof(2);
        POSEINMARKERSPACE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerSpaceCreateInfoVARJO, Buffer>
    implements NativeResource {
        private static final XrMarkerSpaceCreateInfoVARJO ELEMENT_FACTORY = XrMarkerSpaceCreateInfoVARJO.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrMarkerSpaceCreateInfoVARJO getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerSpaceCreateInfoVARJO.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrMarkerSpaceCreateInfoVARJO.nnext(this.address());
        }

        @NativeType(value="uint64_t")
        public long markerId() {
            return XrMarkerSpaceCreateInfoVARJO.nmarkerId(this.address());
        }

        public XrPosef poseInMarkerSpace() {
            return XrMarkerSpaceCreateInfoVARJO.nposeInMarkerSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerSpaceCreateInfoVARJO.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000124002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrMarkerSpaceCreateInfoVARJO.nnext(this.address(), value);
            return this;
        }

        public Buffer markerId(@NativeType(value="uint64_t") long value) {
            XrMarkerSpaceCreateInfoVARJO.nmarkerId(this.address(), value);
            return this;
        }

        public Buffer poseInMarkerSpace(XrPosef value) {
            XrMarkerSpaceCreateInfoVARJO.nposeInMarkerSpace(this.address(), value);
            return this;
        }

        public Buffer poseInMarkerSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInMarkerSpace());
            return this;
        }
    }
}

