/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrOffset3DfFB
extends Struct<XrOffset3DfFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    protected XrOffset3DfFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrOffset3DfFB create(long address, @Nullable ByteBuffer container) {
        return new XrOffset3DfFB(address, container);
    }

    public XrOffset3DfFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrOffset3DfFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return XrOffset3DfFB.nx(this.address());
    }

    public float y() {
        return XrOffset3DfFB.ny(this.address());
    }

    public float z() {
        return XrOffset3DfFB.nz(this.address());
    }

    public XrOffset3DfFB x(float value) {
        XrOffset3DfFB.nx(this.address(), value);
        return this;
    }

    public XrOffset3DfFB y(float value) {
        XrOffset3DfFB.ny(this.address(), value);
        return this;
    }

    public XrOffset3DfFB z(float value) {
        XrOffset3DfFB.nz(this.address(), value);
        return this;
    }

    public XrOffset3DfFB set(float x, float y, float z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public XrOffset3DfFB set(XrOffset3DfFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrOffset3DfFB malloc() {
        return new XrOffset3DfFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrOffset3DfFB calloc() {
        return new XrOffset3DfFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrOffset3DfFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrOffset3DfFB(MemoryUtil.memAddress(container), container);
    }

    public static XrOffset3DfFB create(long address) {
        return new XrOffset3DfFB(address, null);
    }

    public static @Nullable XrOffset3DfFB createSafe(long address) {
        return address == 0L ? null : new XrOffset3DfFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrOffset3DfFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrOffset3DfFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrOffset3DfFB malloc(MemoryStack stack) {
        return new XrOffset3DfFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrOffset3DfFB calloc(MemoryStack stack) {
        return new XrOffset3DfFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = XrOffset3DfFB.__struct(XrOffset3DfFB.__member(4), XrOffset3DfFB.__member(4), XrOffset3DfFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrOffset3DfFB, Buffer>
    implements NativeResource {
        private static final XrOffset3DfFB ELEMENT_FACTORY = XrOffset3DfFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrOffset3DfFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return XrOffset3DfFB.nx(this.address());
        }

        public float y() {
            return XrOffset3DfFB.ny(this.address());
        }

        public float z() {
            return XrOffset3DfFB.nz(this.address());
        }

        public Buffer x(float value) {
            XrOffset3DfFB.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            XrOffset3DfFB.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            XrOffset3DfFB.nz(this.address(), value);
            return this;
        }
    }
}

