/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrQuaternionf
extends Struct<XrQuaternionf>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    protected XrQuaternionf(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrQuaternionf create(long address, @Nullable ByteBuffer container) {
        return new XrQuaternionf(address, container);
    }

    public XrQuaternionf(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrQuaternionf.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return XrQuaternionf.nx(this.address());
    }

    public float y() {
        return XrQuaternionf.ny(this.address());
    }

    public float z() {
        return XrQuaternionf.nz(this.address());
    }

    public float w() {
        return XrQuaternionf.nw(this.address());
    }

    public XrQuaternionf x(float value) {
        XrQuaternionf.nx(this.address(), value);
        return this;
    }

    public XrQuaternionf y(float value) {
        XrQuaternionf.ny(this.address(), value);
        return this;
    }

    public XrQuaternionf z(float value) {
        XrQuaternionf.nz(this.address(), value);
        return this;
    }

    public XrQuaternionf w(float value) {
        XrQuaternionf.nw(this.address(), value);
        return this;
    }

    public XrQuaternionf set(float x, float y, float z, float w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public XrQuaternionf set(XrQuaternionf src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrQuaternionf malloc() {
        return new XrQuaternionf(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrQuaternionf calloc() {
        return new XrQuaternionf(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrQuaternionf create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrQuaternionf(MemoryUtil.memAddress(container), container);
    }

    public static XrQuaternionf create(long address) {
        return new XrQuaternionf(address, null);
    }

    public static @Nullable XrQuaternionf createSafe(long address) {
        return address == 0L ? null : new XrQuaternionf(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrQuaternionf.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrQuaternionf.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrQuaternionf malloc(MemoryStack stack) {
        return new XrQuaternionf(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrQuaternionf calloc(MemoryStack stack) {
        return new XrQuaternionf(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static float nw(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)W);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Z, value);
    }

    public static void nw(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)W, value);
    }

    static {
        Struct.Layout layout = XrQuaternionf.__struct(XrQuaternionf.__member(4), XrQuaternionf.__member(4), XrQuaternionf.__member(4), XrQuaternionf.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrQuaternionf, Buffer>
    implements NativeResource {
        private static final XrQuaternionf ELEMENT_FACTORY = XrQuaternionf.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrQuaternionf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return XrQuaternionf.nx(this.address());
        }

        public float y() {
            return XrQuaternionf.ny(this.address());
        }

        public float z() {
            return XrQuaternionf.nz(this.address());
        }

        public float w() {
            return XrQuaternionf.nw(this.address());
        }

        public Buffer x(float value) {
            XrQuaternionf.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            XrQuaternionf.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            XrQuaternionf.nz(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            XrQuaternionf.nw(this.address(), value);
            return this;
        }
    }
}

