/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent3DfFB;
import org.lwjgl.openxr.XrOffset3DfFB;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRect3DfFB
extends Struct<XrRect3DfFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int EXTENT;

    protected XrRect3DfFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrRect3DfFB create(long address, @Nullable ByteBuffer container) {
        return new XrRect3DfFB(address, container);
    }

    public XrRect3DfFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrRect3DfFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public XrOffset3DfFB offset() {
        return XrRect3DfFB.noffset(this.address());
    }

    public XrExtent3DfFB extent() {
        return XrRect3DfFB.nextent(this.address());
    }

    public XrRect3DfFB offset(XrOffset3DfFB value) {
        XrRect3DfFB.noffset(this.address(), value);
        return this;
    }

    public XrRect3DfFB offset(Consumer<XrOffset3DfFB> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public XrRect3DfFB extent(XrExtent3DfFB value) {
        XrRect3DfFB.nextent(this.address(), value);
        return this;
    }

    public XrRect3DfFB extent(Consumer<XrExtent3DfFB> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public XrRect3DfFB set(XrOffset3DfFB offset, XrExtent3DfFB extent) {
        this.offset(offset);
        this.extent(extent);
        return this;
    }

    public XrRect3DfFB set(XrRect3DfFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrRect3DfFB malloc() {
        return new XrRect3DfFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrRect3DfFB calloc() {
        return new XrRect3DfFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrRect3DfFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrRect3DfFB(MemoryUtil.memAddress(container), container);
    }

    public static XrRect3DfFB create(long address) {
        return new XrRect3DfFB(address, null);
    }

    public static @Nullable XrRect3DfFB createSafe(long address) {
        return address == 0L ? null : new XrRect3DfFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrRect3DfFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRect3DfFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrRect3DfFB malloc(MemoryStack stack) {
        return new XrRect3DfFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrRect3DfFB calloc(MemoryStack stack) {
        return new XrRect3DfFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrOffset3DfFB noffset(long struct) {
        return XrOffset3DfFB.create(struct + (long)OFFSET);
    }

    public static XrExtent3DfFB nextent(long struct) {
        return XrExtent3DfFB.create(struct + (long)EXTENT);
    }

    public static void noffset(long struct, XrOffset3DfFB value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OFFSET, XrOffset3DfFB.SIZEOF);
    }

    public static void nextent(long struct, XrExtent3DfFB value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, XrExtent3DfFB.SIZEOF);
    }

    static {
        Struct.Layout layout = XrRect3DfFB.__struct(XrRect3DfFB.__member(XrOffset3DfFB.SIZEOF, XrOffset3DfFB.ALIGNOF), XrRect3DfFB.__member(XrExtent3DfFB.SIZEOF, XrExtent3DfFB.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrRect3DfFB, Buffer>
    implements NativeResource {
        private static final XrRect3DfFB ELEMENT_FACTORY = XrRect3DfFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrRect3DfFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrOffset3DfFB offset() {
            return XrRect3DfFB.noffset(this.address());
        }

        public XrExtent3DfFB extent() {
            return XrRect3DfFB.nextent(this.address());
        }

        public Buffer offset(XrOffset3DfFB value) {
            XrRect3DfFB.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<XrOffset3DfFB> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public Buffer extent(XrExtent3DfFB value) {
            XrRect3DfFB.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<XrExtent3DfFB> consumer) {
            consumer.accept(this.extent());
            return this;
        }
    }
}

