/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneFrustumBoundMSFT;
import org.lwjgl.openxr.XrSceneOrientedBoxBoundMSFT;
import org.lwjgl.openxr.XrSceneSphereBoundMSFT;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneBoundsMSFT
extends Struct<XrSceneBoundsMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SPACE;
    public static final int TIME;
    public static final int SPHERECOUNT;
    public static final int SPHERES;
    public static final int BOXCOUNT;
    public static final int BOXES;
    public static final int FRUSTUMCOUNT;
    public static final int FRUSTUMS;

    protected XrSceneBoundsMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSceneBoundsMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneBoundsMSFT(address, container);
    }

    public XrSceneBoundsMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneBoundsMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrSceneBoundsMSFT.nspace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrSceneBoundsMSFT.ntime(this.address());
    }

    @NativeType(value="uint32_t")
    public int sphereCount() {
        return XrSceneBoundsMSFT.nsphereCount(this.address());
    }

    @NativeType(value="XrSceneSphereBoundMSFT const *")
    public @Nullable XrSceneSphereBoundMSFT.Buffer spheres() {
        return XrSceneBoundsMSFT.nspheres(this.address());
    }

    @NativeType(value="uint32_t")
    public int boxCount() {
        return XrSceneBoundsMSFT.nboxCount(this.address());
    }

    @NativeType(value="XrSceneOrientedBoxBoundMSFT const *")
    public @Nullable XrSceneOrientedBoxBoundMSFT.Buffer boxes() {
        return XrSceneBoundsMSFT.nboxes(this.address());
    }

    @NativeType(value="uint32_t")
    public int frustumCount() {
        return XrSceneBoundsMSFT.nfrustumCount(this.address());
    }

    @NativeType(value="XrSceneFrustumBoundMSFT const *")
    public @Nullable XrSceneFrustumBoundMSFT.Buffer frustums() {
        return XrSceneBoundsMSFT.nfrustums(this.address());
    }

    public XrSceneBoundsMSFT space(XrSpace value) {
        XrSceneBoundsMSFT.nspace(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT time(@NativeType(value="XrTime") long value) {
        XrSceneBoundsMSFT.ntime(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT sphereCount(@NativeType(value="uint32_t") int value) {
        XrSceneBoundsMSFT.nsphereCount(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT spheres(@NativeType(value="XrSceneSphereBoundMSFT const *") @Nullable XrSceneSphereBoundMSFT.Buffer value) {
        XrSceneBoundsMSFT.nspheres(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT boxCount(@NativeType(value="uint32_t") int value) {
        XrSceneBoundsMSFT.nboxCount(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT boxes(@NativeType(value="XrSceneOrientedBoxBoundMSFT const *") @Nullable XrSceneOrientedBoxBoundMSFT.Buffer value) {
        XrSceneBoundsMSFT.nboxes(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT frustumCount(@NativeType(value="uint32_t") int value) {
        XrSceneBoundsMSFT.nfrustumCount(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT frustums(@NativeType(value="XrSceneFrustumBoundMSFT const *") @Nullable XrSceneFrustumBoundMSFT.Buffer value) {
        XrSceneBoundsMSFT.nfrustums(this.address(), value);
        return this;
    }

    public XrSceneBoundsMSFT set(XrSpace space, long time, int sphereCount, @Nullable XrSceneSphereBoundMSFT.Buffer spheres, int boxCount, @Nullable XrSceneOrientedBoxBoundMSFT.Buffer boxes, int frustumCount, @Nullable XrSceneFrustumBoundMSFT.Buffer frustums) {
        this.space(space);
        this.time(time);
        this.sphereCount(sphereCount);
        this.spheres(spheres);
        this.boxCount(boxCount);
        this.boxes(boxes);
        this.frustumCount(frustumCount);
        this.frustums(frustums);
        return this;
    }

    public XrSceneBoundsMSFT set(XrSceneBoundsMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneBoundsMSFT malloc() {
        return new XrSceneBoundsMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSceneBoundsMSFT calloc() {
        return new XrSceneBoundsMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSceneBoundsMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSceneBoundsMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrSceneBoundsMSFT create(long address) {
        return new XrSceneBoundsMSFT(address, null);
    }

    public static @Nullable XrSceneBoundsMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneBoundsMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSceneBoundsMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneBoundsMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneBoundsMSFT malloc(MemoryStack stack) {
        return new XrSceneBoundsMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneBoundsMSFT calloc(MemoryStack stack) {
        return new XrSceneBoundsMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static int nsphereCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPHERECOUNT);
    }

    public static @Nullable XrSceneSphereBoundMSFT.Buffer nspheres(long struct) {
        return XrSceneSphereBoundMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)SPHERES), XrSceneBoundsMSFT.nsphereCount(struct));
    }

    public static int nboxCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BOXCOUNT);
    }

    public static @Nullable XrSceneOrientedBoxBoundMSFT.Buffer nboxes(long struct) {
        return XrSceneOrientedBoxBoundMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)BOXES), XrSceneBoundsMSFT.nboxCount(struct));
    }

    public static int nfrustumCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRUSTUMCOUNT);
    }

    public static @Nullable XrSceneFrustumBoundMSFT.Buffer nfrustums(long struct) {
        return XrSceneFrustumBoundMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)FRUSTUMS), XrSceneBoundsMSFT.nfrustumCount(struct));
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    public static void nsphereCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPHERECOUNT, value);
    }

    public static void nspheres(long struct, @Nullable XrSceneSphereBoundMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)SPHERES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneBoundsMSFT.nsphereCount(struct, value.remaining());
        }
    }

    public static void nboxCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BOXCOUNT, value);
    }

    public static void nboxes(long struct, @Nullable XrSceneOrientedBoxBoundMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)BOXES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneBoundsMSFT.nboxCount(struct, value.remaining());
        }
    }

    public static void nfrustumCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRUSTUMCOUNT, value);
    }

    public static void nfrustums(long struct, @Nullable XrSceneFrustumBoundMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)FRUSTUMS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneBoundsMSFT.nfrustumCount(struct, value.remaining());
        }
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
    }

    static {
        Struct.Layout layout = XrSceneBoundsMSFT.__struct(XrSceneBoundsMSFT.__member(POINTER_SIZE), XrSceneBoundsMSFT.__member(8), XrSceneBoundsMSFT.__member(4), XrSceneBoundsMSFT.__member(POINTER_SIZE), XrSceneBoundsMSFT.__member(4), XrSceneBoundsMSFT.__member(POINTER_SIZE), XrSceneBoundsMSFT.__member(4), XrSceneBoundsMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SPACE = layout.offsetof(0);
        TIME = layout.offsetof(1);
        SPHERECOUNT = layout.offsetof(2);
        SPHERES = layout.offsetof(3);
        BOXCOUNT = layout.offsetof(4);
        BOXES = layout.offsetof(5);
        FRUSTUMCOUNT = layout.offsetof(6);
        FRUSTUMS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrSceneBoundsMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneBoundsMSFT ELEMENT_FACTORY = XrSceneBoundsMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSceneBoundsMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrSceneBoundsMSFT.nspace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrSceneBoundsMSFT.ntime(this.address());
        }

        @NativeType(value="uint32_t")
        public int sphereCount() {
            return XrSceneBoundsMSFT.nsphereCount(this.address());
        }

        @NativeType(value="XrSceneSphereBoundMSFT const *")
        public @Nullable XrSceneSphereBoundMSFT.Buffer spheres() {
            return XrSceneBoundsMSFT.nspheres(this.address());
        }

        @NativeType(value="uint32_t")
        public int boxCount() {
            return XrSceneBoundsMSFT.nboxCount(this.address());
        }

        @NativeType(value="XrSceneOrientedBoxBoundMSFT const *")
        public @Nullable XrSceneOrientedBoxBoundMSFT.Buffer boxes() {
            return XrSceneBoundsMSFT.nboxes(this.address());
        }

        @NativeType(value="uint32_t")
        public int frustumCount() {
            return XrSceneBoundsMSFT.nfrustumCount(this.address());
        }

        @NativeType(value="XrSceneFrustumBoundMSFT const *")
        public @Nullable XrSceneFrustumBoundMSFT.Buffer frustums() {
            return XrSceneBoundsMSFT.nfrustums(this.address());
        }

        public Buffer space(XrSpace value) {
            XrSceneBoundsMSFT.nspace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrSceneBoundsMSFT.ntime(this.address(), value);
            return this;
        }

        public Buffer sphereCount(@NativeType(value="uint32_t") int value) {
            XrSceneBoundsMSFT.nsphereCount(this.address(), value);
            return this;
        }

        public Buffer spheres(@NativeType(value="XrSceneSphereBoundMSFT const *") @Nullable XrSceneSphereBoundMSFT.Buffer value) {
            XrSceneBoundsMSFT.nspheres(this.address(), value);
            return this;
        }

        public Buffer boxCount(@NativeType(value="uint32_t") int value) {
            XrSceneBoundsMSFT.nboxCount(this.address(), value);
            return this;
        }

        public Buffer boxes(@NativeType(value="XrSceneOrientedBoxBoundMSFT const *") @Nullable XrSceneOrientedBoxBoundMSFT.Buffer value) {
            XrSceneBoundsMSFT.nboxes(this.address(), value);
            return this;
        }

        public Buffer frustumCount(@NativeType(value="uint32_t") int value) {
            XrSceneBoundsMSFT.nfrustumCount(this.address(), value);
            return this;
        }

        public Buffer frustums(@NativeType(value="XrSceneFrustumBoundMSFT const *") @Nullable XrSceneFrustumBoundMSFT.Buffer value) {
            XrSceneBoundsMSFT.nfrustums(this.address(), value);
            return this;
        }
    }
}

