/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneCaptureRequestInfoFB
extends Struct<XrSceneCaptureRequestInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int REQUESTBYTECOUNT;
    public static final int REQUEST;

    protected XrSceneCaptureRequestInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSceneCaptureRequestInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrSceneCaptureRequestInfoFB(address, container);
    }

    public XrSceneCaptureRequestInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneCaptureRequestInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneCaptureRequestInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSceneCaptureRequestInfoFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int requestByteCount() {
        return XrSceneCaptureRequestInfoFB.nrequestByteCount(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer request() {
        return XrSceneCaptureRequestInfoFB.nrequest(this.address());
    }

    public XrSceneCaptureRequestInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSceneCaptureRequestInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSceneCaptureRequestInfoFB type$Default() {
        return this.type(1000198050);
    }

    public XrSceneCaptureRequestInfoFB next(@NativeType(value="void const *") long value) {
        XrSceneCaptureRequestInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSceneCaptureRequestInfoFB requestByteCount(@NativeType(value="uint32_t") int value) {
        XrSceneCaptureRequestInfoFB.nrequestByteCount(this.address(), value);
        return this;
    }

    public XrSceneCaptureRequestInfoFB request(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        XrSceneCaptureRequestInfoFB.nrequest(this.address(), value);
        return this;
    }

    public XrSceneCaptureRequestInfoFB set(int type, long next, int requestByteCount, @Nullable ByteBuffer request) {
        this.type(type);
        this.next(next);
        this.requestByteCount(requestByteCount);
        this.request(request);
        return this;
    }

    public XrSceneCaptureRequestInfoFB set(XrSceneCaptureRequestInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneCaptureRequestInfoFB malloc() {
        return new XrSceneCaptureRequestInfoFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSceneCaptureRequestInfoFB calloc() {
        return new XrSceneCaptureRequestInfoFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSceneCaptureRequestInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSceneCaptureRequestInfoFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSceneCaptureRequestInfoFB create(long address) {
        return new XrSceneCaptureRequestInfoFB(address, null);
    }

    public static @Nullable XrSceneCaptureRequestInfoFB createSafe(long address) {
        return address == 0L ? null : new XrSceneCaptureRequestInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSceneCaptureRequestInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneCaptureRequestInfoFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneCaptureRequestInfoFB malloc(MemoryStack stack) {
        return new XrSceneCaptureRequestInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneCaptureRequestInfoFB calloc(MemoryStack stack) {
        return new XrSceneCaptureRequestInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nrequestByteCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REQUESTBYTECOUNT);
    }

    public static @Nullable ByteBuffer nrequest(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)REQUEST), XrSceneCaptureRequestInfoFB.nrequestByteCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nrequestByteCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REQUESTBYTECOUNT, value);
    }

    public static void nrequest(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)REQUEST, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneCaptureRequestInfoFB.nrequestByteCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneCaptureRequestInfoFB.__struct(XrSceneCaptureRequestInfoFB.__member(4), XrSceneCaptureRequestInfoFB.__member(POINTER_SIZE), XrSceneCaptureRequestInfoFB.__member(4), XrSceneCaptureRequestInfoFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        REQUESTBYTECOUNT = layout.offsetof(2);
        REQUEST = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneCaptureRequestInfoFB, Buffer>
    implements NativeResource {
        private static final XrSceneCaptureRequestInfoFB ELEMENT_FACTORY = XrSceneCaptureRequestInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSceneCaptureRequestInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneCaptureRequestInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSceneCaptureRequestInfoFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int requestByteCount() {
            return XrSceneCaptureRequestInfoFB.nrequestByteCount(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable ByteBuffer request() {
            return XrSceneCaptureRequestInfoFB.nrequest(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneCaptureRequestInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000198050);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSceneCaptureRequestInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer requestByteCount(@NativeType(value="uint32_t") int value) {
            XrSceneCaptureRequestInfoFB.nrequestByteCount(this.address(), value);
            return this;
        }

        public Buffer request(@NativeType(value="char const *") @Nullable ByteBuffer value) {
            XrSceneCaptureRequestInfoFB.nrequest(this.address(), value);
            return this;
        }
    }
}

