/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneComponentMSFT;
import org.lwjgl.openxr.XrSceneMarkerQRCodesMSFT;
import org.lwjgl.openxr.XrSceneMarkersMSFT;
import org.lwjgl.openxr.XrSceneMeshesMSFT;
import org.lwjgl.openxr.XrSceneObjectsMSFT;
import org.lwjgl.openxr.XrScenePlanesMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneComponentsMSFT
extends Struct<XrSceneComponentsMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int COMPONENTCAPACITYINPUT;
    public static final int COMPONENTCOUNTOUTPUT;
    public static final int COMPONENTS;

    protected XrSceneComponentsMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSceneComponentsMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneComponentsMSFT(address, container);
    }

    public XrSceneComponentsMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneComponentsMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneComponentsMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneComponentsMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int componentCapacityInput() {
        return XrSceneComponentsMSFT.ncomponentCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int componentCountOutput() {
        return XrSceneComponentsMSFT.ncomponentCountOutput(this.address());
    }

    @NativeType(value="XrSceneComponentMSFT *")
    public @Nullable XrSceneComponentMSFT.Buffer components() {
        return XrSceneComponentsMSFT.ncomponents(this.address());
    }

    public XrSceneComponentsMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneComponentsMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneComponentsMSFT type$Default() {
        return this.type(1000097004);
    }

    public XrSceneComponentsMSFT next(@NativeType(value="void *") long value) {
        XrSceneComponentsMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneComponentsMSFT next(XrSceneMarkerQRCodesMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSceneComponentsMSFT next(XrSceneMarkersMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSceneComponentsMSFT next(XrSceneMeshesMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSceneComponentsMSFT next(XrSceneObjectsMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSceneComponentsMSFT next(XrScenePlanesMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSceneComponentsMSFT componentCapacityInput(@NativeType(value="uint32_t") int value) {
        XrSceneComponentsMSFT.ncomponentCapacityInput(this.address(), value);
        return this;
    }

    public XrSceneComponentsMSFT componentCountOutput(@NativeType(value="uint32_t") int value) {
        XrSceneComponentsMSFT.ncomponentCountOutput(this.address(), value);
        return this;
    }

    public XrSceneComponentsMSFT components(@NativeType(value="XrSceneComponentMSFT *") @Nullable XrSceneComponentMSFT.Buffer value) {
        XrSceneComponentsMSFT.ncomponents(this.address(), value);
        return this;
    }

    public XrSceneComponentsMSFT set(int type, long next, int componentCapacityInput, int componentCountOutput, @Nullable XrSceneComponentMSFT.Buffer components) {
        this.type(type);
        this.next(next);
        this.componentCapacityInput(componentCapacityInput);
        this.componentCountOutput(componentCountOutput);
        this.components(components);
        return this;
    }

    public XrSceneComponentsMSFT set(XrSceneComponentsMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneComponentsMSFT malloc() {
        return new XrSceneComponentsMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSceneComponentsMSFT calloc() {
        return new XrSceneComponentsMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSceneComponentsMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSceneComponentsMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrSceneComponentsMSFT create(long address) {
        return new XrSceneComponentsMSFT(address, null);
    }

    public static @Nullable XrSceneComponentsMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneComponentsMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSceneComponentsMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneComponentsMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneComponentsMSFT malloc(MemoryStack stack) {
        return new XrSceneComponentsMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneComponentsMSFT calloc(MemoryStack stack) {
        return new XrSceneComponentsMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int ncomponentCapacityInput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPONENTCAPACITYINPUT);
    }

    public static int ncomponentCountOutput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPONENTCOUNTOUTPUT);
    }

    public static @Nullable XrSceneComponentMSFT.Buffer ncomponents(long struct) {
        return XrSceneComponentMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)COMPONENTS), XrSceneComponentsMSFT.ncomponentCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ncomponentCapacityInput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMPONENTCAPACITYINPUT, value);
    }

    public static void ncomponentCountOutput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMPONENTCOUNTOUTPUT, value);
    }

    public static void ncomponents(long struct, @Nullable XrSceneComponentMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)COMPONENTS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneComponentsMSFT.ncomponentCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneComponentsMSFT.__struct(XrSceneComponentsMSFT.__member(4), XrSceneComponentsMSFT.__member(POINTER_SIZE), XrSceneComponentsMSFT.__member(4), XrSceneComponentsMSFT.__member(4), XrSceneComponentsMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        COMPONENTCAPACITYINPUT = layout.offsetof(2);
        COMPONENTCOUNTOUTPUT = layout.offsetof(3);
        COMPONENTS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSceneComponentsMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneComponentsMSFT ELEMENT_FACTORY = XrSceneComponentsMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSceneComponentsMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneComponentsMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneComponentsMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int componentCapacityInput() {
            return XrSceneComponentsMSFT.ncomponentCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int componentCountOutput() {
            return XrSceneComponentsMSFT.ncomponentCountOutput(this.address());
        }

        @NativeType(value="XrSceneComponentMSFT *")
        public @Nullable XrSceneComponentMSFT.Buffer components() {
            return XrSceneComponentsMSFT.ncomponents(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneComponentsMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097004);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneComponentsMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrSceneMarkerQRCodesMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSceneMarkersMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSceneMeshesMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSceneObjectsMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrScenePlanesMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer componentCapacityInput(@NativeType(value="uint32_t") int value) {
            XrSceneComponentsMSFT.ncomponentCapacityInput(this.address(), value);
            return this;
        }

        public Buffer componentCountOutput(@NativeType(value="uint32_t") int value) {
            XrSceneComponentsMSFT.ncomponentCountOutput(this.address(), value);
            return this;
        }

        public Buffer components(@NativeType(value="XrSceneComponentMSFT *") @Nullable XrSceneComponentMSFT.Buffer value) {
            XrSceneComponentsMSFT.ncomponents(this.address(), value);
            return this;
        }
    }
}

