/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrDeserializeSceneFragmentMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneDeserializeInfoMSFT
extends Struct<XrSceneDeserializeInfoMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FRAGMENTCOUNT;
    public static final int FRAGMENTS;

    protected XrSceneDeserializeInfoMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSceneDeserializeInfoMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneDeserializeInfoMSFT(address, container);
    }

    public XrSceneDeserializeInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneDeserializeInfoMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneDeserializeInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSceneDeserializeInfoMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int fragmentCount() {
        return XrSceneDeserializeInfoMSFT.nfragmentCount(this.address());
    }

    @NativeType(value="XrDeserializeSceneFragmentMSFT const *")
    public @Nullable XrDeserializeSceneFragmentMSFT.Buffer fragments() {
        return XrSceneDeserializeInfoMSFT.nfragments(this.address());
    }

    public XrSceneDeserializeInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneDeserializeInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneDeserializeInfoMSFT type$Default() {
        return this.type(1000098001);
    }

    public XrSceneDeserializeInfoMSFT next(@NativeType(value="void const *") long value) {
        XrSceneDeserializeInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneDeserializeInfoMSFT fragmentCount(@NativeType(value="uint32_t") int value) {
        XrSceneDeserializeInfoMSFT.nfragmentCount(this.address(), value);
        return this;
    }

    public XrSceneDeserializeInfoMSFT fragments(@NativeType(value="XrDeserializeSceneFragmentMSFT const *") @Nullable XrDeserializeSceneFragmentMSFT.Buffer value) {
        XrSceneDeserializeInfoMSFT.nfragments(this.address(), value);
        return this;
    }

    public XrSceneDeserializeInfoMSFT set(int type, long next, int fragmentCount, @Nullable XrDeserializeSceneFragmentMSFT.Buffer fragments) {
        this.type(type);
        this.next(next);
        this.fragmentCount(fragmentCount);
        this.fragments(fragments);
        return this;
    }

    public XrSceneDeserializeInfoMSFT set(XrSceneDeserializeInfoMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneDeserializeInfoMSFT malloc() {
        return new XrSceneDeserializeInfoMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSceneDeserializeInfoMSFT calloc() {
        return new XrSceneDeserializeInfoMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSceneDeserializeInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSceneDeserializeInfoMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrSceneDeserializeInfoMSFT create(long address) {
        return new XrSceneDeserializeInfoMSFT(address, null);
    }

    public static @Nullable XrSceneDeserializeInfoMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneDeserializeInfoMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSceneDeserializeInfoMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneDeserializeInfoMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneDeserializeInfoMSFT malloc(MemoryStack stack) {
        return new XrSceneDeserializeInfoMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneDeserializeInfoMSFT calloc(MemoryStack stack) {
        return new XrSceneDeserializeInfoMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nfragmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAGMENTCOUNT);
    }

    public static @Nullable XrDeserializeSceneFragmentMSFT.Buffer nfragments(long struct) {
        return XrDeserializeSceneFragmentMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)FRAGMENTS), XrSceneDeserializeInfoMSFT.nfragmentCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nfragmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRAGMENTCOUNT, value);
    }

    public static void nfragments(long struct, @Nullable XrDeserializeSceneFragmentMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)FRAGMENTS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneDeserializeInfoMSFT.nfragmentCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneDeserializeInfoMSFT.__struct(XrSceneDeserializeInfoMSFT.__member(4), XrSceneDeserializeInfoMSFT.__member(POINTER_SIZE), XrSceneDeserializeInfoMSFT.__member(4), XrSceneDeserializeInfoMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FRAGMENTCOUNT = layout.offsetof(2);
        FRAGMENTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneDeserializeInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneDeserializeInfoMSFT ELEMENT_FACTORY = XrSceneDeserializeInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSceneDeserializeInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneDeserializeInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSceneDeserializeInfoMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int fragmentCount() {
            return XrSceneDeserializeInfoMSFT.nfragmentCount(this.address());
        }

        @NativeType(value="XrDeserializeSceneFragmentMSFT const *")
        public @Nullable XrDeserializeSceneFragmentMSFT.Buffer fragments() {
            return XrSceneDeserializeInfoMSFT.nfragments(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneDeserializeInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000098001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSceneDeserializeInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer fragmentCount(@NativeType(value="uint32_t") int value) {
            XrSceneDeserializeInfoMSFT.nfragmentCount(this.address(), value);
            return this;
        }

        public Buffer fragments(@NativeType(value="XrDeserializeSceneFragmentMSFT const *") @Nullable XrDeserializeSceneFragmentMSFT.Buffer value) {
            XrSceneDeserializeInfoMSFT.nfragments(this.address(), value);
            return this;
        }
    }
}

