/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrScenePlaneMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrScenePlanesMSFT
extends Struct<XrScenePlanesMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SCENEPLANECOUNT;
    public static final int SCENEPLANES;

    protected XrScenePlanesMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrScenePlanesMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrScenePlanesMSFT(address, container);
    }

    public XrScenePlanesMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrScenePlanesMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrScenePlanesMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrScenePlanesMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int scenePlaneCount() {
        return XrScenePlanesMSFT.nscenePlaneCount(this.address());
    }

    @NativeType(value="XrScenePlaneMSFT *")
    public @Nullable XrScenePlaneMSFT.Buffer scenePlanes() {
        return XrScenePlanesMSFT.nscenePlanes(this.address());
    }

    public XrScenePlanesMSFT type(@NativeType(value="XrStructureType") int value) {
        XrScenePlanesMSFT.ntype(this.address(), value);
        return this;
    }

    public XrScenePlanesMSFT type$Default() {
        return this.type(1000097011);
    }

    public XrScenePlanesMSFT next(@NativeType(value="void *") long value) {
        XrScenePlanesMSFT.nnext(this.address(), value);
        return this;
    }

    public XrScenePlanesMSFT scenePlaneCount(@NativeType(value="uint32_t") int value) {
        XrScenePlanesMSFT.nscenePlaneCount(this.address(), value);
        return this;
    }

    public XrScenePlanesMSFT scenePlanes(@NativeType(value="XrScenePlaneMSFT *") @Nullable XrScenePlaneMSFT.Buffer value) {
        XrScenePlanesMSFT.nscenePlanes(this.address(), value);
        return this;
    }

    public XrScenePlanesMSFT set(int type, long next, int scenePlaneCount, @Nullable XrScenePlaneMSFT.Buffer scenePlanes) {
        this.type(type);
        this.next(next);
        this.scenePlaneCount(scenePlaneCount);
        this.scenePlanes(scenePlanes);
        return this;
    }

    public XrScenePlanesMSFT set(XrScenePlanesMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrScenePlanesMSFT malloc() {
        return new XrScenePlanesMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrScenePlanesMSFT calloc() {
        return new XrScenePlanesMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrScenePlanesMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrScenePlanesMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrScenePlanesMSFT create(long address) {
        return new XrScenePlanesMSFT(address, null);
    }

    public static @Nullable XrScenePlanesMSFT createSafe(long address) {
        return address == 0L ? null : new XrScenePlanesMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrScenePlanesMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrScenePlanesMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrScenePlanesMSFT malloc(MemoryStack stack) {
        return new XrScenePlanesMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrScenePlanesMSFT calloc(MemoryStack stack) {
        return new XrScenePlanesMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nscenePlaneCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SCENEPLANECOUNT);
    }

    public static @Nullable XrScenePlaneMSFT.Buffer nscenePlanes(long struct) {
        return XrScenePlaneMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)SCENEPLANES), XrScenePlanesMSFT.nscenePlaneCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nscenePlaneCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SCENEPLANECOUNT, value);
    }

    public static void nscenePlanes(long struct, @Nullable XrScenePlaneMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)SCENEPLANES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrScenePlanesMSFT.nscenePlaneCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrScenePlanesMSFT.__struct(XrScenePlanesMSFT.__member(4), XrScenePlanesMSFT.__member(POINTER_SIZE), XrScenePlanesMSFT.__member(4), XrScenePlanesMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SCENEPLANECOUNT = layout.offsetof(2);
        SCENEPLANES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrScenePlanesMSFT, Buffer>
    implements NativeResource {
        private static final XrScenePlanesMSFT ELEMENT_FACTORY = XrScenePlanesMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrScenePlanesMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrScenePlanesMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrScenePlanesMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int scenePlaneCount() {
            return XrScenePlanesMSFT.nscenePlaneCount(this.address());
        }

        @NativeType(value="XrScenePlaneMSFT *")
        public @Nullable XrScenePlaneMSFT.Buffer scenePlanes() {
            return XrScenePlanesMSFT.nscenePlanes(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrScenePlanesMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097011);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrScenePlanesMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer scenePlaneCount(@NativeType(value="uint32_t") int value) {
            XrScenePlanesMSFT.nscenePlaneCount(this.address(), value);
            return this;
        }

        public Buffer scenePlanes(@NativeType(value="XrScenePlaneMSFT *") @Nullable XrScenePlaneMSFT.Buffer value) {
            XrScenePlanesMSFT.nscenePlanes(this.address(), value);
            return this;
        }
    }
}

