/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSemanticLabelsFB
extends Struct<XrSemanticLabelsFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BUFFERCAPACITYINPUT;
    public static final int BUFFERCOUNTOUTPUT;
    public static final int BUFFER;

    protected XrSemanticLabelsFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSemanticLabelsFB create(long address, @Nullable ByteBuffer container) {
        return new XrSemanticLabelsFB(address, container);
    }

    public XrSemanticLabelsFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSemanticLabelsFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSemanticLabelsFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSemanticLabelsFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferCapacityInput() {
        return XrSemanticLabelsFB.nbufferCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferCountOutput() {
        return XrSemanticLabelsFB.nbufferCountOutput(this.address());
    }

    @NativeType(value="char *")
    public @Nullable ByteBuffer buffer() {
        return XrSemanticLabelsFB.nbuffer(this.address());
    }

    public XrSemanticLabelsFB type(@NativeType(value="XrStructureType") int value) {
        XrSemanticLabelsFB.ntype(this.address(), value);
        return this;
    }

    public XrSemanticLabelsFB type$Default() {
        return this.type(1000175000);
    }

    public XrSemanticLabelsFB next(@NativeType(value="void const *") long value) {
        XrSemanticLabelsFB.nnext(this.address(), value);
        return this;
    }

    public XrSemanticLabelsFB bufferCapacityInput(@NativeType(value="uint32_t") int value) {
        XrSemanticLabelsFB.nbufferCapacityInput(this.address(), value);
        return this;
    }

    public XrSemanticLabelsFB bufferCountOutput(@NativeType(value="uint32_t") int value) {
        XrSemanticLabelsFB.nbufferCountOutput(this.address(), value);
        return this;
    }

    public XrSemanticLabelsFB buffer(@NativeType(value="char *") @Nullable ByteBuffer value) {
        XrSemanticLabelsFB.nbuffer(this.address(), value);
        return this;
    }

    public XrSemanticLabelsFB set(int type, long next, int bufferCapacityInput, int bufferCountOutput, @Nullable ByteBuffer buffer) {
        this.type(type);
        this.next(next);
        this.bufferCapacityInput(bufferCapacityInput);
        this.bufferCountOutput(bufferCountOutput);
        this.buffer(buffer);
        return this;
    }

    public XrSemanticLabelsFB set(XrSemanticLabelsFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSemanticLabelsFB malloc() {
        return new XrSemanticLabelsFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSemanticLabelsFB calloc() {
        return new XrSemanticLabelsFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSemanticLabelsFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSemanticLabelsFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSemanticLabelsFB create(long address) {
        return new XrSemanticLabelsFB(address, null);
    }

    public static @Nullable XrSemanticLabelsFB createSafe(long address) {
        return address == 0L ? null : new XrSemanticLabelsFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSemanticLabelsFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSemanticLabelsFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSemanticLabelsFB malloc(MemoryStack stack) {
        return new XrSemanticLabelsFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSemanticLabelsFB calloc(MemoryStack stack) {
        return new XrSemanticLabelsFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nbufferCapacityInput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUFFERCAPACITYINPUT);
    }

    public static int nbufferCountOutput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUFFERCOUNTOUTPUT);
    }

    public static @Nullable ByteBuffer nbuffer(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)BUFFER), XrSemanticLabelsFB.nbufferCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbufferCapacityInput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BUFFERCAPACITYINPUT, value);
    }

    public static void nbufferCountOutput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BUFFERCOUNTOUTPUT, value);
    }

    public static void nbuffer(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)BUFFER, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSemanticLabelsFB.nbufferCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSemanticLabelsFB.__struct(XrSemanticLabelsFB.__member(4), XrSemanticLabelsFB.__member(POINTER_SIZE), XrSemanticLabelsFB.__member(4), XrSemanticLabelsFB.__member(4), XrSemanticLabelsFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BUFFERCAPACITYINPUT = layout.offsetof(2);
        BUFFERCOUNTOUTPUT = layout.offsetof(3);
        BUFFER = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSemanticLabelsFB, Buffer>
    implements NativeResource {
        private static final XrSemanticLabelsFB ELEMENT_FACTORY = XrSemanticLabelsFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSemanticLabelsFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSemanticLabelsFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSemanticLabelsFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferCapacityInput() {
            return XrSemanticLabelsFB.nbufferCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferCountOutput() {
            return XrSemanticLabelsFB.nbufferCountOutput(this.address());
        }

        @NativeType(value="char *")
        public @Nullable ByteBuffer buffer() {
            return XrSemanticLabelsFB.nbuffer(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSemanticLabelsFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000175000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSemanticLabelsFB.nnext(this.address(), value);
            return this;
        }

        public Buffer bufferCapacityInput(@NativeType(value="uint32_t") int value) {
            XrSemanticLabelsFB.nbufferCapacityInput(this.address(), value);
            return this;
        }

        public Buffer bufferCountOutput(@NativeType(value="uint32_t") int value) {
            XrSemanticLabelsFB.nbufferCountOutput(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="char *") @Nullable ByteBuffer value) {
            XrSemanticLabelsFB.nbuffer(this.address(), value);
            return this;
        }
    }
}

