/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrShareSpacesRecipientBaseHeaderMETA;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrShareSpacesInfoMETA
extends Struct<XrShareSpacesInfoMETA>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACECOUNT;
    public static final int SPACES;
    public static final int RECIPIENTINFO;

    protected XrShareSpacesInfoMETA(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrShareSpacesInfoMETA create(long address, @Nullable ByteBuffer container) {
        return new XrShareSpacesInfoMETA(address, container);
    }

    public XrShareSpacesInfoMETA(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrShareSpacesInfoMETA.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrShareSpacesInfoMETA.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrShareSpacesInfoMETA.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int spaceCount() {
        return XrShareSpacesInfoMETA.nspaceCount(this.address());
    }

    @NativeType(value="XrSpace *")
    public PointerBuffer spaces() {
        return XrShareSpacesInfoMETA.nspaces(this.address());
    }

    @NativeType(value="XrShareSpacesRecipientBaseHeaderMETA const *")
    public XrShareSpacesRecipientBaseHeaderMETA recipientInfo() {
        return XrShareSpacesInfoMETA.nrecipientInfo(this.address());
    }

    public XrShareSpacesInfoMETA type(@NativeType(value="XrStructureType") int value) {
        XrShareSpacesInfoMETA.ntype(this.address(), value);
        return this;
    }

    public XrShareSpacesInfoMETA type$Default() {
        return this.type(1000290001);
    }

    public XrShareSpacesInfoMETA next(@NativeType(value="void const *") long value) {
        XrShareSpacesInfoMETA.nnext(this.address(), value);
        return this;
    }

    public XrShareSpacesInfoMETA spaces(@NativeType(value="XrSpace *") PointerBuffer value) {
        XrShareSpacesInfoMETA.nspaces(this.address(), value);
        return this;
    }

    public XrShareSpacesInfoMETA recipientInfo(@NativeType(value="XrShareSpacesRecipientBaseHeaderMETA const *") XrShareSpacesRecipientBaseHeaderMETA value) {
        XrShareSpacesInfoMETA.nrecipientInfo(this.address(), value);
        return this;
    }

    public XrShareSpacesInfoMETA set(int type, long next, PointerBuffer spaces, XrShareSpacesRecipientBaseHeaderMETA recipientInfo) {
        this.type(type);
        this.next(next);
        this.spaces(spaces);
        this.recipientInfo(recipientInfo);
        return this;
    }

    public XrShareSpacesInfoMETA set(XrShareSpacesInfoMETA src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrShareSpacesInfoMETA malloc() {
        return new XrShareSpacesInfoMETA(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrShareSpacesInfoMETA calloc() {
        return new XrShareSpacesInfoMETA(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrShareSpacesInfoMETA create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrShareSpacesInfoMETA(MemoryUtil.memAddress(container), container);
    }

    public static XrShareSpacesInfoMETA create(long address) {
        return new XrShareSpacesInfoMETA(address, null);
    }

    public static @Nullable XrShareSpacesInfoMETA createSafe(long address) {
        return address == 0L ? null : new XrShareSpacesInfoMETA(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrShareSpacesInfoMETA.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrShareSpacesInfoMETA.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrShareSpacesInfoMETA malloc(MemoryStack stack) {
        return new XrShareSpacesInfoMETA(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrShareSpacesInfoMETA calloc(MemoryStack stack) {
        return new XrShareSpacesInfoMETA(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nspaceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPACECOUNT);
    }

    public static PointerBuffer nspaces(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)SPACES), XrShareSpacesInfoMETA.nspaceCount(struct));
    }

    public static XrShareSpacesRecipientBaseHeaderMETA nrecipientInfo(long struct) {
        return XrShareSpacesRecipientBaseHeaderMETA.create(MemoryUtil.memGetAddress(struct + (long)RECIPIENTINFO));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nspaceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SPACECOUNT, value);
    }

    public static void nspaces(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SPACES, MemoryUtil.memAddress(value));
        XrShareSpacesInfoMETA.nspaceCount(struct, value.remaining());
    }

    public static void nrecipientInfo(long struct, XrShareSpacesRecipientBaseHeaderMETA value) {
        MemoryUtil.memPutAddress(struct + (long)RECIPIENTINFO, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACES));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)RECIPIENTINFO));
    }

    static {
        Struct.Layout layout = XrShareSpacesInfoMETA.__struct(XrShareSpacesInfoMETA.__member(4), XrShareSpacesInfoMETA.__member(POINTER_SIZE), XrShareSpacesInfoMETA.__member(4), XrShareSpacesInfoMETA.__member(POINTER_SIZE), XrShareSpacesInfoMETA.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACECOUNT = layout.offsetof(2);
        SPACES = layout.offsetof(3);
        RECIPIENTINFO = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrShareSpacesInfoMETA, Buffer>
    implements NativeResource {
        private static final XrShareSpacesInfoMETA ELEMENT_FACTORY = XrShareSpacesInfoMETA.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrShareSpacesInfoMETA getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrShareSpacesInfoMETA.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrShareSpacesInfoMETA.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int spaceCount() {
            return XrShareSpacesInfoMETA.nspaceCount(this.address());
        }

        @NativeType(value="XrSpace *")
        public PointerBuffer spaces() {
            return XrShareSpacesInfoMETA.nspaces(this.address());
        }

        @NativeType(value="XrShareSpacesRecipientBaseHeaderMETA const *")
        public XrShareSpacesRecipientBaseHeaderMETA recipientInfo() {
            return XrShareSpacesInfoMETA.nrecipientInfo(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrShareSpacesInfoMETA.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000290001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrShareSpacesInfoMETA.nnext(this.address(), value);
            return this;
        }

        public Buffer spaces(@NativeType(value="XrSpace *") PointerBuffer value) {
            XrShareSpacesInfoMETA.nspaces(this.address(), value);
            return this;
        }

        public Buffer recipientInfo(@NativeType(value="XrShareSpacesRecipientBaseHeaderMETA const *") XrShareSpacesRecipientBaseHeaderMETA value) {
            XrShareSpacesInfoMETA.nrecipientInfo(this.address(), value);
            return this;
        }
    }
}

