/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceEraseInfoFB
extends Struct<XrSpaceEraseInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACE;
    public static final int LOCATION;

    protected XrSpaceEraseInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceEraseInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceEraseInfoFB(address, container);
    }

    public XrSpaceEraseInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpaceEraseInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceEraseInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceEraseInfoFB.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrSpaceEraseInfoFB.nspace(this.address());
    }

    @NativeType(value="XrSpaceStorageLocationFB")
    public int location() {
        return XrSpaceEraseInfoFB.nlocation(this.address());
    }

    public XrSpaceEraseInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceEraseInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceEraseInfoFB type$Default() {
        return this.type(1000158001);
    }

    public XrSpaceEraseInfoFB next(@NativeType(value="void const *") long value) {
        XrSpaceEraseInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceEraseInfoFB space(XrSpace value) {
        XrSpaceEraseInfoFB.nspace(this.address(), value);
        return this;
    }

    public XrSpaceEraseInfoFB location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
        XrSpaceEraseInfoFB.nlocation(this.address(), value);
        return this;
    }

    public XrSpaceEraseInfoFB set(int type, long next, XrSpace space, int location) {
        this.type(type);
        this.next(next);
        this.space(space);
        this.location(location);
        return this;
    }

    public XrSpaceEraseInfoFB set(XrSpaceEraseInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceEraseInfoFB malloc() {
        return new XrSpaceEraseInfoFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceEraseInfoFB calloc() {
        return new XrSpaceEraseInfoFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceEraseInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceEraseInfoFB(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceEraseInfoFB create(long address) {
        return new XrSpaceEraseInfoFB(address, null);
    }

    public static @Nullable XrSpaceEraseInfoFB createSafe(long address) {
        return address == 0L ? null : new XrSpaceEraseInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceEraseInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceEraseInfoFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceEraseInfoFB malloc(MemoryStack stack) {
        return new XrSpaceEraseInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceEraseInfoFB calloc(MemoryStack stack) {
        return new XrSpaceEraseInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static int nlocation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOCATION);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void nlocation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOCATION, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
    }

    static {
        Struct.Layout layout = XrSpaceEraseInfoFB.__struct(XrSpaceEraseInfoFB.__member(4), XrSpaceEraseInfoFB.__member(POINTER_SIZE), XrSpaceEraseInfoFB.__member(POINTER_SIZE), XrSpaceEraseInfoFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACE = layout.offsetof(2);
        LOCATION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceEraseInfoFB, Buffer>
    implements NativeResource {
        private static final XrSpaceEraseInfoFB ELEMENT_FACTORY = XrSpaceEraseInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceEraseInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceEraseInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceEraseInfoFB.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrSpaceEraseInfoFB.nspace(this.address());
        }

        @NativeType(value="XrSpaceStorageLocationFB")
        public int location() {
            return XrSpaceEraseInfoFB.nlocation(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceEraseInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000158001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceEraseInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrSpaceEraseInfoFB.nspace(this.address(), value);
            return this;
        }

        public Buffer location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
            XrSpaceEraseInfoFB.nlocation(this.address(), value);
            return this;
        }
    }
}

