/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpaceLocationData;
import org.lwjgl.openxr.XrSpaceLocations;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class XrSpaceLocationsKHR
extends XrSpaceLocations {
    protected XrSpaceLocationsKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpaceLocationsKHR create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceLocationsKHR(address, container);
    }

    public XrSpaceLocationsKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public XrSpaceLocationsKHR type(@NativeType(value="XrStructureType") int value) {
        XrSpaceLocationsKHR.ntype(this.address(), value);
        return this;
    }

    @Override
    public XrSpaceLocationsKHR type$Default() {
        return this.type(1000471001);
    }

    @Override
    public XrSpaceLocationsKHR next(@NativeType(value="void *") long value) {
        XrSpaceLocationsKHR.nnext(this.address(), value);
        return this;
    }

    @Override
    public XrSpaceLocationsKHR locations(@NativeType(value="XrSpaceLocationData *") XrSpaceLocationData.Buffer value) {
        XrSpaceLocationsKHR.nlocations(this.address(), value);
        return this;
    }

    @Override
    public XrSpaceLocationsKHR set(int type, long next, XrSpaceLocationData.Buffer locations) {
        this.type(type);
        this.next(next);
        this.locations(locations);
        return this;
    }

    public XrSpaceLocationsKHR set(XrSpaceLocationsKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceLocationsKHR malloc() {
        return new XrSpaceLocationsKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrSpaceLocationsKHR calloc() {
        return new XrSpaceLocationsKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrSpaceLocationsKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrSpaceLocationsKHR(MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceLocationsKHR create(long address) {
        return new XrSpaceLocationsKHR(address, null);
    }

    public static @Nullable XrSpaceLocationsKHR createSafe(long address) {
        return address == 0L ? null : new XrSpaceLocationsKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrSpaceLocationsKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceLocationsKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceLocationsKHR malloc(MemoryStack stack) {
        return new XrSpaceLocationsKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceLocationsKHR calloc(MemoryStack stack) {
        return new XrSpaceLocationsKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends XrSpaceLocations.Buffer {
        private static final XrSpaceLocationsKHR ELEMENT_FACTORY = XrSpaceLocationsKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpaceLocationsKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceLocationsKHR.ntype(this.address(), value);
            return this;
        }

        @Override
        public Buffer type$Default() {
            return this.type(1000471001);
        }

        @Override
        public Buffer next(@NativeType(value="void *") long value) {
            XrSpaceLocationsKHR.nnext(this.address(), value);
            return this;
        }

        @Override
        public Buffer locations(@NativeType(value="XrSpaceLocationData *") XrSpaceLocationData.Buffer value) {
            XrSpaceLocationsKHR.nlocations(this.address(), value);
            return this;
        }
    }
}

